/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.util;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.z2six.ezactions.Constants;

public final class KeyMappingLookup {
    private KeyMappingLookup() {
    }

    @Nullable
    public static KeyMapping findByName(String mappingName) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return null;
            }
            Options opts = mc.options;
            if (opts == null || opts.keyMappings == null) {
                return null;
            }
            for (KeyMapping km : opts.keyMappings) {
                if (km == null || !mappingName.equals(km.getName())) continue;
                return km;
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] KeyMappingLookup.findByName failed for '{}': {}", new Object[]{"EZActions", mappingName, t.toString()});
        }
        return null;
    }

    public static Component localizedName(KeyMapping mapping) {
        try {
            String key = mapping.getName();
            return Component.literal((String)I18n.get((String)key, (Object[])new Object[0]));
        }
        catch (Throwable t) {
            return Component.literal((String)mapping.getName());
        }
    }

    @Nullable
    public static Integer glfwKey(KeyMapping mapping) {
        try {
            InputConstants.Key key = mapping.getKey();
            if (key == null) {
                return null;
            }
            if (key.getType() != InputConstants.Type.KEYSYM) {
                return null;
            }
            return key.getValue();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Failed to resolve GLFW key for '{}': {}", new Object[]{"EZActions", mapping.getName(), t.toString()});
            return null;
        }
    }

    @Nullable
    public static Integer glfwScancode(@Nullable Integer glfwKey) {
        try {
            if (glfwKey == null) {
                return null;
            }
            int scan = GLFW.glfwGetKeyScancode((int)glfwKey);
            return scan == 0 ? null : Integer.valueOf(scan);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Failed to resolve scancode for key {}: {}", new Object[]{"EZActions", glfwKey, t.toString()});
            return null;
        }
    }
}

