/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.api.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.api.MenuPath;
import org.z2six.ezactions.api.MenuWrite;
import org.z2six.ezactions.api.internal.JsonCodec;
import org.z2six.ezactions.api.internal.TreeOps;
import org.z2six.ezactions.api.model.ApiMenuItem;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;

final class MenuWriteImpl
implements MenuWrite {
    MenuWriteImpl() {
    }

    @Override
    public boolean moveWithin(MenuPath path, int fromIndex, int toIndex) {
        MenuItem moved;
        List<MenuItem> at;
        List<MenuItem> root = RadialMenu.rootMutable();
        List<MenuItem> list = at = path == null || path.titles().isEmpty() ? root : TreeOps.findBundleByTitles(root, path.titles());
        if (at == null) {
            return false;
        }
        int n = at.size();
        if (n == 0) {
            return false;
        }
        if (fromIndex < 0 || fromIndex >= n) {
            return false;
        }
        if (toIndex < 0) {
            toIndex = 0;
        }
        if (toIndex > n) {
            toIndex = n;
        }
        if ((moved = at.remove(fromIndex)) == null) {
            return false;
        }
        if (toIndex > fromIndex) {
            --toIndex;
        }
        at.add(toIndex, moved);
        try {
            RadialMenu.persist();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean moveTo(String itemId, MenuPath targetBundle) {
        List<MenuItem> dst;
        if (itemId == null || itemId.isBlank()) {
            return false;
        }
        List<MenuItem> root = RadialMenu.rootMutable();
        Holder src = MenuWriteImpl.findParentAndItem(root, itemId);
        if (src == null || src.item == null || src.parent == null) {
            return false;
        }
        List<MenuItem> list = dst = targetBundle == null || targetBundle.titles().isEmpty() ? root : TreeOps.findBundleByTitles(root, targetBundle.titles());
        if (dst == null) {
            return false;
        }
        if (src.index >= 0 && src.index < src.parent.size()) {
            MenuItem removed = src.parent.remove(src.index);
            dst.add(removed);
            try {
                RadialMenu.persist();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFirst(MenuPath path, Predicate<ApiMenuItem> predicate) {
        List<MenuItem> at;
        List<MenuItem> root = RadialMenu.rootMutable();
        List<MenuItem> list = at = path == null || path.titles().isEmpty() ? root : TreeOps.findBundleByTitles(root, path.titles());
        if (at == null || predicate == null) {
            return false;
        }
        for (int i = 0; i < at.size(); ++i) {
            MenuItem mi = at.get(i);
            ApiMenuItem snap = new ApiMenuItem(MenuWriteImpl.safe(mi.id()), MenuWriteImpl.safe(mi.title()), mi.isCategory(), mi.isCategory() ? "BUNDLE" : "ACTION", mi.note(), null);
            if (!predicate.test(snap)) continue;
            at.remove(i);
            try {
                RadialMenu.persist();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeById(String id) {
        boolean ok = TreeOps.removeByIdRecursive(RadialMenu.rootMutable(), id);
        if (ok) {
            try {
                RadialMenu.persist();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ok;
    }

    @Override
    public boolean ensureBundles(MenuPath path) {
        List<MenuItem> root;
        if (path == null || path.titles().isEmpty()) {
            return false;
        }
        List<MenuItem> cur = root = RadialMenu.rootMutable();
        boolean createdAny = false;
        for (String title : path.titles()) {
            MenuItem found = null;
            if (cur != null) {
                for (MenuItem mi : cur) {
                    if (mi == null || !mi.isCategory() || !MenuWriteImpl.safe(mi.title()).equals(title)) continue;
                    found = mi;
                    break;
                }
            }
            if (found == null) {
                MenuItem cat = new MenuItem(MenuWriteImpl.freshId("bundle"), title, "", null, null, new ArrayList<MenuItem>());
                if (cur == null) {
                    Constants.LOG.warn("[{}] ensureBundles: no current list; aborting", (Object)"ezactions");
                    return createdAny;
                }
                cur.add(cat);
                createdAny = true;
                cur = TreeOps.childrenOf(cat);
                continue;
            }
            cur = TreeOps.childrenOf(found);
        }
        if (createdAny) {
            try {
                RadialMenu.persist();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return createdAny;
    }

    @Override
    public Optional<String> upsertFromJson(MenuPath path, String jsonItemOrArray) {
        try {
            List<MenuItem> at;
            List<MenuItem> root = RadialMenu.rootMutable();
            List<MenuItem> list = at = path == null || path.titles().isEmpty() ? root : TreeOps.findBundleByTitles(root, path.titles());
            if (at == null) {
                return Optional.empty();
            }
            JsonElement el = JsonParser.parseString((String)(jsonItemOrArray == null ? "[]" : jsonItemOrArray.trim()));
            ArrayList<MenuItem> incoming = new ArrayList<MenuItem>();
            if (el.isJsonObject()) {
                incoming.add(JsonCodec.fromJson(el.getAsJsonObject()));
            } else if (el.isJsonArray()) {
                JsonArray arr = el.getAsJsonArray();
                for (JsonElement e : arr) {
                    if (!e.isJsonObject()) continue;
                    incoming.add(JsonCodec.fromJson(e.getAsJsonObject()));
                }
            } else {
                return Optional.empty();
            }
            String lastId = null;
            for (MenuItem item : incoming) {
                String id = MenuWriteImpl.safe(item.id());
                if (!id.isEmpty()) {
                    int idx = MenuWriteImpl.indexOfId(at, id);
                    if (idx >= 0) {
                        at.set(idx, item);
                    } else {
                        at.add(item);
                    }
                    lastId = id;
                    continue;
                }
                String gen = MenuWriteImpl.freshId("api");
                MenuItem withId = new MenuItem(gen, item.title(), item.note(), item.icon(), item.action(), item.children());
                at.add(withId);
                lastId = gen;
            }
            try {
                RadialMenu.persist();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return Optional.ofNullable(lastId);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] upsertFromJson failed: {}", (Object)"ezactions", (Object)t.toString());
            return Optional.empty();
        }
    }

    private static int indexOfId(List<MenuItem> list, String id) {
        if (list == null || id == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            MenuItem mi = list.get(i);
            if (mi == null || !id.equals(mi.id())) continue;
            return i;
        }
        return -1;
    }

    private static Holder findParentAndItem(List<MenuItem> root, String id) {
        if (root == null || id == null) {
            return null;
        }
        for (int i = 0; i < root.size(); ++i) {
            MenuItem mi = root.get(i);
            if (mi == null || !id.equals(mi.id())) continue;
            return new Holder(root, i, mi);
        }
        for (MenuItem mi : root) {
            List<MenuItem> sub;
            Holder h;
            if (mi == null || !mi.isCategory() || (h = MenuWriteImpl.findParentAndItem(sub = TreeOps.childrenOf(mi), id)) == null) continue;
            return h;
        }
        return null;
    }

    private static String freshId(String prefix) {
        long t = System.currentTimeMillis();
        return prefix + "_" + Long.toHexString(t) + "_" + Integer.toHexString((int)(Math.random() * 65535.0));
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static final class Holder {
        final List<MenuItem> parent;
        final int index;
        final MenuItem item;

        Holder(List<MenuItem> p, int i, MenuItem m) {
            this.parent = p;
            this.index = i;
            this.item = m;
        }
    }
}

