/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.DesignClientConfig;

public final class RadialConfig {
    private static final Gson G = new GsonBuilder().setPrettyPrinting().create();
    private static RadialConfig INSTANCE;
    public int deadzone = 18;
    public int baseOuterRadius = 72;
    public int ringThickness = 28;
    public int scaleStartThreshold = 8;
    public int scalePerItem = 6;
    public int ringColor = -1442840576;
    public int hoverColor = -917436;
    private static final String NEW_FILE = "design-client.toml";
    private static final String LEGACY_JSON = "radial.json";

    private RadialConfig() {
    }

    public static RadialConfig get() {
        if (INSTANCE == null) {
            INSTANCE = RadialConfig.loadPreferringSpec();
        }
        return INSTANCE;
    }

    private static RadialConfig loadPreferringSpec() {
        try {
            if (DesignClientConfig.SPEC != null) {
                RadialConfig c = new RadialConfig();
                c.deadzone = (Integer)DesignClientConfig.deadzone.get();
                c.baseOuterRadius = (Integer)DesignClientConfig.baseOuterRadius.get();
                c.ringThickness = (Integer)DesignClientConfig.ringThickness.get();
                c.scaleStartThreshold = (Integer)DesignClientConfig.scaleStartThreshold.get();
                c.scalePerItem = (Integer)DesignClientConfig.scalePerItem.get();
                c.ringColor = (Integer)DesignClientConfig.ringColor.get();
                c.hoverColor = (Integer)DesignClientConfig.hoverColor.get();
                return c;
            }
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] Spec not ready, falling back to file: {}", (Object)"ezactions", (Object)t.toString());
        }
        return RadialConfig.loadOrCreateFromFile();
    }

    private static RadialConfig loadOrCreateFromFile() {
        Path toml = RadialConfig.tomlFile();
        Path legacy = RadialConfig.legacyFile();
        if (Files.exists(toml, new LinkOption[0])) {
            RadialConfig radialConfig;
            block28: {
                CommentedFileConfig cfg = CommentedFileConfig.of((Path)toml, (ConfigFormat)TomlFormat.instance());
                try {
                    cfg.load();
                    RadialConfig c = new RadialConfig();
                    c.deadzone = RadialConfig.getInt(cfg, "deadzone", c.deadzone);
                    c.baseOuterRadius = RadialConfig.getInt(cfg, "baseOuterRadius", c.baseOuterRadius);
                    c.ringThickness = RadialConfig.getInt(cfg, "ringThickness", c.ringThickness);
                    c.scaleStartThreshold = RadialConfig.getInt(cfg, "scaleStartThreshold", c.scaleStartThreshold);
                    c.scalePerItem = RadialConfig.getInt(cfg, "scalePerItem", c.scalePerItem);
                    c.ringColor = RadialConfig.getColor(cfg, "ringColor", c.ringColor);
                    c.hoverColor = RadialConfig.getColor(cfg, "hoverColor", c.hoverColor);
                    radialConfig = c;
                    if (cfg == null) break block28;
                }
                catch (Throwable c) {
                    try {
                        if (cfg != null) {
                            try {
                                cfg.close();
                            }
                            catch (Throwable throwable) {
                                c.addSuppressed(throwable);
                            }
                        }
                        throw c;
                    }
                    catch (Throwable t) {
                        Constants.LOG.warn("[{}] Failed to load {}: {} (writing defaults)", new Object[]{"ezactions", toml, t.toString()});
                        RadialConfig c2 = new RadialConfig();
                        RadialConfig.save(c2);
                        return c2;
                    }
                }
                cfg.close();
            }
            return radialConfig;
        }
        if (Files.exists(legacy, new LinkOption[0])) {
            RadialConfig radialConfig;
            block29: {
                BufferedReader r = Files.newBufferedReader(legacy, StandardCharsets.UTF_8);
                try {
                    JsonObject o = (JsonObject)G.fromJson((Reader)r, JsonObject.class);
                    RadialConfig c = new RadialConfig();
                    if (o != null) {
                        if (o.has("deadzone")) {
                            c.deadzone = RadialConfig.safeInt(o.get("deadzone"), c.deadzone);
                        }
                        if (o.has("baseOuterRadius")) {
                            c.baseOuterRadius = RadialConfig.safeInt(o.get("baseOuterRadius"), c.baseOuterRadius);
                        }
                        if (o.has("ringThickness")) {
                            c.ringThickness = RadialConfig.safeInt(o.get("ringThickness"), c.ringThickness);
                        }
                        if (o.has("scaleStartThreshold")) {
                            c.scaleStartThreshold = RadialConfig.safeInt(o.get("scaleStartThreshold"), c.scaleStartThreshold);
                        }
                        if (o.has("scalePerItem")) {
                            c.scalePerItem = RadialConfig.safeInt(o.get("scalePerItem"), c.scalePerItem);
                        }
                        if (o.has("ringColor")) {
                            c.ringColor = RadialConfig.parseColor(o.get("ringColor").getAsString(), c.ringColor);
                        }
                        if (o.has("hoverColor")) {
                            c.hoverColor = RadialConfig.parseColor(o.get("hoverColor").getAsString(), c.hoverColor);
                        }
                    }
                    RadialConfig.save(c);
                    try {
                        Files.move(legacy, legacy.resolveSibling("radial.json.bak"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    radialConfig = c;
                    if (r == null) break block29;
                }
                catch (Throwable o) {
                    try {
                        if (r != null) {
                            try {
                                ((Reader)r).close();
                            }
                            catch (Throwable throwable) {
                                o.addSuppressed(throwable);
                            }
                        }
                        throw o;
                    }
                    catch (Throwable t) {
                        Constants.LOG.warn("[{}] Failed to migrate {}: {}", new Object[]{"ezactions", legacy, t.toString()});
                        RadialConfig c = new RadialConfig();
                        RadialConfig.save(c);
                        return c;
                    }
                }
                ((Reader)r).close();
            }
            return radialConfig;
        }
        RadialConfig c = new RadialConfig();
        RadialConfig.save(c);
        return c;
    }

    public static void save(RadialConfig c) {
        try {
            if (DesignClientConfig.SPEC != null) {
                DesignClientConfig.deadzone.set((Object)c.deadzone);
                DesignClientConfig.baseOuterRadius.set((Object)c.baseOuterRadius);
                DesignClientConfig.ringThickness.set((Object)c.ringThickness);
                DesignClientConfig.scaleStartThreshold.set((Object)c.scaleStartThreshold);
                DesignClientConfig.scalePerItem.set((Object)c.scalePerItem);
                DesignClientConfig.ringColor.set((Object)c.ringColor);
                DesignClientConfig.hoverColor.set((Object)c.hoverColor);
                return;
            }
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] Could not write DesignClientConfig; falling back to file: {}", (Object)"ezactions", (Object)t.toString());
        }
        Path f = RadialConfig.tomlFile();
        try {
            Files.createDirectories(f.getParent(), new FileAttribute[0]);
            Config root = Config.of((ConfigFormat)TomlFormat.instance());
            root.set("deadzone", (Object)c.deadzone);
            root.set("baseOuterRadius", (Object)c.baseOuterRadius);
            root.set("ringThickness", (Object)c.ringThickness);
            root.set("scaleStartThreshold", (Object)c.scaleStartThreshold);
            root.set("scalePerItem", (Object)c.scalePerItem);
            root.set("ringColor", (Object)c.ringColor);
            root.set("hoverColor", (Object)c.hoverColor);
            try (CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((Path)f, (ConfigFormat)TomlFormat.instance()).sync().preserveInsertionOrder().build();){
                cfg.load();
                cfg.putAll((UnmodifiableConfig)root);
                cfg.save();
            }
        }
        catch (Throwable e) {
            Constants.LOG.warn("[{}] Failed to save {}: {}", new Object[]{"ezactions", f, e.toString()});
        }
    }

    private static Path tomlFile() {
        try {
            Path game = Minecraft.m_91087_().f_91069_.toPath();
            return game.resolve("config").resolve("ezactions").resolve(NEW_FILE);
        }
        catch (Throwable t) {
            return Path.of("config", "ezactions", NEW_FILE);
        }
    }

    private static Path legacyFile() {
        try {
            Path game = Minecraft.m_91087_().f_91069_.toPath();
            return game.resolve("config").resolve("ezactions").resolve(LEGACY_JSON);
        }
        catch (Throwable t) {
            return Path.of("config", "ezactions", LEGACY_JSON);
        }
    }

    private static int getInt(CommentedFileConfig cfg, String key, int dflt) {
        try {
            Object v = cfg.get(key);
            if (v instanceof Number) {
                Number n = (Number)v;
                return n.intValue();
            }
            if (v instanceof String) {
                String s = (String)v;
                return Integer.parseInt(s.trim());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dflt;
    }

    private static int getColor(CommentedFileConfig cfg, String key, int dflt) {
        try {
            Object v = cfg.get(key);
            if (v instanceof Number) {
                Number n = (Number)v;
                return n.intValue();
            }
            if (v instanceof String) {
                String s = (String)v;
                return RadialConfig.parseColor(s, dflt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dflt;
    }

    private static int parseColor(String s, int fallback) {
        try {
            Object t;
            Object object = t = s == null ? "" : s.trim();
            if (((String)t).isEmpty()) {
                return fallback;
            }
            if (((String)t).startsWith("0x") || ((String)t).startsWith("0X")) {
                t = ((String)t).substring(2);
            } else if (((String)t).startsWith("#")) {
                t = ((String)t).substring(1);
            }
            if (((String)t).matches("(?i)^[0-9a-f]{6}$")) {
                t = "FF" + (String)t;
            }
            long val = Long.parseUnsignedLong((String)t, 16);
            return (int)val;
        }
        catch (Throwable e) {
            Constants.LOG.warn("[{}] Bad color literal '{}'; using fallback 0x{}", new Object[]{"ezactions", s, Integer.toHexString(fallback)});
            return fallback;
        }
    }

    private static int safeInt(JsonElement el, int dflt) {
        try {
            return el.getAsInt();
        }
        catch (Throwable ignored) {
            return dflt;
        }
    }
}

