/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.click;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.ClickActionType;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.helper.InputInjector;

public final class ClickActionKey
implements IClickAction {
    private final String mappingName;
    private final boolean toggle;
    private final InputInjector.DeliveryMode mode;

    public ClickActionKey(String mappingName, boolean toggle, InputInjector.DeliveryMode mode) {
        this.mappingName = Objects.requireNonNull(mappingName);
        this.toggle = toggle;
        this.mode = mode == null ? InputInjector.DeliveryMode.AUTO : mode;
    }

    public String mappingName() {
        return this.mappingName;
    }

    public boolean toggle() {
        return this.toggle;
    }

    public InputInjector.DeliveryMode mode() {
        return this.mode;
    }

    @Override
    public boolean execute(Minecraft mc) {
        try {
            Constants.LOG.info("[{}] Key tap: '{}'", (Object)"ezactions", (Object)this.mappingName);
            return InputInjector.deliver(this.mappingName, this.toggle, this.mode);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] ClickActionKey execute failed '{}': {}", new Object[]{"ezactions", this.mappingName, t.toString()});
            return false;
        }
    }

    @Override
    public ClickActionType getType() {
        return ClickActionType.KEY;
    }

    @Override
    public String getId() {
        return "key:" + this.mappingName;
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237113_((String)this.mappingName);
    }

    @Override
    public JsonObject serialize() {
        JsonObject o = new JsonObject();
        o.addProperty("type", "KEY");
        o.addProperty("name", this.mappingName);
        o.addProperty("toggle", Boolean.valueOf(this.toggle));
        o.addProperty("mode", this.mode.name());
        return o;
    }

    public static ClickActionKey deserialize(JsonObject o) {
        String name = o.has("name") ? o.get("name").getAsString() : "key.inventory";
        boolean tog = o.has("toggle") && o.get("toggle").getAsBoolean();
        InputInjector.DeliveryMode dm = InputInjector.DeliveryMode.AUTO;
        if (o.has("mode")) {
            try {
                dm = InputInjector.DeliveryMode.valueOf(o.get("mode").getAsString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new ClickActionKey(name, tog, dm);
    }
}

