/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.util.ClipboardIO;

public final class MenuImportExport {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private MenuImportExport() {
    }

    public static int exportToClipboard() {
        try {
            List<MenuItem> root = RadialMenu.rootMutable();
            if (root == null) {
                Constants.LOG.warn("[{}] Export: root is null.", (Object)"ezactions");
                return -1;
            }
            JsonArray arr = new JsonArray();
            for (MenuItem mi : root) {
                try {
                    JsonObject o = mi.serialize();
                    if (o == null) continue;
                    arr.add((JsonElement)o);
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] Export: skipping item due to serialize error: {}", (Object)"ezactions", (Object)t.toString());
                }
            }
            String json = GSON.toJson((JsonElement)arr);
            boolean ok = ClipboardIO.setClipboard(json);
            if (!ok) {
                Constants.LOG.warn("[{}] Export: failed to write to clipboard.", (Object)"ezactions");
                return -1;
            }
            Constants.LOG.info("[{}] Exported {} menu items to clipboard.", (Object)"ezactions", (Object)arr.size());
            MenuImportExport.safeStatusMessage("Exported " + arr.size() + " items to clipboard.");
            return arr.size();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Export failed: {}", (Object)"ezactions", (Object)t.toString());
            MenuImportExport.safeStatusMessage("Export failed (see log).");
            return -1;
        }
    }

    public static int importFromClipboard() {
        try {
            JsonElement rootEl;
            String text = ClipboardIO.getClipboard();
            if (text == null || text.trim().isEmpty()) {
                Constants.LOG.info("[{}] Import: clipboard empty.", (Object)"ezactions");
                MenuImportExport.safeStatusMessage("Clipboard is empty.");
                return -1;
            }
            try {
                rootEl = JsonParser.parseString((String)text);
            }
            catch (Throwable parseEx) {
                Constants.LOG.info("[{}] Import: clipboard not JSON: {}", (Object)"ezactions", (Object)parseEx.toString());
                MenuImportExport.safeStatusMessage("Clipboard doesn't contain JSON.");
                return -1;
            }
            if (!rootEl.isJsonArray()) {
                Constants.LOG.info("[{}] Import: root must be an array.", (Object)"ezactions");
                MenuImportExport.safeStatusMessage("Import failed: root JSON is not an array.");
                return -1;
            }
            JsonArray arr = rootEl.getAsJsonArray();
            ArrayList<MenuItem> fresh = new ArrayList<MenuItem>(arr.size());
            int idx = 0;
            for (JsonElement el : arr) {
                ++idx;
                if (!el.isJsonObject()) {
                    Constants.LOG.info("[{}] Import: entry #{} is not an object, aborting.", (Object)"ezactions", (Object)idx);
                    MenuImportExport.safeStatusMessage("Import failed: entry #" + idx + " not an object.");
                    return -1;
                }
                JsonObject obj = el.getAsJsonObject();
                try {
                    MenuItem mi = MenuItem.deserialize(obj);
                    if (mi == null) {
                        throw new JsonParseException("deserialize returned null");
                    }
                    fresh.add(mi);
                }
                catch (Throwable t) {
                    Constants.LOG.info("[{}] Import: entry #{} invalid: {}", new Object[]{"ezactions", idx, t.toString()});
                    MenuImportExport.safeStatusMessage("Import failed: entry #" + idx + " invalid.");
                    return -1;
                }
            }
            try {
                List<MenuItem> live = RadialMenu.rootMutable();
                live.clear();
                live.addAll(fresh);
                RadialMenu.persist();
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Import: failed to persist: {}", (Object)"ezactions", (Object)t.toString());
                MenuImportExport.safeStatusMessage("Import failed while saving.");
                return -1;
            }
            Constants.LOG.info("[{}] Imported {} items from clipboard.", (Object)"ezactions", (Object)fresh.size());
            MenuImportExport.safeStatusMessage("Imported " + fresh.size() + " items from clipboard.");
            return fresh.size();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Import failed: {}", (Object)"ezactions", (Object)t.toString());
            MenuImportExport.safeStatusMessage("Import failed (see log).");
            return -1;
        }
    }

    private static void safeStatusMessage(String msg) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null && mc.f_91065_ != null) {
                mc.f_91065_.m_93063_((Component)Component.m_237113_((String)msg), false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

