/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.menu;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.json.MenuLoader;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.gui.RadialMenuScreen;

public final class RadialMenu {
    private static List<MenuItem> ROOT = new ArrayList<MenuItem>();
    private static final Deque<MenuItem> PATH = new ArrayDeque<MenuItem>();

    private RadialMenu() {
    }

    public static void open() {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null || mc.f_91074_ == null || mc.f_91073_ == null) {
                Constants.LOG.debug("[{}] Radial open ignored: client/world not ready (mc={}, player={}, level={}).", new Object[]{"ezactions", mc != null, mc != null && mc.f_91074_ != null, mc != null && mc.f_91073_ != null});
                return;
            }
            if (mc.f_91080_ != null || mc.m_91104_()) {
                String scr = mc.f_91080_ == null ? "none" : mc.f_91080_.getClass().getSimpleName();
                Constants.LOG.debug("[{}] Radial open ignored: screen={}, paused={}", new Object[]{"ezactions", scr, mc.m_91104_()});
                return;
            }
            RadialMenu.ensureLoaded();
            PATH.clear();
            mc.m_91152_((Screen)new RadialMenuScreen());
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Failed to open radial: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public static void resetToRoot() {
        PATH.clear();
    }

    public static void enterCategory(MenuItem cat) {
        if (cat == null || !cat.isCategory()) {
            return;
        }
        PATH.addLast(cat);
    }

    public static boolean canGoBack() {
        return !PATH.isEmpty();
    }

    public static void goBack() {
        if (!PATH.isEmpty()) {
            PATH.removeLast();
        }
    }

    public static List<MenuItem> currentItems() {
        RadialMenu.ensureLoaded();
        List<MenuItem> items = ROOT;
        for (MenuItem cat : PATH) {
            items = cat.childrenMutable();
        }
        return items;
    }

    public static List<String> pathTitles() {
        RadialMenu.ensureLoaded();
        ArrayList<String> out = new ArrayList<String>();
        out.add("root");
        for (MenuItem cat : PATH) {
            String t = cat == null ? "" : (cat.title() == null ? "" : cat.title());
            out.add(t.isEmpty() ? "(unnamed)" : t);
        }
        return out;
    }

    public static void reload() {
        try {
            ROOT = MenuLoader.loadMenu();
            PATH.clear();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] RadialMenu reload failed: {}", (Object)"ezactions", (Object)t.toString());
            ROOT = new ArrayList<MenuItem>();
            PATH.clear();
        }
    }

    private static void ensureLoaded() {
        if (ROOT.isEmpty()) {
            RadialMenu.reload();
        }
    }

    public static List<MenuItem> rootMutable() {
        RadialMenu.ensureLoaded();
        return ROOT;
    }

    public static List<MenuItem> parentItems() {
        RadialMenu.ensureLoaded();
        if (PATH.isEmpty()) {
            return ROOT;
        }
        if (PATH.size() == 1) {
            return ROOT;
        }
        List<MenuItem> items = ROOT;
        int i = 0;
        for (MenuItem cat : PATH) {
            if (i >= PATH.size() - 1) break;
            items = cat.childrenMutable();
            ++i;
        }
        return items;
    }

    public static boolean addToCurrent(MenuItem item) {
        List<MenuItem> cur = RadialMenu.currentItems();
        cur.add(item);
        RadialMenu.persist();
        return true;
    }

    public static boolean removeFromCurrent(String id) {
        List<MenuItem> cur = RadialMenu.currentItems();
        boolean removed = cur.removeIf(mi -> Objects.equals(mi.id(), id));
        if (removed) {
            RadialMenu.persist();
        }
        return removed;
    }

    public static boolean replaceInCurrent(String id, MenuItem replacement) {
        List<MenuItem> cur = RadialMenu.currentItems();
        for (int i = 0; i < cur.size(); ++i) {
            if (!Objects.equals(cur.get(i).id(), id)) continue;
            cur.set(i, replacement);
            RadialMenu.persist();
            return true;
        }
        return false;
    }

    public static boolean moveInCurrent(String id, int delta) {
        List<MenuItem> cur = RadialMenu.currentItems();
        for (int i = 0; i < cur.size(); ++i) {
            if (!Objects.equals(cur.get(i).id(), id)) continue;
            int j = Math.max(0, Math.min(cur.size() - 1, i + delta));
            if (i == j) {
                return false;
            }
            Collections.swap(cur, i, j);
            RadialMenu.persist();
            return true;
        }
        return false;
    }

    public static void persist() {
        try {
            MenuLoader.saveMenu(ROOT);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Failed to persist menu: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public static boolean removeInCurrent(String id) {
        try {
            List<MenuItem> items = RadialMenu.currentItems();
            if (items == null || id == null) {
                return false;
            }
            boolean removed = items.removeIf(mi -> Objects.equals(mi.id(), id));
            if (removed) {
                RadialMenu.persist();
            }
            return removed;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] removeInCurrent failed for '{}': {}", new Object[]{"ezactions", id, t.toString()});
            return false;
        }
    }

    public static boolean moveInCurrent(int from, int to) {
        try {
            List<MenuItem> items = RadialMenu.currentItems();
            if (items == null) {
                return false;
            }
            int n = items.size();
            if (n <= 1) {
                return false;
            }
            if (from < 0 || from >= n) {
                return false;
            }
            if (to < 0) {
                to = 0;
            }
            if (to > n) {
                to = n;
            }
            MenuItem m = items.remove(from);
            if (to > from) {
                --to;
            }
            items.add(to, m);
            RadialMenu.persist();
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] moveInCurrent failed {} -> {}: {}", new Object[]{"ezactions", from, to, t.toString()});
            return false;
        }
    }
}

