/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.icon.IconSpec;

public final class IconRenderer {
    private IconRenderer() {
    }

    public static void drawIcon(GuiGraphics g, int x, int y, IconSpec icon) {
        try {
            if (icon == null) {
                IconRenderer.drawItem(g, x, y, new ItemStack((ItemLike)IconRenderer.getFallbackItem()));
                return;
            }
            switch (icon.kind()) {
                case ITEM: {
                    Item item = IconRenderer.resolveItem(icon.id());
                    IconRenderer.drawItem(g, x, y, new ItemStack((ItemLike)item));
                    break;
                }
                default: {
                    IconRenderer.drawItem(g, x, y, new ItemStack((ItemLike)IconRenderer.getFallbackItem()));
                    break;
                }
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] IconRenderer error for '{}': {}", new Object[]{"ezactions", icon == null ? "<null>" : icon.toString(), t.toString()});
            IconRenderer.drawItem(g, x, y, new ItemStack((ItemLike)IconRenderer.getFallbackItem()));
        }
    }

    private static Item resolveItem(String id) {
        try {
            ResourceLocation rl = ResourceLocation.m_135820_((String)id);
            if (rl == null) {
                return IconRenderer.getFallbackItem();
            }
            Item it = (Item)BuiltInRegistries.f_257033_.m_7745_(rl);
            return it == null ? IconRenderer.getFallbackItem() : it;
        }
        catch (Throwable t) {
            return IconRenderer.getFallbackItem();
        }
    }

    private static Item getFallbackItem() {
        return Items.f_42127_;
    }

    private static void drawItem(GuiGraphics g, int x, int y, ItemStack stack) {
        g.m_280480_(stack, x - 8, y - 8);
    }
}

