/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.RadialAnimConfigView;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.RadialScreenDraw;
import org.z2six.ezactions.gui.RadialScreenMath;
import org.z2six.ezactions.gui.anim.RadialTransition;
import org.z2six.ezactions.gui.anim.SliceHoverAnim;
import org.z2six.ezactions.gui.noblur.NoMenuBlurScreen;
import org.z2six.ezactions.handler.KeyboardHandler;

public final class RadialMenuScreen
extends Screen
implements NoMenuBlurScreen {
    private int hoveredIndex = -1;
    private final RadialTransition openTrans = new RadialTransition();
    private final SliceHoverAnim hoverAnim = new SliceHoverAnim();

    public RadialMenuScreen() {
        super((Component)Component.m_237113_((String)"ezactions Radial"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.openTrans.start(1);
    }

    public boolean m_7043_() {
        return false;
    }

    public void onHotkeyReleased() {
        try {
            MenuItem mi;
            List<MenuItem> items = RadialMenu.currentItems();
            if (items != null && !items.isEmpty() && this.hoveredIndex >= 0 && this.hoveredIndex < items.size() && !(mi = items.get(this.hoveredIndex)).isCategory()) {
                KeyboardHandler.suppressReopenUntilReleased();
                this.executeAndClose(mi);
                return;
            }
            Minecraft.m_91087_().m_91152_(null);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] onHotkeyReleased error: {}", (Object)"ezactions", (Object)t.toString());
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        try {
            List<MenuItem> items = RadialMenu.currentItems();
            int cx = this.f_96543_ / 2;
            int cy = this.f_96544_ / 2;
            int count = items == null ? 0 : items.size();
            RadialScreenMath.Radii rr = RadialScreenMath.computeRadii(count);
            this.hoveredIndex = count <= 0 ? -1 : RadialScreenMath.pickSector(mouseX, mouseY, cx, cy, count, rr);
            this.hoverAnim.tick(System.currentTimeMillis(), this.hoveredIndex, count);
            RadialAnimConfigView view = RadialAnimConfigView.get();
            float openProg = view.animationsEnabled && view.animOpenClose ? this.openTrans.progress() : 1.0f;
            RadialScreenDraw.drawRing(g, this.f_96547_, cx, cy, items, this.hoveredIndex, rr, this.hoverAnim, openProg);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Radial render error: {}", (Object)"ezactions", (Object)t.toString());
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        try {
            if (button == 1) {
                if (RadialMenu.canGoBack()) {
                    RadialMenu.goBack();
                    this.f_96541_.m_91152_((Screen)new RadialMenuScreen());
                } else {
                    this.m_7379_();
                }
                return true;
            }
            if (button == 0) {
                List<MenuItem> items = RadialMenu.currentItems();
                if (items == null || items.isEmpty()) {
                    return true;
                }
                if (this.hoveredIndex < 0 || this.hoveredIndex >= items.size()) {
                    return true;
                }
                MenuItem mi = items.get(this.hoveredIndex);
                if (mi.isCategory()) {
                    RadialMenu.enterCategory(mi);
                    this.f_96541_.m_91152_((Screen)new RadialMenuScreen());
                    return true;
                }
                KeyboardHandler.suppressReopenUntilReleased();
                this.executeAndClose(mi);
                return true;
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Radial mouseClicked error: {}", (Object)"ezactions", (Object)t.toString());
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void executeAndClose(MenuItem mi) {
        try {
            Constants.LOG.info("[{}] Radial: execute action id='{}' title='{}' (closing then deferring)", new Object[]{"ezactions", mi.id(), mi.title()});
            Minecraft mc = this.f_96541_;
            this.m_7379_();
            mc.execute(() -> {
                try {
                    boolean ok;
                    boolean bl = ok = mi.action() != null && mi.action().execute(mc);
                    if (!ok) {
                        Constants.LOG.info("[{}] Radial action returned false for '{}'", (Object)"ezactions", (Object)mi.id());
                    }
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] Radial deferred execution error for '{}': {}", new Object[]{"ezactions", mi.id(), t.toString()});
                }
            });
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] executeAndClose error: {}", (Object)"ezactions", (Object)t.toString());
            this.m_7379_();
        }
    }

    public void m_7379_() {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null) {
                mc.m_91152_(null);
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Radial onClose error: {}", (Object)"ezactions", (Object)t.toString());
        }
    }
}

