/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui;

import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.RadialConfig;

public final class RadialScreenMath {
    private RadialScreenMath() {
    }

    public static Radii computeRadii(int items) {
        try {
            RadialConfig c = RadialConfig.get();
            int n = Math.max(0, items);
            int extra = Math.max(0, n - Math.max(0, c.scaleStartThreshold));
            double rOuter = c.baseOuterRadius + extra * Math.max(0, c.scalePerItem);
            double rInner = Math.max(8.0, rOuter - (double)Math.max(8, c.ringThickness));
            return new Radii(rInner, rOuter, c.deadzone);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] computeRadii error: {}", (Object)"ezactions", (Object)t.toString());
            return new Radii(42.0, 72.0, 18);
        }
    }

    public static int pickSector(double mouseX, double mouseY, int cx, int cy, int sectors, Radii rr) {
        try {
            double step;
            int idx;
            if (sectors <= 0) {
                return -1;
            }
            double dx = mouseX - (double)cx;
            double dy = mouseY - (double)cy;
            double dist2 = dx * dx + dy * dy;
            if (dist2 < (double)rr.deadzone() * (double)rr.deadzone()) {
                return -1;
            }
            double ang = Math.atan2(dy, dx);
            if ((ang += 1.5707963267948966) < 0.0) {
                ang += Math.PI * 2;
            }
            return (idx = (int)Math.floor(ang / (step = Math.PI * 2 / (double)sectors))) < 0 || idx >= sectors ? -1 : idx;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] pickSector error: {}", (Object)"ezactions", (Object)t.toString());
            return -1;
        }
    }

    public record Radii(double inner, double outer, int deadzone) {
    }
}

