/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.anim;

public final class SliceHoverAnim {
    private static final int DEFAULT_GROW_MS = 100;
    private static final int DEFAULT_SWEEP_MS = 180;
    private long lastTickMs = 0L;
    private int sliceCount = 0;
    private int hovered = -1;
    private float[] grow = new float[0];
    private float[] sweep = new float[0];

    public void tick(long nowMs, int hoveredIndex, int sliceCount) {
        this.tick(nowMs, hoveredIndex, sliceCount, 100, 180);
    }

    public void tick(long nowMs, int hoveredIndex, int sliceCount, int growMs, int sweepMs) {
        if (sliceCount != this.sliceCount) {
            this.sliceCount = Math.max(0, sliceCount);
            this.grow = new float[this.sliceCount];
            this.sweep = new float[this.sliceCount];
            this.hovered = -1;
        }
        long dtMs = this.lastTickMs == 0L ? 0L : Math.max(0L, nowMs - this.lastTickMs);
        this.lastTickMs = nowMs;
        if (this.grow.length != this.sliceCount) {
            this.grow = new float[this.sliceCount];
        }
        if (this.sweep.length != this.sliceCount) {
            this.sweep = new float[this.sliceCount];
        }
        float kGrow = growMs <= 0 ? 1.0f : SliceHoverAnim.clamp01((float)dtMs / (float)growMs);
        float kSweep = sweepMs <= 0 ? 1.0f : SliceHoverAnim.clamp01((float)dtMs / (float)sweepMs);
        this.hovered = hoveredIndex;
        for (int i = 0; i < this.sliceCount; ++i) {
            boolean isTarget = i == this.hovered;
            float targetGrow = isTarget ? 1.0f : 0.0f;
            float targetSweep = isTarget ? 1.0f : 0.0f;
            int n = i;
            this.grow[n] = this.grow[n] + (targetGrow - this.grow[i]) * kGrow;
            int n2 = i;
            this.sweep[n2] = this.sweep[n2] + (targetSweep - this.sweep[i]) * kSweep;
            if (Math.abs(this.grow[i] - targetGrow) < 0.001f) {
                this.grow[i] = targetGrow;
            }
            if (!(Math.abs(this.sweep[i] - targetSweep) < 0.001f)) continue;
            this.sweep[i] = targetSweep;
        }
    }

    public float scaleFor(int index) {
        if (index < 0 || index >= this.grow.length) {
            return 0.0f;
        }
        return SliceHoverAnim.clamp01(this.grow[index]);
    }

    public float sweepFor(int index) {
        if (index < 0 || index >= this.sweep.length) {
            return 0.0f;
        }
        return SliceHoverAnim.clamp01(this.sweep[index]);
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }
}

