/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.GeneralClientConfig;
import org.z2six.ezactions.data.click.ClickActionCommand;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.editor.IconPickerScreen;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;

public final class CommandActionEditScreen
extends Screen {
    private static final int LABEL_TO_FIELD = 10;
    private static final int FIELD_TO_NEXT_LABEL = 5;
    private static final int FIRST_BUTTON_ROW_OFFSET = 10;
    private static final int BETWEEN_BUTTON_ROWS = 5;
    private final Screen parent;
    private final MenuItem editing;
    private String draftTitle = "";
    private String draftNote = "";
    private String draftCommand = "/say hi";
    private int draftDelayTicks = 0;
    private IconSpec draftIcon = IconSpec.item("minecraft:stone");
    private EditBox titleBox;
    private EditBox noteBox;
    private MultiLineEditBox cmdBox;
    private EditBox delayBox;

    public CommandActionEditScreen(Screen parent, MenuItem editing) {
        super((Component)Component.m_237113_((String)(editing == null ? "Add Command" : "Edit Command")));
        IClickAction iClickAction;
        this.parent = parent;
        this.editing = editing;
        if (editing != null && (iClickAction = editing.action()) instanceof ClickActionCommand) {
            ClickActionCommand cc = (ClickActionCommand)iClickAction;
            this.draftTitle = CommandActionEditScreen.safe(editing.title());
            try {
                this.draftNote = CommandActionEditScreen.safe(editing.note());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String extracted = "";
            try {
                extracted = cc.getCommand();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (extracted == null || extracted.isEmpty()) {
                extracted = CommandActionEditScreen.tryExtractCommandString(cc);
            }
            if (!extracted.isEmpty()) {
                this.draftCommand = extracted;
            }
            int delay = 0;
            try {
                delay = cc.getDelayTicks();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (delay <= 0) {
                delay = CommandActionEditScreen.tryExtractDelayTicks(cc);
            }
            this.draftDelayTicks = Math.max(0, delay);
            if (editing.icon() != null) {
                this.draftIcon = editing.icon();
            }
        }
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String tryExtractCommandString(ClickActionCommand cc) {
        String[] fieldNames;
        String[] methodNames;
        for (String mname : methodNames = new String[]{"command", "getCommand", "getCmd", "cmd"}) {
            try {
                String s;
                Method m = cc.getClass().getMethod(mname, new Class[0]);
                Object v = m.invoke((Object)cc, new Object[0]);
                if (!(v instanceof String) || (s = (String)v).isEmpty()) continue;
                return s;
            }
            catch (Throwable m) {
                // empty catch block
            }
        }
        for (String fname : fieldNames = new String[]{"command", "cmd", "commandRaw"}) {
            try {
                String s;
                Field f = cc.getClass().getDeclaredField(fname);
                f.setAccessible(true);
                Object v = f.get(cc);
                if (!(v instanceof String) || (s = (String)v).isEmpty()) continue;
                return s;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "";
    }

    private static int tryExtractDelayTicks(ClickActionCommand cc) {
        String[] fields;
        String[] methods;
        for (String mname : methods = new String[]{"getDelayTicks", "delayTicks", "getDelay", "delay"}) {
            try {
                Method m = cc.getClass().getMethod(mname, new Class[0]);
                Object v = m.invoke((Object)cc, new Object[0]);
                if (!(v instanceof Number)) continue;
                Number n = (Number)v;
                return n.intValue();
            }
            catch (Throwable m) {
                // empty catch block
            }
        }
        for (String fname : fields = new String[]{"delayTicks", "delay", "ticksDelay"}) {
            try {
                Field f = cc.getClass().getDeclaredField(fname);
                f.setAccessible(true);
                Object v = f.get(cc);
                if (!(v instanceof Number)) continue;
                Number n = (Number)v;
                return n.intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    protected void m_7856_() {
        int cx = this.f_96543_ / 2;
        int y = 48;
        this.titleBox = new EditBox(this.f_96547_, cx - 160, y, 320, 20, (Component)Component.m_237113_((String)"Title"));
        this.titleBox.m_257771_((Component)Component.m_237113_((String)"Title (e.g., Say Time)"));
        this.titleBox.m_94144_(this.draftTitle);
        this.titleBox.m_94151_(s -> {
            this.draftTitle = CommandActionEditScreen.safe(s);
        });
        this.m_142416_((GuiEventListener)this.titleBox);
        this.noteBox = new EditBox(this.f_96547_, cx - 160, y += 35, 320, 20, (Component)Component.m_237113_((String)"Note"));
        this.noteBox.m_257771_((Component)Component.m_237113_((String)"Optional note (tooltip in editor)"));
        this.noteBox.m_94144_(this.draftNote);
        this.noteBox.m_94151_(s -> {
            this.draftNote = CommandActionEditScreen.safe(s);
        });
        this.m_142416_((GuiEventListener)this.noteBox);
        y += 35;
        int cfgLines = 5;
        try {
            cfgLines = GeneralClientConfig.getCommandEditorVisibleLines();
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] commandEditorVisibleLines read failed; using default 5: {}", (Object)"ezactions", (Object)t.toString());
            cfgLines = 5;
        }
        if (cfgLines < 1) {
            cfgLines = 1;
        }
        if (cfgLines > 20) {
            cfgLines = 20;
        }
        int V_PADDING = 6;
        Objects.requireNonNull(this.f_96547_);
        int cmdH = 9 * cfgLines + 6;
        this.cmdBox = new MultiLineEditBox(this.f_96547_, cx - 160, y, 320, cmdH, (Component)Component.m_237113_((String)"Command"), (Component)Component.m_237113_((String)this.draftCommand));
        this.cmdBox.m_239313_(Short.MAX_VALUE);
        this.cmdBox.m_240159_(this.draftCommand);
        this.cmdBox.m_239273_(s -> {
            this.draftCommand = CommandActionEditScreen.safe(s);
        });
        this.m_142416_((GuiEventListener)this.cmdBox);
        this.delayBox = new EditBox(this.f_96547_, cx - 160, y += cmdH + 5 + 10, 80, 20, (Component)Component.m_237113_((String)"Delay (ticks)"));
        this.delayBox.m_94144_(this.draftDelayTicks > 0 ? Integer.toString(this.draftDelayTicks) : "");
        this.delayBox.m_94151_(s -> {
            try {
                int v = Integer.parseInt(s.trim());
                this.draftDelayTicks = Math.max(0, v);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.delayBox);
        y += 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Choose Icon"), b -> this.f_96541_.m_91152_((Screen)new IconPickerScreen(this, ic -> {
            this.draftIcon = ic == null ? IconSpec.item("minecraft:stone") : ic;
            this.f_96541_.m_91152_((Screen)this);
        }))).m_252987_(cx - 160, y += 10, 320, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.onSavePressed()).m_252987_(cx - 160, y += 25, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.m_7379_()).m_252987_(cx - 52, y, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(cx + 56, y, 100, 20).m_253136_());
    }

    private void onSavePressed() {
        try {
            Screen screen;
            boolean ok;
            this.draftTitle = CommandActionEditScreen.safe(this.titleBox == null ? this.draftTitle : this.titleBox.m_94155_()).trim();
            this.draftNote = CommandActionEditScreen.safe(this.noteBox == null ? this.draftNote : this.noteBox.m_94155_()).trim();
            this.draftCommand = CommandActionEditScreen.safe(this.cmdBox == null ? this.draftCommand : this.cmdBox.m_239249_()).trim();
            int delay = 0;
            try {
                String s = this.delayBox == null ? "" : this.delayBox.m_94155_().trim();
                delay = s.isEmpty() ? 0 : Math.max(0, Integer.parseInt(s));
            }
            catch (Throwable s) {
                // empty catch block
            }
            this.draftDelayTicks = delay;
            if (this.draftTitle.isEmpty() || this.draftCommand.isEmpty()) {
                Constants.LOG.warn("[{}] CommandEdit: Title or Command empty; ignoring save.", (Object)"ezactions");
                return;
            }
            MenuItem item = new MenuItem(this.editing != null ? this.editing.id() : MenuEditorScreen.freshId("cmd"), this.draftTitle, this.draftNote, this.draftIcon, (IClickAction)new ClickActionCommand(this.draftCommand, this.draftDelayTicks), List.of());
            boolean bl = ok = this.editing == null ? RadialMenu.addToCurrent(item) : RadialMenu.replaceInCurrent(this.editing.id(), item);
            if (!ok) {
                Constants.LOG.info("[{}] Command save failed for '{}'.", (Object)"ezactions", (Object)this.draftTitle);
            }
            if ((screen = this.parent) instanceof MenuEditorScreen) {
                MenuEditorScreen m = (MenuEditorScreen)screen;
                m.refreshFromChild();
            }
            this.f_96541_.m_91152_(this.parent);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] CommandEdit onSave failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -2013265920);
        g.m_280509_(12, 52, this.f_96543_ - 12, this.f_96544_ - 36, -1072689136);
        g.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 14, 0xFFFFFF);
        int labelX = this.f_96543_ / 2 - 160;
        if (this.titleBox != null) {
            g.m_280488_(this.f_96547_, "Title:", labelX, this.titleBox.m_252907_() - 10, 0xA0A0A0);
        }
        if (this.noteBox != null) {
            g.m_280488_(this.f_96547_, "Note:", labelX, this.noteBox.m_252907_() - 10, 0xA0A0A0);
        }
        if (this.cmdBox != null) {
            g.m_280488_(this.f_96547_, "Command:", labelX, this.cmdBox.m_252907_() - 10, 0xA0A0A0);
        }
        if (this.delayBox != null) {
            g.m_280488_(this.f_96547_, "Multi-command delay (ticks):", labelX, this.delayBox.m_252907_() - 10, 0xA0A0A0);
        }
        int boxW = 60;
        int boxH = 60;
        int bx = this.f_96543_ - boxW - 16;
        int by = 16;
        g.m_280509_(bx - 1, by - 1, bx + boxW + 1, by + boxH + 1, 0x40FFFFFF);
        g.m_280509_(bx, by, bx + boxW, by + boxH, 0x20202020);
        g.m_280488_(this.f_96547_, "Icon", bx + 18, by + 4, 0xA0A0A0);
        try {
            IconRenderer.drawIcon(g, bx + boxW / 2, by + boxH / 2 + 6, this.draftIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }
}

