/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.gui.noblur.NoMenuBlurScreen;

public final class KeybindPickerScreen
extends Screen
implements NoMenuBlurScreen {
    private final Screen parent;
    private final Consumer<String> onPick;
    private static final int PADDING = 12;
    private static final int ROW_H = 20;
    private static final int BUTTON_W = 60;
    private double scrollY = 0.0;
    private final List<Row> rows = new ArrayList<Row>();
    private boolean draggingScrollbar = false;
    private int dragGrabOffsetY = 0;

    public KeybindPickerScreen(Screen parent, Consumer<String> onPick) {
        super((Component)Component.m_237113_((String)"Choose Keybinding"));
        this.parent = parent;
        this.onPick = onPick;
    }

    public static void open(Screen parent, Consumer<String> onPick) {
        Minecraft.m_91087_().m_91152_((Screen)new KeybindPickerScreen(parent, onPick));
    }

    protected void m_7856_() {
        try {
            Options opts = Objects.requireNonNull(Minecraft.m_91087_().f_91066_);
            KeyMapping[] all = Objects.requireNonNull(opts.f_92059_);
            HashMap<String, List> byCat = new HashMap<String, List>();
            for (KeyMapping km2 : all) {
                byCat.computeIfAbsent(km2.m_90858_(), k -> new ArrayList()).add(km2);
            }
            ArrayList cats = new ArrayList(byCat.keySet());
            cats.sort(Comparator.comparing(k -> Component.m_237115_((String)k).getString(), String.CASE_INSENSITIVE_ORDER));
            this.rows.clear();
            for (String cat : cats) {
                this.rows.add(new Row(true, (Component)Component.m_237115_((String)cat), null));
                List list = (List)byCat.get(cat);
                list.sort(Comparator.comparing(km -> Component.m_237115_((String)km.m_90860_()).getString(), String.CASE_INSENSITIVE_ORDER));
                for (KeyMapping km3 : list) {
                    this.rows.add(new Row(false, (Component)Component.m_237115_((String)km3.m_90860_()), km3));
                }
            }
            Constants.LOG.info("[{}] KeybindPicker: built {} rows ({} categories).", new Object[]{"ezactions", this.rows.size(), cats.size()});
            this.scrollY = KeybindPickerScreen.clamp(this.scrollY, 0.0, Math.max(0, this.rows.size() * 20 - this.viewHeight()));
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] KeybindPicker init failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public boolean m_6050_(double mx, double my, double delta) {
        double view;
        double content = this.rows.size() * 20;
        if (content > (view = (double)this.viewHeight())) {
            this.scrollY = KeybindPickerScreen.clamp(this.scrollY - delta * 32.0, 0.0, content - view);
        }
        return true;
    }

    public boolean m_6375_(double mx, double my, int button) {
        if (button != 0) {
            return false;
        }
        if (this.beginScrollbarDragIfHit(mx, my)) {
            return true;
        }
        int x = 12;
        int y = (int)(12.0 - this.scrollY);
        int usableW = this.f_96543_ - 24;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row r = this.rows.get(i);
            int ry = y + i * 20;
            if (r.header) continue;
            int btnX = x + Math.min(usableW, 360);
            int btnY = ry + 3;
            if (!(mx >= (double)btnX) || !(mx <= (double)(btnX + 60)) || !(my >= (double)btnY) || !(my <= (double)(btnY + 14))) continue;
            try {
                String mappingKey = r.mapping.m_90860_();
                Constants.LOG.info("[{}] KeybindPicker: picked {}", (Object)"ezactions", (Object)mappingKey);
                this.onPick.accept(mappingKey);
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeybindPicker onPick failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mx, my, button);
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            Constants.LOG.debug("[{}] KeybindPicker: scrollbar drag end (scrollY={})", (Object)"ezactions", (Object)this.scrollY);
            return true;
        }
        return super.m_6348_(mx, my, button);
    }

    public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
        if (this.draggingScrollbar && button == 0) {
            try {
                this.applyDragToScroll(my);
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeybindPicker drag update failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            return true;
        }
        return super.m_7979_(mx, my, button, dx, dy);
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1610612736);
        int x = 12;
        int y = (int)(12.0 - this.scrollY);
        int usableW = this.f_96543_ - 24;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row r = this.rows.get(i);
            int ry = y + i * 20;
            if (r.header) {
                g.m_280430_(this.f_96547_, r.label, x, ry + 4, 0xFFFFAA);
                g.m_280509_(x, ry + 20 - 2, x + usableW, ry + 20 - 1, 0x40FFFFFF);
                continue;
            }
            g.m_280430_(this.f_96547_, r.label, x, ry + 5, 0xFFFFFF);
            int btnX = x + Math.min(usableW, 360);
            int btnY = ry + 3;
            int btnW = 60;
            int btnH = 14;
            g.m_280509_(btnX, btnY, btnX + btnW, btnY + btnH, 0x40000000);
            MutableComponent b = Component.m_237113_((String)"Use");
            int tw = this.f_96547_.m_92852_((FormattedText)b);
            g.m_280430_(this.f_96547_, (Component)b, btnX + (btnW - tw) / 2, btnY + 5, 0xFFFFFF);
        }
        this.drawScrollbar(g);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private int viewHeight() {
        return this.f_96544_ - 24;
    }

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private void drawScrollbar(GuiGraphics g) {
        int view;
        double content = this.rows.size() * 20;
        if (content <= (double)(view = this.viewHeight())) {
            return;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        g.m_280509_(m.barX, m.barY, m.barX + m.barW, m.barY + m.barH, 0x40000000);
        g.m_280509_(m.barX + 1, m.knobY, m.barX + m.barW - 1, m.knobY + m.knobH, -2130706433);
    }

    private ScrollbarMetrics computeScrollbarMetrics(double content, int view) {
        ScrollbarMetrics m = new ScrollbarMetrics();
        m.barW = 6;
        m.barX = this.f_96543_ - 12 - m.barW;
        m.barY = 12;
        m.barH = view;
        double ratio = (double)view / content;
        m.knobH = Math.max(20, (int)((double)m.barH * ratio));
        double denom = Math.max(1.0, content - (double)view);
        m.knobY = (int)((double)m.barY + (double)(m.barH - m.knobH) * (this.scrollY / denom));
        return m;
    }

    private boolean beginScrollbarDragIfHit(double mx, double my) {
        boolean inKnob;
        int view;
        double content = this.rows.size() * 20;
        if (content <= (double)(view = this.viewHeight())) {
            return false;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        boolean bl = inKnob = mx >= (double)(m.barX + 1) && mx <= (double)(m.barX + m.barW - 1) && my >= (double)m.knobY && my <= (double)(m.knobY + m.knobH);
        if (inKnob) {
            this.draggingScrollbar = true;
            this.dragGrabOffsetY = (int)(my - (double)m.knobY);
            Constants.LOG.debug("[{}] KeybindPicker: scrollbar drag start (grabOffsetY={}, scrollY={})", new Object[]{"ezactions", this.dragGrabOffsetY, this.scrollY});
            return true;
        }
        return false;
    }

    private void applyDragToScroll(double mouseY) {
        int view;
        double content = this.rows.size() * 20;
        if (content <= (double)(view = this.viewHeight())) {
            return;
        }
        ScrollbarMetrics m = this.computeScrollbarMetrics(content, view);
        int minY = m.barY;
        int maxY = m.barY + m.barH - m.knobH;
        int newKnobY = (int)KeybindPickerScreen.clamp(mouseY - (double)this.dragGrabOffsetY, minY, maxY);
        double trackRange = m.barH - m.knobH;
        double t = trackRange <= 0.0 ? 0.0 : (double)(newKnobY - m.barY) / trackRange;
        double maxScroll = Math.max(0.0, content - (double)view);
        this.scrollY = KeybindPickerScreen.clamp(t * maxScroll, 0.0, maxScroll);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private static final class Row {
        final boolean header;
        final Component label;
        final KeyMapping mapping;

        Row(boolean header, Component label, KeyMapping mapping) {
            this.header = header;
            this.label = label;
            this.mapping = mapping;
        }
    }

    private static final class ScrollbarMetrics {
        int barX;
        int barY;
        int barW;
        int barH;
        int knobY;
        int knobH;

        private ScrollbarMetrics() {
        }
    }
}

