/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.ClickActionType;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.json.MenuImportExport;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.editor.CategoryEditScreen;
import org.z2six.ezactions.gui.editor.CommandActionEditScreen;
import org.z2six.ezactions.gui.editor.KeyActionEditScreen;
import org.z2six.ezactions.gui.editor.config.ConfigScreen;
import org.z2six.ezactions.gui.editor.menu.MenuNavUtil;
import org.z2six.ezactions.gui.editor.menu.Rows;
import org.z2six.ezactions.gui.editor.menu.ScrollbarMath;

public final class MenuEditorScreen
extends Screen {
    private static final int PAD = 8;
    private static final int LEFT_W = 160;
    private static final int ROW_H = 24;
    private static final int ICON_SZ = 18;
    private static final int BLUE = -2145093377;
    private static final int BLUE_FULL = -14386945;
    private static final int HILITE = 539261183;
    private static final int ROW_BG = 0x20FFFFFF;
    private static final int SB_W = 6;
    private static final int SB_BG = 0x40000000;
    private static final int SB_KNOB = -2130706433;
    private static final int SB_KNOB_MINH = 20;
    private static final String BOOKMARK_SYM = "\u00a76\ud83d\udd16\u00a7r";
    private static final int BOOKMARK_PAD_RIGHT = 4;
    private final Screen parent;
    private EditBox filterBox;
    private Button btnAddKey;
    private Button btnAddCmd;
    private Button btnAddCat;
    private Button btnEdit;
    private Button btnRemove;
    private Button btnImport;
    private Button btnExport;
    private Button btnClose;
    private Button btnConfig;
    private int listLeft;
    private int listTop;
    private int listWidth;
    private int listHeight;
    private final List<Rows> rows = new ArrayList<Rows>();
    private int hoveredRow = -1;
    private int selectedRow = -1;
    private double scrollY = 0.0;
    private boolean dragging = false;
    private int dragRowIdx = -1;
    private int dragGhostOffsetY = 0;
    private int dropAt = -1;
    private MenuItem dropTargetCategory = null;
    private int dropTargetRowIdx = -1;
    private DropSpecial dropSpecial = DropSpecial.NONE;
    private boolean sbDragging = false;
    private int sbGrabDy = 0;

    public MenuEditorScreen() {
        this(null);
    }

    public MenuEditorScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"EZ Actions - Menu Editor"));
        this.parent = parent;
    }

    private static String safeNote(MenuItem mi) {
        try {
            return mi == null ? null : mi.note();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static String freshId(String prefix) {
        long t = System.currentTimeMillis();
        return prefix + "_" + Long.toHexString(t);
    }

    private boolean atRoot() {
        return !RadialMenu.canGoBack();
    }

    private List<MenuItem> current() {
        List<MenuItem> it = RadialMenu.currentItems();
        return it == null ? List.of() : it;
    }

    private String parentTitle() {
        try {
            List<String> parts = RadialMenu.pathTitles();
            if (parts != null && parts.size() >= 2) {
                return parts.get(parts.size() - 2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "root";
    }

    private int headerRowCount() {
        if (this.atRoot()) {
            return 0;
        }
        try {
            List<String> parts = RadialMenu.pathTitles();
            int n = parts == null ? 0 : parts.size();
            return n >= 2 ? 3 : 2;
        }
        catch (Throwable ignored) {
            return 2;
        }
    }

    private void rebuildRows() {
        this.rows.clear();
        if (!this.atRoot()) {
            String path = "root";
            try {
                List<String> parts = RadialMenu.pathTitles();
                if (parts != null && !parts.isEmpty()) {
                    path = String.join((CharSequence)"/", parts);
                }
            }
            catch (Throwable t) {
                Constants.LOG.debug("[{}] Breadcrumb build failed: {}", (Object)"ezactions", (Object)t.toString());
            }
            this.rows.add(new Rows.BreadcrumbRow(path));
            this.rows.add(new Rows.BackToRootRow());
            String parent = this.parentTitle();
            if (!"root".equalsIgnoreCase(parent)) {
                this.rows.add(new Rows.BackToParentRow(parent));
            }
        }
        String q = this.filterBox != null ? this.filterBox.m_94155_().trim().toLowerCase(Locale.ROOT) : "";
        for (MenuItem mi : this.current()) {
            if (q.isEmpty()) {
                this.rows.add(new Rows.ItemRow(mi));
                continue;
            }
            String title = mi.title() == null ? "" : mi.title();
            if (!title.toLowerCase(Locale.ROOT).contains(q)) continue;
            this.rows.add(new Rows.ItemRow(mi));
        }
        if (this.selectedRow >= this.rows.size()) {
            this.selectedRow = this.rows.size() - 1;
        }
        if (this.selectedRow < -1) {
            this.selectedRow = -1;
        }
        this.clampScroll();
        this.dropTargetCategory = null;
        this.dropTargetRowIdx = -1;
        this.dropSpecial = DropSpecial.NONE;
    }

    private int rowCount() {
        return this.rows.size();
    }

    private int contentCount() {
        int c = 0;
        for (Rows r : this.rows) {
            if (!(r instanceof Rows.ItemRow)) continue;
            ++c;
        }
        return c;
    }

    private int visibleRowCount() {
        return Math.max(0, this.listHeight / 24);
    }

    private int firstVisibleRow() {
        return Math.max(0, (int)Math.floor(this.scrollY / 24.0));
    }

    private int lastVisibleRow() {
        return Math.min(this.rowCount() - 1, this.firstVisibleRow() + this.visibleRowCount());
    }

    private int mouseToRow(double mouseY) {
        int y = (int)mouseY - this.listTop + (int)this.scrollY;
        if (y < 0) {
            return -1;
        }
        int idx = y / 24;
        return idx >= 0 && idx < this.rowCount() ? idx : -1;
    }

    private void ensureSelectedVisible() {
        if (this.selectedRow < 0) {
            return;
        }
        int selTop = this.selectedRow * 24;
        int selBot = selTop + 24;
        int winTop = (int)this.scrollY;
        int winBot = winTop + this.listHeight;
        if (selTop < winTop) {
            this.scrollY = selTop;
        } else if (selBot > winBot) {
            this.scrollY = selBot - this.listHeight;
        }
        this.clampScroll();
    }

    private void clampScroll() {
        int totalPx = this.rowCount() * 24;
        int maxScroll = Math.max(0, totalPx - this.listHeight);
        if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
        if (this.scrollY > (double)maxScroll) {
            this.scrollY = maxScroll;
        }
    }

    private int rowToContentIndex(int rowIdx) {
        if (rowIdx < 0 || rowIdx >= this.rows.size()) {
            return -1;
        }
        Rows r = this.rows.get(rowIdx);
        if (!(r instanceof Rows.ItemRow)) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            Rows rr = this.rows.get(i);
            if (!(rr instanceof Rows.ItemRow)) continue;
            Rows.ItemRow ir = (Rows.ItemRow)rr;
            if (i == rowIdx) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    private int contentIndexToRow(int contentIdx) {
        if (contentIdx < 0) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            Rows r = this.rows.get(i);
            if (!(r instanceof Rows.ItemRow)) continue;
            if (count == contentIdx) {
                return i;
            }
            ++count;
        }
        return -1;
    }

    protected void m_7856_() {
        int left = 8;
        int top = 8;
        int right = this.f_96543_ - 8;
        int bottom = this.f_96544_ - 8;
        int x = left;
        int y = top;
        this.filterBox = new EditBox(this.f_96547_, x, y, 160, 20, (Component)Component.m_237113_((String)"Filter"));
        this.filterBox.m_257771_((Component)Component.m_237113_((String)"Filter\u2026"));
        this.filterBox.m_94151_(s -> this.rebuildRows());
        this.m_142416_((GuiEventListener)this.filterBox);
        this.btnAddKey = Button.m_253074_((Component)Component.m_237113_((String)"Add Key Action"), b -> {
            MenuEditorScreen parent = this;
            this.f_96541_.m_91152_((Screen)new KeyActionEditScreen(parent, null, (newItem, editingOrNull) -> {
                List<MenuItem> target = this.current();
                if (editingOrNull == null) {
                    target.add((MenuItem)newItem);
                } else {
                    for (int i1 = 0; i1 < target.size(); ++i1) {
                        if (!Objects.equals(target.get(i1).id(), editingOrNull.id())) continue;
                        target.set(i1, (MenuItem)newItem);
                        break;
                    }
                }
                RadialMenu.persist();
                this.rebuildRows();
                int idx2 = -1;
                for (int i2 = 0; i2 < this.rows.size(); ++i2) {
                    Rows.ItemRow ir;
                    Rows r = this.rows.get(i2);
                    if (!(r instanceof Rows.ItemRow) || !Objects.equals((ir = (Rows.ItemRow)r).item().id(), newItem.id())) continue;
                    idx2 = i2;
                    break;
                }
                if (idx2 >= 0) {
                    this.selectedRow = idx2;
                    this.ensureSelectedVisible();
                }
            }));
        }).m_252987_(x, y += 24, 160, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnAddKey);
        this.btnAddCmd = Button.m_253074_((Component)Component.m_237113_((String)"Add Command"), b -> this.f_96541_.m_91152_((Screen)new CommandActionEditScreen(this, null))).m_252987_(x, y += 24, 160, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnAddCmd);
        this.btnAddCat = Button.m_253074_((Component)Component.m_237113_((String)"Add Bundle"), b -> this.f_96541_.m_91152_((Screen)new CategoryEditScreen(this, null))).m_252987_(x, y += 24, 160, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnAddCat);
        this.btnEdit = Button.m_253074_((Component)Component.m_237113_((String)"Edit Selected"), b -> this.onEditSelected()).m_252987_(x, y += 24, 160, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnEdit);
        this.btnRemove = Button.m_253074_((Component)Component.m_237113_((String)"Remove Selected"), b -> this.onRemoveSelected()).m_252987_(x, y += 24, 160, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnRemove);
        y += 24;
        int BTN_H = 20;
        int VSTEP = 24;
        int H_GAP = 8;
        int HALF_W = 76;
        MutableComponent importLabel = Component.m_237113_((String)"\u21e9 Import").m_130940_(ChatFormatting.AQUA);
        MutableComponent exportLabel = Component.m_237113_((String)"\u21e7 Export").m_130940_(ChatFormatting.AQUA);
        int yRowBottom = bottom - 22;
        int xLeftCol = x;
        int xRightCol = x + 76 + 8;
        this.btnClose = Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(xLeftCol, yRowBottom, 76, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnClose);
        this.btnConfig = Button.m_253074_((Component)Component.m_237113_((String)"Config"), b -> {
            try {
                this.f_96541_.m_91152_((Screen)new ConfigScreen(this));
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Config button handler failed: {}", (Object)"ezactions", (Object)t.toString());
            }
        }).m_252987_(xRightCol, yRowBottom, 76, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnConfig);
        int yRowTop = yRowBottom - 24;
        this.btnImport = Button.m_253074_((Component)importLabel, b -> {
            try {
                int n = MenuImportExport.importFromClipboard();
                if (n >= 0) {
                    this.rebuildRows();
                    this.selectedRow = -1;
                    this.scrollY = 0.0;
                }
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Import button action failed: {}", (Object)"ezactions", (Object)t.toString());
            }
        }).m_252987_(xLeftCol, yRowTop, 76, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnImport);
        this.btnExport = Button.m_253074_((Component)exportLabel, b -> {
            try {
                MenuImportExport.exportToClipboard();
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Export button action failed: {}", (Object)"ezactions", (Object)t.toString());
            }
        }).m_252987_(xRightCol, yRowTop, 76, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnExport);
        this.listLeft = left + 160 + 8;
        this.listTop = top;
        this.listWidth = right - this.listLeft;
        this.listHeight = bottom - top;
        this.scrollY = 0.0;
        this.selectedRow = -1;
        this.dragging = false;
        this.dragRowIdx = -1;
        this.dropAt = -1;
        this.sbDragging = false;
        this.dropTargetCategory = null;
        this.dropTargetRowIdx = -1;
        this.dropSpecial = DropSpecial.NONE;
        this.rebuildRows();
    }

    private void onEditSelected() {
        if (this.selectedRow < 0 || this.selectedRow >= this.rows.size()) {
            return;
        }
        Rows r = this.rows.get(this.selectedRow);
        if (r instanceof Rows.BackToRootRow) {
            MenuNavUtil.goToRoot();
            this.rebuildRows();
            return;
        }
        if (r instanceof Rows.BackToParentRow) {
            RadialMenu.goBack();
            this.rebuildRows();
            return;
        }
        MenuItem mi = ((Rows.ItemRow)r).item();
        if (mi.isCategory()) {
            this.f_96541_.m_91152_((Screen)new CategoryEditScreen(this, mi));
            return;
        }
        IClickAction act = mi.action();
        if (act == null) {
            return;
        }
        ClickActionType t = act.getType();
        if (t == ClickActionType.KEY) {
            MenuEditorScreen parent = this;
            this.f_96541_.m_91152_((Screen)new KeyActionEditScreen(parent, mi, (newItem, editingOrNull) -> {
                List<MenuItem> target = this.current();
                for (int i = 0; i < target.size(); ++i) {
                    if (!Objects.equals(target.get(i).id(), newItem.id())) continue;
                    target.set(i, (MenuItem)newItem);
                    break;
                }
                RadialMenu.persist();
                this.rebuildRows();
                int idx = -1;
                for (int i = 0; i < this.rows.size(); ++i) {
                    Rows.ItemRow ir;
                    Rows rr = this.rows.get(i);
                    if (!(rr instanceof Rows.ItemRow) || !Objects.equals((ir = (Rows.ItemRow)rr).item().id(), newItem.id())) continue;
                    idx = i;
                    break;
                }
                if (idx >= 0) {
                    this.selectedRow = idx;
                    this.ensureSelectedVisible();
                }
            }));
        } else if (t == ClickActionType.COMMAND) {
            this.f_96541_.m_91152_((Screen)new CommandActionEditScreen(this, mi));
        }
    }

    private void onRemoveSelected() {
        if (this.selectedRow < 0 || this.selectedRow >= this.rows.size()) {
            return;
        }
        Rows r = this.rows.get(this.selectedRow);
        if (!(r instanceof Rows.ItemRow)) {
            return;
        }
        MenuItem mi = ((Rows.ItemRow)r).item();
        String id = mi.id();
        try {
            boolean ok = RadialMenu.removeFromCurrent(id);
            if (!ok) {
                Constants.LOG.info("[{}] Remove failed for '{}'.", (Object)"ezactions", (Object)id);
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Remove exception for '{}': {}", new Object[]{"ezactions", id, t.toString()});
        }
        this.selectedRow = -1;
        this.rebuildRows();
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -2013265920);
        g.m_280509_(8, 8, 168, this.f_96544_ - 8, -1072689136);
        g.m_280509_(this.listLeft, this.listTop, this.listLeft + this.listWidth, this.listTop + this.listHeight, -1072689136);
        int panelCenterX = this.listLeft + this.listWidth / 2;
        g.m_280137_(this.f_96547_, this.f_96539_.getString(), panelCenterX, 6, 0xFFFFFF);
        int first = this.firstVisibleRow();
        int last = this.lastVisibleRow();
        this.hoveredRow = this.hitList(mouseX, mouseY) ? this.mouseToRow(mouseY) : -1;
        boolean tooltipRendered = false;
        for (int i = first; i <= last; ++i) {
            Object txt;
            boolean hov;
            int y = this.listTop + i * 24 - (int)this.scrollY;
            if (y + 24 < this.listTop || y > this.listTop + this.listHeight) continue;
            Rows r = this.rows.get(i);
            boolean isBreadcrumb = r instanceof Rows.BreadcrumbRow;
            boolean isBackRoot = r instanceof Rows.BackToRootRow;
            boolean isBackParent = r instanceof Rows.BackToParentRow;
            boolean sel = i == this.selectedRow && !isBreadcrumb;
            boolean bl = hov = i == this.hoveredRow && !isBreadcrumb;
            if (sel) {
                g.m_280509_(this.listLeft, y, this.listLeft + this.listWidth, y + 24, 539261183);
            } else if (hov) {
                g.m_280509_(this.listLeft, y, this.listLeft + this.listWidth, y + 24, 0x20FFFFFF);
            }
            if (isBreadcrumb) {
                txt = ((Rows.BreadcrumbRow)r).path();
                Objects.requireNonNull(this.f_96547_);
                g.m_280488_(this.f_96547_, (String)txt, this.listLeft + 8, y + (24 - 9) / 2, -1);
                continue;
            }
            if (isBackRoot) {
                txt = String.valueOf(ChatFormatting.RED) + "Back to root";
                Objects.requireNonNull(this.f_96547_);
                g.m_280488_(this.f_96547_, (String)txt, this.listLeft + 8, y + (24 - 9) / 2, 0xFF0000);
                continue;
            }
            if (isBackParent) {
                String parent = ((Rows.BackToParentRow)r).parentName();
                String txt2 = String.valueOf(ChatFormatting.RED) + "Back to " + parent;
                Objects.requireNonNull(this.f_96547_);
                g.m_280488_(this.f_96547_, txt2, this.listLeft + 8, y + (24 - 9) / 2, 0xFF0000);
                continue;
            }
            MenuItem mi = ((Rows.ItemRow)r).item();
            int textX = this.listLeft + 8;
            IconSpec icon = mi.icon();
            if (icon != null) {
                IconRenderer.drawIcon(g, this.listLeft + 8 + 9, y + 12, icon);
                textX += 24;
            }
            int titleX = textX;
            String note = MenuEditorScreen.safeNote(mi);
            if (note != null && !note.isBlank()) {
                String sym = BOOKMARK_SYM;
                int symW = this.f_96547_.m_92895_(sym);
                int symX = titleX;
                Objects.requireNonNull(this.f_96547_);
                int symY = y + (24 - 9) / 2;
                g.m_280488_(this.f_96547_, sym, symX, symY, 0xFFFFAA);
                titleX += symW + 4;
                if (!tooltipRendered) {
                    boolean over;
                    boolean bl2 = over = mouseX >= symX && mouseX <= symX + symW && mouseY >= y && mouseY <= y + 24;
                    if (over) {
                        try {
                            Component noteC = mi.noteComponent();
                            if (noteC != null && !noteC.getString().isEmpty()) {
                                g.m_280557_(this.f_96547_, noteC, mouseX, mouseY);
                                tooltipRendered = true;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            Component nameC = mi.titleComponent();
            if (mi.isCategory()) {
                nameC = Component.m_237113_((String)"(RMB to open) ").m_130940_(ChatFormatting.RED).m_7220_(nameC);
            }
            Objects.requireNonNull(this.f_96547_);
            g.m_280614_(this.f_96547_, nameC, titleX, y + (24 - 9) / 2, 0xFFFFFF, false);
            IClickAction act = mi.action();
            String t = act != null ? act.getType().name() : "BUNDLE";
            int tw = this.f_96547_.m_92895_(t);
            Objects.requireNonNull(this.f_96547_);
            g.m_280488_(this.f_96547_, t, this.listLeft + this.listWidth - tw - 8, y + (24 - 9) / 2, 0xA0A0A0);
        }
        if (this.dragging && this.dragRowIdx >= 0 && this.dragRowIdx < this.rows.size()) {
            int yGhost = mouseY - this.dragGhostOffsetY;
            g.m_280509_(this.listLeft, yGhost, this.listLeft + this.listWidth, yGhost + 24, 0x40FFFFFF);
            Rows r = this.rows.get(this.dragRowIdx);
            if (r instanceof Rows.ItemRow) {
                Rows.ItemRow ir = (Rows.ItemRow)r;
                MenuItem mi = ir.item();
                int ghostTextX = this.listLeft + 8;
                IconSpec icon = mi.icon();
                if (icon != null) {
                    try {
                        IconRenderer.drawIcon(g, this.listLeft + 8 + 9, yGhost + 12, icon);
                        ghostTextX += 24;
                    }
                    catch (Throwable sel) {
                        // empty catch block
                    }
                }
                Component nameC = mi.titleComponent();
                if (mi.isCategory()) {
                    nameC = Component.m_237113_((String)"(RMB to open) ").m_130940_(ChatFormatting.RED).m_7220_(nameC);
                }
                Objects.requireNonNull(this.f_96547_);
                g.m_280614_(this.f_96547_, nameC, ghostTextX, yGhost + (24 - 9) / 2, 0xFFFFFF, false);
            }
            if (this.dropTargetCategory != null && this.dropTargetRowIdx >= 0) {
                int y = this.listTop + this.dropTargetRowIdx * 24 - (int)this.scrollY;
                this.drawBlueOutline(g, this.listLeft, y, this.listLeft + this.listWidth, y + 24);
            } else if (this.dropSpecial != DropSpecial.NONE && this.dropTargetRowIdx >= 0) {
                int y = this.listTop + this.dropTargetRowIdx * 24 - (int)this.scrollY;
                this.drawBlueOutline(g, this.listLeft, y, this.listLeft + this.listWidth, y + 24);
            } else if (this.dropAt >= 0) {
                int yLine = this.listTop + this.dropAt * 24 - (int)this.scrollY;
                g.m_280509_(this.listLeft, yLine - 1, this.listLeft + this.listWidth, yLine + 1, -2145093377);
            }
        }
        ScrollbarMath.Metrics sb = ScrollbarMath.compute(this.listLeft, this.listTop, this.listWidth, this.listHeight, 6, 20, this.rowCount(), 24, this.scrollY);
        ScrollbarMath.draw(g, sb, 0x40000000, -2130706433);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void drawBlueOutline(GuiGraphics g, int x1, int y1, int x2, int y2) {
        int s = 2;
        g.m_280509_(x1, y1, x2, y1 + 2, -14386945);
        g.m_280509_(x1, y2 - 2, x2, y2, -14386945);
        g.m_280509_(x1, y1, x1 + 2, y2, -14386945);
        g.m_280509_(x2 - 2, y1, x2, y2, -14386945);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int idx;
        boolean inScrollbar;
        ScrollbarMath.Metrics sb = ScrollbarMath.compute(this.listLeft, this.listTop, this.listWidth, this.listHeight, 6, 20, this.rowCount(), 24, this.scrollY);
        boolean bl = inScrollbar = mouseX >= (double)sb.trackX1 && mouseX < (double)sb.trackX2 && mouseY >= (double)sb.trackY1 && mouseY < (double)sb.trackY2;
        if (inScrollbar) {
            boolean inKnob;
            boolean bl2 = inKnob = mouseY >= (double)sb.knobY1 && mouseY <= (double)sb.knobY2;
            if (inKnob && button == 0) {
                this.sbDragging = true;
                this.sbGrabDy = (int)mouseY - sb.knobY1;
                return true;
            }
            int desiredTop = (int)mouseY - (sb.knobY2 - sb.knobY1) / 2;
            int clampedTop = ScrollbarMath.clampKnobTop(sb, desiredTop);
            this.scrollY = ScrollbarMath.knobTopToScrollY(sb, 24, this.rowCount(), this.listHeight, clampedTop);
            this.clampScroll();
            return true;
        }
        boolean inList = this.hitList(mouseX, mouseY);
        if (inList && (idx = this.mouseToRow(mouseY)) >= 0 && idx < this.rowCount()) {
            Rows r = this.rows.get(idx);
            this.selectedRow = r instanceof Rows.BreadcrumbRow ? -1 : idx;
            this.ensureSelectedVisible();
            if (button == 1) {
                Rows.ItemRow ir;
                MenuItem mi;
                if (r instanceof Rows.BackToRootRow) {
                    MenuNavUtil.goToRoot();
                    this.scrollY = 0.0;
                    this.selectedRow = -1;
                    this.rebuildRows();
                    return true;
                }
                if (r instanceof Rows.BackToParentRow) {
                    RadialMenu.goBack();
                    this.scrollY = 0.0;
                    this.selectedRow = -1;
                    this.rebuildRows();
                    return true;
                }
                if (r instanceof Rows.ItemRow && (mi = (ir = (Rows.ItemRow)r).item()).isCategory()) {
                    RadialMenu.enterCategory(mi);
                    this.scrollY = 0.0;
                    this.selectedRow = -1;
                    this.rebuildRows();
                    return true;
                }
            } else if (button == 0) {
                if (r instanceof Rows.BackToRootRow) {
                    MenuNavUtil.goToRoot();
                    this.scrollY = 0.0;
                    this.selectedRow = -1;
                    this.rebuildRows();
                    return true;
                }
                if (r instanceof Rows.BackToParentRow) {
                    RadialMenu.goBack();
                    this.scrollY = 0.0;
                    this.selectedRow = -1;
                    this.rebuildRows();
                    return true;
                }
                if (r instanceof Rows.ItemRow) {
                    this.dragging = true;
                    this.dragRowIdx = idx;
                    this.dragGhostOffsetY = (int)mouseY - (this.listTop + idx * 24 - (int)this.scrollY);
                    this.dropAt = this.computeDropAt(mouseY);
                    this.dropTargetCategory = null;
                    this.dropTargetRowIdx = -1;
                    this.dropSpecial = DropSpecial.NONE;
                    try {
                        int fromContent = this.rowToContentIndex(this.dragRowIdx);
                        Constants.LOG.debug("[{}] Drag start row={} contentIndex={}", new Object[]{"ezactions", this.dragRowIdx, fromContent});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private int computeDropAt(double mouseY) {
        int raw = this.mouseToRow(mouseY);
        int header = this.headerRowCount();
        if (raw < 0) {
            if (mouseY < (double)this.listTop) {
                return header;
            }
            if (mouseY > (double)(this.listTop + this.rowCount() * 24)) {
                return this.rowCount();
            }
            return -1;
        }
        if (raw < header) {
            return header;
        }
        int within = (int)mouseY - (this.listTop + raw * 24 - (int)this.scrollY);
        int pos = within < 12 ? raw : raw + 1;
        return Math.max(header, pos);
    }

    private void updateDropTargets(double mouseY) {
        Rows.ItemRow ir;
        MenuItem target;
        this.dropTargetCategory = null;
        this.dropTargetRowIdx = -1;
        this.dropSpecial = DropSpecial.NONE;
        int idx = this.mouseToRow(mouseY);
        if (idx < 0 || idx >= this.rows.size()) {
            return;
        }
        Rows r = this.rows.get(idx);
        if (r instanceof Rows.ItemRow && (target = (ir = (Rows.ItemRow)r).item()).isCategory()) {
            Rows.ItemRow dir;
            MenuItem dragged;
            Rows dr;
            if (this.dragRowIdx >= 0 && this.dragRowIdx < this.rows.size() && (dr = this.rows.get(this.dragRowIdx)) instanceof Rows.ItemRow && (dragged = (dir = (Rows.ItemRow)dr).item()) != null && Objects.equals(dragged.id(), target.id())) {
                return;
            }
            this.dropTargetCategory = target;
            this.dropTargetRowIdx = idx;
            return;
        }
        if (r instanceof Rows.BackToRootRow) {
            this.dropSpecial = DropSpecial.BACK_ROOT;
            this.dropTargetRowIdx = idx;
            return;
        }
        if (r instanceof Rows.BackToParentRow) {
            this.dropSpecial = DropSpecial.BACK_PARENT;
            this.dropTargetRowIdx = idx;
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.sbDragging && button == 0) {
            ScrollbarMath.Metrics sb = ScrollbarMath.compute(this.listLeft, this.listTop, this.listWidth, this.listHeight, 6, 20, this.rowCount(), 24, this.scrollY);
            int desiredTop = (int)mouseY - this.sbGrabDy;
            int clampedTop = ScrollbarMath.clampKnobTop(sb, desiredTop);
            this.scrollY = ScrollbarMath.knobTopToScrollY(sb, 24, this.rowCount(), this.listHeight, clampedTop);
            this.clampScroll();
            return true;
        }
        if (this.dragging && button == 0) {
            this.updateDropTargets(mouseY);
            this.dropAt = this.dropTargetCategory != null || this.dropSpecial != DropSpecial.NONE ? -1 : this.computeDropAt(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.sbDragging && button == 0) {
            this.sbDragging = false;
            return true;
        }
        if (this.dragging && button == 0) {
            int fromRow = this.dragRowIdx;
            int toRow = this.dropAt;
            this.dragging = false;
            this.dragRowIdx = -1;
            if (this.dropSpecial != DropSpecial.NONE) {
                try {
                    MenuItem moved;
                    List<MenuItem> cur;
                    int fromContent = this.rowToContentIndex(fromRow);
                    if (fromContent >= 0 && fromContent < (cur = this.current()).size() && (moved = cur.remove(fromContent)) != null) {
                        List<MenuItem> root;
                        boolean appended = false;
                        if (this.dropSpecial == DropSpecial.BACK_PARENT) {
                            List<MenuItem> parent = RadialMenu.parentItems();
                            if (parent != null) {
                                parent.add(moved);
                                appended = true;
                            }
                        } else if (this.dropSpecial == DropSpecial.BACK_ROOT && (root = RadialMenu.rootMutable()) != null) {
                            root.add(moved);
                            appended = true;
                        }
                        if (appended) {
                            RadialMenu.persist();
                        } else {
                            int safeIdx = Math.min(fromContent, cur.size());
                            cur.add(safeIdx, moved);
                        }
                    }
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] Drop-back exception: {}", (Object)"ezactions", (Object)t.toString());
                }
                this.rebuildRows();
                this.selectedRow = -1;
                this.ensureSelectedVisible();
                this.dropTargetCategory = null;
                this.dropTargetRowIdx = -1;
                this.dropSpecial = DropSpecial.NONE;
                this.dropAt = -1;
                return true;
            }
            if (this.dropTargetCategory != null) {
                block28: {
                    try {
                        MenuItem moved;
                        List<MenuItem> cur;
                        int fromContent = this.rowToContentIndex(fromRow);
                        if (fromContent < 0 || fromContent >= (cur = this.current()).size() || (moved = cur.get(fromContent)) == null || Objects.equals(moved.id(), this.dropTargetCategory.id())) break block28;
                        boolean removed = false;
                        try {
                            removed = cur.remove(moved);
                        }
                        catch (Throwable t) {
                            Constants.LOG.warn("[{}] Drop-into: removal failed: {}", (Object)"ezactions", (Object)t.toString());
                        }
                        if (removed) {
                            try {
                                this.dropTargetCategory.childrenMutable().add(moved);
                                RadialMenu.persist();
                                Constants.LOG.debug("[{}] Dropped '{}' into category '{}'", new Object[]{"ezactions", moved.id(), this.dropTargetCategory.id()});
                            }
                            catch (Throwable t) {
                                Constants.LOG.warn("[{}] Drop-into: append failed: {}", (Object)"ezactions", (Object)t.toString());
                                try {
                                    int safeIdx = Math.min(fromContent, cur.size());
                                    cur.add(safeIdx, moved);
                                    break block28;
                                }
                                catch (Throwable throwable) {}
                            }
                            break block28;
                        }
                        Constants.LOG.info("[{}] Drop-into: source item not removed (id='{}')", (Object)"ezactions", (Object)moved.id());
                    }
                    catch (Throwable t) {
                        Constants.LOG.warn("[{}] Drop-into exception: {}", (Object)"ezactions", (Object)t.toString());
                    }
                }
                this.rebuildRows();
                this.selectedRow = -1;
                this.ensureSelectedVisible();
                this.dropTargetCategory = null;
                this.dropTargetRowIdx = -1;
                this.dropAt = -1;
                return true;
            }
            if (fromRow >= 0 && toRow >= 0 && fromRow != toRow) {
                int fromContent = this.rowToContentIndex(fromRow);
                int toContent = this.rowToContentIndex(toRow);
                if (toContent < 0) {
                    toContent = this.contentCount();
                }
                if (fromContent >= 0 && toContent >= 0) {
                    int newRow;
                    try {
                        boolean ok = RadialMenu.moveInCurrent(fromContent, toContent);
                        if (!ok) {
                            Constants.LOG.info("[{}] Move failed: {} -> {}", new Object[]{"ezactions", fromContent, toContent});
                        }
                    }
                    catch (Throwable t) {
                        Constants.LOG.warn("[{}] Move exception: {} -> {} : {}", new Object[]{"ezactions", fromContent, toContent, t.toString()});
                    }
                    this.rebuildRows();
                    this.selectedRow = newRow = this.contentIndexToRow(toContent > fromContent ? toContent - 1 : toContent);
                    this.ensureSelectedVisible();
                }
            }
            this.dropAt = -1;
            this.dropTargetCategory = null;
            this.dropTargetRowIdx = -1;
            this.dropSpecial = DropSpecial.NONE;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean onListOrBar;
        ScrollbarMath.Metrics sb = ScrollbarMath.compute(this.listLeft, this.listTop, this.listWidth, this.listHeight, 6, 20, this.rowCount(), 24, this.scrollY);
        boolean bl = onListOrBar = mouseX >= (double)this.listLeft && mouseX < (double)(this.listLeft + this.listWidth) && mouseY >= (double)this.listTop && mouseY < (double)(this.listTop + this.listHeight) || mouseX >= (double)sb.trackX1 && mouseX < (double)sb.trackX2 && mouseY >= (double)sb.trackY1 && mouseY < (double)sb.trackY2;
        if (onListOrBar) {
            this.scrollY -= delta * 24.0 * 2.0;
            this.clampScroll();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private boolean hitList(double mx, double my) {
        return mx >= (double)this.listLeft && mx < (double)(this.listLeft + this.listWidth) && my >= (double)this.listTop && my < (double)(this.listTop + this.listHeight);
    }

    public void refreshFromChild() {
        try {
            this.rebuildRows();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private static enum DropSpecial {
        NONE,
        BACK_ROOT,
        BACK_PARENT;

    }
}

