/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor.config;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.z2six.ezactions.gui.editor.config.ColorUtil;

public class ColorPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<Integer> onPick;
    private int alpha;
    private int red;
    private int green;
    private int blue;
    private float hue;
    private float sat;
    private float val;
    private EditBox hexBox;
    private EditBox alphaBox;
    private AlphaSlider alphaSlider;
    private int contentLeft;
    private int contentTop;
    private int svX;
    private int svY;
    private int svW;
    private int svH;
    private int hueX;
    private int hueY;
    private int hueW;
    private int hueH;
    private boolean updatingUI = false;
    private boolean draggingSV = false;
    private boolean draggingHue = false;

    public ColorPickerScreen(Screen parent, int initialArgb, Consumer<Integer> onPick) {
        super((Component)Component.m_237113_((String)"Pick Color"));
        this.parent = parent;
        this.onPick = onPick;
        this.alpha = initialArgb >>> 24 & 0xFF;
        this.red = initialArgb >>> 16 & 0xFF;
        this.green = initialArgb >>> 8 & 0xFF;
        this.blue = initialArgb & 0xFF;
        float[] hsv = ColorUtil.rgbToHsv(this.red, this.green, this.blue);
        this.hue = hsv[0];
        this.sat = hsv[1];
        this.val = hsv[2];
    }

    protected void m_7856_() {
        super.m_7856_();
        int marginLeft = 20;
        int marginTop = 20;
        this.contentLeft = marginLeft;
        Font font = this.f_96547_;
        int titleY = marginTop;
        Objects.requireNonNull(font);
        this.contentTop = titleY + 9 + 6;
        int fieldWidth = 140;
        int fieldHeight = 20;
        int y = this.contentTop;
        this.hexBox = new EditBox(font, this.contentLeft, y, fieldWidth, fieldHeight, (Component)Component.m_237113_((String)"Hex"));
        this.hexBox.m_94199_(9);
        this.hexBox.m_94144_(ColorUtil.toHexARGB(this.alpha, this.red, this.green, this.blue));
        this.hexBox.m_94151_(text -> {
            if (this.updatingUI) {
                return;
            }
            try {
                int[] argb = ColorUtil.parseHexARGB(text);
                this.alpha = argb[0];
                this.red = argb[1];
                this.green = argb[2];
                this.blue = argb[3];
                float[] hsv = ColorUtil.rgbToHsv(this.red, this.green, this.blue);
                this.hue = hsv[0];
                this.sat = hsv[1];
                this.val = hsv[2];
                this.syncFromModel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.hexBox);
        this.alphaBox = new EditBox(font, this.contentLeft, y += fieldHeight + 6, 60, fieldHeight, (Component)Component.m_237113_((String)"Alpha"));
        this.alphaBox.m_94199_(3);
        this.alphaBox.m_94144_(Integer.toString(Math.round((float)this.alpha * 100.0f / 255.0f)));
        this.alphaBox.m_94151_(text -> {
            if (this.updatingUI) {
                return;
            }
            int pct = this.parseIntSafe((String)text, -1);
            if (pct >= 0 && pct <= 100) {
                this.alpha = Mth.m_14045_((int)Math.round((float)pct * 2.55f), (int)0, (int)255);
                this.syncFromModel();
            }
        });
        this.m_142416_((GuiEventListener)this.alphaBox);
        int sliderX = this.contentLeft + 70;
        this.alphaSlider = new AlphaSlider(sliderX, y, 120, fieldHeight, (double)this.alpha / 255.0, () -> {
            if (this.updatingUI) {
                return;
            }
            this.alpha = (int)Math.round(this.alphaSlider.getValue() * 255.0);
            this.syncFromModel();
        });
        this.m_142416_((GuiEventListener)this.alphaSlider);
        this.svX = this.contentLeft;
        this.svY = y += fieldHeight + 10;
        this.svW = 190;
        this.svH = 120;
        this.hueX = this.svX + this.svW + 8;
        this.hueY = this.svY;
        this.hueW = 14;
        this.hueH = this.svH;
        int btnY = this.svY + this.svH + 12;
        Button ok = Button.m_253074_((Component)Component.m_237115_((String)"gui.ok"), btn -> {
            int picked = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
            if (this.onPick != null) {
                this.onPick.accept(picked);
            }
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(this.contentLeft, btnY, 80, 20).m_253136_();
        Button cancel = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.contentLeft + 90, btnY, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)ok);
        this.m_142416_((GuiEventListener)cancel);
        this.syncFromModel();
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gfx);
        Objects.requireNonNull(this.f_96547_);
        gfx.m_280614_(this.f_96547_, this.f_96539_, this.contentLeft, this.contentTop - (9 + 6), 0x808080, false);
        this.drawSVSquare(gfx, this.svX, this.svY, this.svW, this.svH);
        int svHandleX = (int)((float)this.svX + this.sat * (float)(this.svW - 1));
        int svHandleY = (int)((float)this.svY + (1.0f - this.val) * (float)(this.svH - 1));
        gfx.m_280509_(svHandleX - 2, svHandleY - 2, svHandleX + 3, svHandleY + 3, -1);
        gfx.m_280509_(svHandleX - 1, svHandleY - 1, svHandleX + 2, svHandleY + 2, -16777216);
        this.drawHueBar(gfx, this.hueX, this.hueY, this.hueW, this.hueH);
        int hueYPos = (int)((float)this.hueY + this.hue * (float)(this.hueH - 1));
        gfx.m_280509_(this.hueX - 1, hueYPos - 1, this.hueX + this.hueW + 1, hueYPos + 2, -1);
        gfx.m_280509_(this.hueX, hueYPos, this.hueX + this.hueW, hueYPos + 1, -16777216);
        int previewX = this.hueX + this.hueW + 12;
        int previewY = this.svY;
        int previewW = 40;
        int previewH = 20;
        int argb = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
        this.drawChecker(gfx, previewX, previewY, previewW, previewH, 4);
        gfx.m_280509_(previewX, previewY, previewX + previewW, previewY + previewH, argb);
        gfx.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Hex"), this.contentLeft + 140 + 8, this.contentTop + 4, -5592406, false);
        gfx.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Alpha %"), this.contentLeft + 70 + 120 + 8, this.contentTop + 4 + 26, -5592406, false);
        super.m_88315_(gfx, mouseX, mouseY, partialTick);
    }

    private void drawChecker(GuiGraphics gfx, int x, int y, int w, int h, int cell) {
        int c1 = -5197648;
        int c2 = -7697782;
        for (int yy = y; yy < y + h; yy += cell) {
            for (int xx = x; xx < x + w; xx += cell) {
                boolean alt = ((xx - x) / cell + (yy - y) / cell) % 2 == 0;
                gfx.m_280509_(xx, yy, Math.min(xx + cell, x + w), Math.min(yy + cell, y + h), alt ? c1 : c2);
            }
        }
    }

    private void drawSVSquare(GuiGraphics gfx, int x, int y, int w, int h) {
        int[] rgb = ColorUtil.hsvToRgb(this.hue, 1.0f, 1.0f);
        int base = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
        gfx.m_280509_(x, y, x + w, y + h, base);
        RenderSystem.enableBlend();
        int steps = 16;
        for (int i = 0; i < steps; ++i) {
            int x0 = x + i * w / steps;
            int x1 = x + (i + 1) * w / steps;
            float t = 1.0f - ((float)i + 0.5f) / (float)steps;
            int a = (int)(t * 255.0f);
            int col = a << 24 | 0xFFFFFF;
            gfx.m_280509_(x0, y, x1, y + h, col);
        }
        gfx.m_280024_(x, y, x + w, y + h, 0, -16777216);
        RenderSystem.disableBlend();
    }

    private void drawHueBar(GuiGraphics gfx, int x, int y, int w, int h) {
        int segH = h / 6;
        int y0 = y;
        this.fillHueSegment(gfx, x, y0, w, segH, 0.0f, 0.16666667f);
        this.fillHueSegment(gfx, x, y0 += segH, w, segH, 0.16666667f, 0.33333334f);
        this.fillHueSegment(gfx, x, y0 += segH, w, segH, 0.33333334f, 0.5f);
        this.fillHueSegment(gfx, x, y0 += segH, w, segH, 0.5f, 0.6666667f);
        this.fillHueSegment(gfx, x, y0 += segH, w, segH, 0.6666667f, 0.8333333f);
        this.fillHueSegment(gfx, x, y0 += segH, w, h - 5 * segH, 0.8333333f, 1.0f);
    }

    private void fillHueSegment(GuiGraphics gfx, int x, int y, int w, int h, float h0, float h1) {
        int steps = Math.max(8, h / 2);
        for (int i = 0; i < steps; ++i) {
            float t = ((float)i + 0.5f) / (float)steps;
            float hh = Mth.m_14179_((float)t, (float)h0, (float)h1);
            int[] rgb = ColorUtil.hsvToRgb(hh, 1.0f, 1.0f);
            int col = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
            int yy0 = y + i * h / steps;
            int yy1 = y + (i + 1) * h / steps;
            gfx.m_280509_(x, yy0, x + w, yy1, col);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.inside(mouseX, mouseY, this.svX, this.svY, this.svW, this.svH)) {
            this.draggingSV = true;
            this.updateSVFromMouse(mouseX, mouseY);
            return true;
        }
        if (this.inside(mouseX, mouseY, this.hueX, this.hueY, this.hueW, this.hueH)) {
            this.draggingHue = true;
            this.updateHueFromMouse(mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingSV) {
            this.updateSVFromMouse(mouseX, mouseY);
            return true;
        }
        if (this.draggingHue) {
            this.updateHueFromMouse(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggingSV = false;
        this.draggingHue = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    private boolean inside(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    private void updateSVFromMouse(double mx, double my) {
        float sx = (float)((mx - (double)this.svX) / (double)(this.svW - 1));
        float vy = (float)((my - (double)this.svY) / (double)(this.svH - 1));
        this.sat = ColorUtil.clamp01(sx);
        this.val = ColorUtil.clamp01(1.0f - vy);
        int[] rgb = ColorUtil.hsvToRgb(this.hue, this.sat, this.val);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        this.syncFromModel();
    }

    private void updateHueFromMouse(double my) {
        float ty = (float)((my - (double)this.hueY) / (double)(this.hueH - 1));
        this.hue = ColorUtil.wrap01(ty);
        int[] rgb = ColorUtil.hsvToRgb(this.hue, this.sat, this.val);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        this.syncFromModel();
    }

    private void syncFromModel() {
        this.updatingUI = true;
        try {
            float[] hsv = ColorUtil.rgbToHsv(this.red, this.green, this.blue);
            this.hue = hsv[0];
            this.sat = hsv[1];
            this.val = hsv[2];
            this.setBoxSilently(this.hexBox, ColorUtil.toHexARGB(this.alpha, this.red, this.green, this.blue));
            int pct = Math.round((float)this.alpha * 100.0f / 255.0f);
            this.setBoxSilently(this.alphaBox, Integer.toString(pct));
            this.alphaSlider.setFromOutside((double)this.alpha / 255.0);
        }
        finally {
            this.updatingUI = false;
        }
    }

    private void setBoxSilently(EditBox box, String value) {
        if (!Objects.equals(box.m_94155_(), value)) {
            box.m_94144_(value);
        }
    }

    private int parseIntSafe(String text, int def) {
        try {
            return Integer.parseInt(text.trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private static class AlphaSlider
    extends AbstractSliderButton {
        private final Runnable onChanged;

        AlphaSlider(int x, int y, int w, int h, double initial, Runnable onChanged) {
            super(x, y, w, h, (Component)Component.m_237119_(), Mth.m_14008_((double)initial, (double)0.0, (double)1.0));
            this.onChanged = onChanged;
            this.m_5695_();
        }

        protected void m_5695_() {
            int pct = (int)Math.round(this.f_93577_ * 100.0);
            this.m_93666_((Component)Component.m_237113_((String)("Alpha: " + pct + "%")));
        }

        protected void m_5697_() {
            if (this.onChanged != null) {
                this.onChanged.run();
            }
        }

        void setFromOutside(double v) {
            double nv = Mth.m_14008_((double)v, (double)0.0, (double)1.0);
            if (Math.abs(nv - this.f_93577_) < 1.0E-6) {
                return;
            }
            this.f_93577_ = nv;
            this.m_5695_();
        }

        double getValue() {
            return this.f_93577_;
        }
    }
}

