/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.handler;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import org.lwjgl.glfw.GLFW;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.GeneralClientConfig;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.RadialMenuScreen;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;
import org.z2six.ezactions.helper.ClientTaskQueue;
import org.z2six.ezactions.helper.InputInjector;
import org.z2six.ezactions.helper.KeyboardHandlerHelper;
import org.z2six.ezactions.util.CommandSequencer;
import org.z2six.ezactions.util.EZActionsKeybinds;

public final class KeyboardHandler {
    private static boolean openHeldPrev = false;
    private static boolean suppressUntilRelease = false;
    private static boolean contextsPushed = false;
    private static KeyMapping[] trackedKeys = null;
    private static IKeyConflictContext[] prevContexts = null;

    private KeyboardHandler() {
    }

    public static void suppressReopenUntilReleased() {
        suppressUntilRelease = true;
    }

    public static void onClientTickPre(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        try {
            ClientTaskQueue.drain();
            KeyboardHandlerHelper.onClientTick();
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null || mc.f_91074_ == null) {
                return;
            }
            boolean heldNow = KeyboardHandler.isPhysicallyDown(mc, EZActionsKeybinds.OPEN_MENU);
            if (heldNow && !openHeldPrev && !suppressUntilRelease) {
                Constants.LOG.debug("[{}] Radial hotkey pressed; opening at root.", (Object)"ezactions");
                RadialMenu.open();
            }
            if (!heldNow && openHeldPrev) {
                Screen screen = mc.f_91080_;
                if (screen instanceof RadialMenuScreen) {
                    RadialMenuScreen s = (RadialMenuScreen)screen;
                    s.onHotkeyReleased();
                }
                KeyboardHandler.releaseMovementKeys(mc);
                KeyboardHandler.popMovementKeyContexts(mc);
                suppressUntilRelease = false;
            }
            openHeldPrev = heldNow;
            boolean allowMove = true;
            try {
                allowMove = (Boolean)GeneralClientConfig.INSTANCE.moveWhileRadialOpen.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (mc.f_91080_ instanceof RadialMenuScreen) {
                if (allowMove) {
                    KeyboardHandler.pushMovementKeyContexts(mc);
                    KeyboardHandler.tickMovementPassthrough(mc);
                } else if (contextsPushed) {
                    KeyboardHandler.popMovementKeyContexts(mc);
                }
            } else if (contextsPushed) {
                KeyboardHandler.popMovementKeyContexts(mc);
            }
            if (EZActionsKeybinds.OPEN_EDITOR != null && EZActionsKeybinds.OPEN_EDITOR.m_90859_()) {
                mc.m_91152_((Screen)new MenuEditorScreen(mc.f_91080_));
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Exception during onClientTickPre: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    public static void onClientTickPost(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null || mc.f_91074_ == null) {
                return;
            }
            boolean allowMove = true;
            try {
                allowMove = (Boolean)GeneralClientConfig.INSTANCE.moveWhileRadialOpen.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (allowMove && mc.f_91080_ instanceof RadialMenuScreen) {
                KeyboardHandler.tickMovementPassthrough(mc);
            }
            CommandSequencer.tickClient();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Exception during onClientTickPost: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    private static boolean isPhysicallyDown(Minecraft mc, KeyMapping mapping) {
        if (mapping == null || mc == null || mc.m_91268_() == null) {
            return false;
        }
        long window = mc.m_91268_().m_85439_();
        if (window == 0L) {
            return false;
        }
        InputConstants.Key key = mapping.getKey();
        if (key == null) {
            return false;
        }
        return switch (key.m_84868_()) {
            case InputConstants.Type.KEYSYM -> {
                int state;
                int code = key.m_84873_();
                int v0 = state = code >= 0 ? GLFW.glfwGetKey((long)window, (int)code) : 0;
                if (state == 1 || state == 2) {
                    yield true;
                }
                yield false;
            }
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)window, (int)key.m_84873_()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static void tickMovementPassthrough(Minecraft mc) {
        try {
            Options o = mc.f_91066_;
            if (o == null) {
                return;
            }
            KeyboardHandler.mirrorKey(mc, o.f_92085_);
            KeyboardHandler.mirrorKey(mc, o.f_92087_);
            KeyboardHandler.mirrorKey(mc, o.f_92086_);
            KeyboardHandler.mirrorKey(mc, o.f_92088_);
            KeyboardHandler.mirrorKey(mc, o.f_92089_);
            KeyboardHandler.mirrorKey(mc, o.f_92091_);
            KeyboardHandler.mirrorKey(mc, o.f_92090_);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Movement passthrough tick failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    private static void mirrorKey(Minecraft mc, KeyMapping km) {
        long window;
        if (km == null) {
            return;
        }
        InputConstants.Key k = km.getKey();
        if (k == null) {
            InputInjector.setKeyPressed(km, false);
            return;
        }
        long l = window = mc.m_91268_() != null ? mc.m_91268_().m_85439_() : 0L;
        if (window == 0L) {
            InputInjector.setKeyPressed(km, false);
            return;
        }
        boolean down = switch (k.m_84868_()) {
            case InputConstants.Type.KEYSYM -> {
                int state = GLFW.glfwGetKey((long)window, (int)k.m_84873_());
                if (state == 1 || state == 2) {
                    yield true;
                }
                yield false;
            }
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)window, (int)k.m_84873_()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        InputInjector.setKeyPressed(km, down);
    }

    private static void releaseMovementKeys(Minecraft mc) {
        try {
            Options o = mc.f_91066_;
            if (o == null) {
                return;
            }
            InputInjector.setKeyPressed(o.f_92085_, false);
            InputInjector.setKeyPressed(o.f_92087_, false);
            InputInjector.setKeyPressed(o.f_92086_, false);
            InputInjector.setKeyPressed(o.f_92088_, false);
            InputInjector.setKeyPressed(o.f_92089_, false);
            InputInjector.setKeyPressed(o.f_92091_, false);
            InputInjector.setKeyPressed(o.f_92090_, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void pushMovementKeyContexts(Minecraft mc) {
        if (contextsPushed) {
            return;
        }
        try {
            Options o = mc.f_91066_;
            if (o == null) {
                return;
            }
            trackedKeys = new KeyMapping[]{o.f_92085_, o.f_92087_, o.f_92086_, o.f_92088_, o.f_92089_, o.f_92091_, o.f_92090_};
            prevContexts = new IKeyConflictContext[trackedKeys.length];
            for (int i = 0; i < trackedKeys.length; ++i) {
                KeyMapping km = trackedKeys[i];
                if (km == null) continue;
                try {
                    KeyboardHandler.prevContexts[i] = km.getKeyConflictContext();
                    km.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.UNIVERSAL);
                    continue;
                }
                catch (Throwable perKey) {
                    Constants.LOG.debug("[{}] Could not push context for movement key {}: {}", new Object[]{"ezactions", i, perKey.toString()});
                }
            }
            contextsPushed = true;
            Constants.LOG.debug("[{}] Movement key contexts pushed (UNIVERSAL).", (Object)"ezactions");
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] pushMovementKeyContexts failed: {}", (Object)"ezactions", (Object)t.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void popMovementKeyContexts(Minecraft mc) {
        if (!contextsPushed) {
            return;
        }
        try {
            if (trackedKeys != null && prevContexts != null) {
                for (int i = 0; i < trackedKeys.length; ++i) {
                    KeyMapping km = trackedKeys[i];
                    IKeyConflictContext prev = prevContexts[i];
                    if (km == null || prev == null) continue;
                    try {
                        km.setKeyConflictContext(prev);
                        continue;
                    }
                    catch (Throwable perKey) {
                        Constants.LOG.debug("[{}] Could not pop context for movement key {}: {}", new Object[]{"ezactions", i, perKey.toString()});
                    }
                }
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] popMovementKeyContexts failed: {}", (Object)"ezactions", (Object)t.toString());
        }
        finally {
            contextsPushed = false;
            trackedKeys = null;
            prevContexts = null;
            Constants.LOG.debug("[{}] Movement key contexts restored.", (Object)"ezactions");
        }
    }
}

