/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.util;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.z2six.ezactions.Constants;

public final class KeyMappingLookup {
    private KeyMappingLookup() {
    }

    @Nullable
    public static KeyMapping findByName(String mappingName) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null) {
                return null;
            }
            Options opts = mc.f_91066_;
            if (opts == null || opts.f_92059_ == null) {
                return null;
            }
            for (KeyMapping km : opts.f_92059_) {
                if (km == null || !mappingName.equals(km.m_90860_())) continue;
                return km;
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] KeyMappingLookup.findByName failed for '{}': {}", new Object[]{"ezactions", mappingName, t.toString()});
        }
        return null;
    }

    public static Component localizedName(KeyMapping mapping) {
        try {
            String key = mapping.m_90860_();
            return Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0]));
        }
        catch (Throwable t) {
            return Component.m_237113_((String)mapping.m_90860_());
        }
    }

    @Nullable
    public static Integer glfwKey(KeyMapping mapping) {
        try {
            InputConstants.Key key = mapping.getKey();
            if (key == null) {
                return null;
            }
            if (key.m_84868_() != InputConstants.Type.KEYSYM) {
                return null;
            }
            return key.m_84873_();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Failed to resolve GLFW key for '{}': {}", new Object[]{"ezactions", mapping.m_90860_(), t.toString()});
            return null;
        }
    }

    @Nullable
    public static Integer glfwScancode(@Nullable Integer glfwKey) {
        try {
            if (glfwKey == null) {
                return null;
            }
            int scan = GLFW.glfwGetKeyScancode((int)glfwKey);
            return scan == 0 ? null : Integer.valueOf(scan);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Failed to resolve scancode for key {}: {}", new Object[]{"ezactions", glfwKey, t.toString()});
            return null;
        }
    }
}

