/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.biome;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import otsunozi.nikkorihazard.biome.NCBiomes;
import otsunozi.nikkorihazard.world.NCFeatureConfig;

public class NCBiomeMaker {
    private static void withoutVanilaMonster(MobSpawnInfo.Builder builder) {
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)builder);
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200762_B, 5, 2, 6));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200798_l, 1, 1, 3));
        DefaultBiomeFeatures.func_243734_b((MobSpawnInfo.Builder)builder);
    }

    public static RegistryKey<Biome> makeNikkoriBiome(String name) {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE);
        builder.func_205419_a(Biome.Category.PLAINS);
        builder.func_205414_c(0.8f);
        builder.func_205421_a(0.4f);
        builder.func_205420_b(0.5f);
        builder.func_205417_d(0.4f);
        builder.func_235097_a_(new BiomeAmbience.Builder().func_235239_a_(0xFFFF55).func_235246_b_(0x5555FF).func_235248_c_(170).func_242541_f(16766720).func_242539_d(0xFFFF55).func_235238_a_());
        builder.func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a());
        builder.func_242458_a(new MobSpawnInfo.Builder().func_242577_b());
        builder.func_242456_a(Biome.TemperatureModifier.NONE);
        MobSpawnInfo.Builder mobspawninfo$builder = new MobSpawnInfo.Builder();
        NCBiomeMaker.withoutVanilaMonster(mobspawninfo$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244159_y);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243711_Y((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243844_aq);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243704_R((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243820_aS);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        NCBiomes.BIOMES.register(name, () -> builder.func_242457_a(biomegenerationsettings$builder.func_242508_a()).func_242458_a(mobspawninfo$builder.func_242577_b()).func_242455_a());
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("nikkorihazard", name));
    }

    public static RegistryKey<Biome> makeFlowerMountainBiome(String name) {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.RAIN);
        builder.func_205419_a(Biome.Category.EXTREME_HILLS);
        builder.func_205414_c(0.7f);
        builder.func_205421_a(0.6f);
        builder.func_205420_b(0.6f);
        builder.func_205417_d(0.8f);
        builder.func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242541_f(3329330).func_242539_d(NCBiomeMaker.getSkyColorWithTemperatureModifier(0.2f)).func_235238_a_());
        builder.func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a());
        builder.func_242458_a(new MobSpawnInfo.Builder().func_242577_b());
        builder.func_242456_a(Biome.TemperatureModifier.NONE);
        MobSpawnInfo.Builder mobspawninfo$builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)mobspawninfo$builder);
        mobspawninfo$builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200769_I, 5, 4, 6));
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)mobspawninfo$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244132_C);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243689_C((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243708_V((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243932_co);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243930_cm);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243926_ci);
        DefaultBiomeFeatures.func_243709_W((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243753_m((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        NCBiomes.BIOMES.register(name, () -> builder.func_242457_a(biomegenerationsettings$builder.func_242508_a()).func_242458_a(mobspawninfo$builder.func_242577_b()).func_242455_a());
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("nikkorihazard", name));
    }

    public static RegistryKey<Biome> makeWaspForestBiome(String name) {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.RAIN);
        builder.func_205419_a(Biome.Category.FOREST);
        builder.func_205414_c(0.7f);
        builder.func_205421_a(0.1f);
        builder.func_205420_b(0.2f);
        builder.func_205417_d(0.8f);
        builder.func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242537_a(BiomeAmbience.GrassColorModifier.DARK_FOREST).func_242539_d(3328).func_235238_a_());
        builder.func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a());
        builder.func_242458_a(new MobSpawnInfo.Builder().func_242577_b());
        builder.func_242456_a(Biome.TemperatureModifier.NONE);
        MobSpawnInfo.Builder mobspawninfo$builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)mobspawninfo$builder);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)mobspawninfo$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244159_y);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243700_N((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243789_O);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, NCFeatureConfig.WASP_HIVE);
        NCBiomes.BIOMES.register(name, () -> builder.func_242457_a(biomegenerationsettings$builder.func_242508_a()).func_242458_a(mobspawninfo$builder.func_242577_b()).func_242455_a());
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("nikkorihazard", name));
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

