/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.block.farm;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import otsunozi.nikkorihazard.block.farm.INikkoriCrop;
import otsunozi.nikkorihazard.init.NCustomBlock;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.util.NCustomParticleSpawner;

public class BlockNikkoriOrangeTree
extends DoublePlantBlock
implements IGrowable,
INikkoriCrop {
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    private static final VoxelShape BUSHLING_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape GROWING_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public BlockNikkoriOrangeTree() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200946_b().func_200944_c().func_200947_a(SoundType.field_185850_c));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a(NCustomBlock.NIKKORIPLANTER);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (state.func_177229_b((Property)field_176492_b) != DoubleBlockHalf.UPPER) {
            return this.isValidPosition2(state, worldIn, pos);
        }
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            return this.isValidPosition2(state, worldIn, pos);
        }
        return blockstate.func_203425_a((Block)this) && blockstate.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER;
    }

    public boolean isValidPosition2(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return this.getBlock() == NCustomBlock.NIKKORIPLANTER;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)NCustomItem.NIKKORIORANGE_SEED);
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) < this.getMaxAge();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        if (this.isMaxAge(state) && rand.nextInt(4) == 0) {
            NCustomParticleSpawner.spawnCropMaxAgeParticles(worldIn, pos);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.UPPER) {
            return (Integer)state.func_177229_b((Property)AGE) < 2 ? BUSHLING_SHAPE : GROWING_SHAPE;
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b((Property)field_176492_b);
        if (doubleblockhalf == DoubleBlockHalf.UPPER) {
            if (!worldIn.isAreaLoaded(pos, 1)) {
                return;
            }
            int i = (Integer)state.func_177229_b((Property)AGE);
            if (!this.isMaxAge(state) && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
                if (blockstate.func_177230_c() == this) {
                    worldIn.func_180501_a(pos.func_177977_b(), (BlockState)blockstate.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos.func_177977_b(), (BlockState)state);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.isMaxAge(state)) {
            int j = 3 + worldIn.field_73012_v.nextInt(3);
            BlockNikkoriOrangeTree.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)NCustomItem.NIKKORIORANGE, j));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b((Property)field_176492_b);
            BlockPos secondpos = pos;
            BlockState secondstate = state;
            secondpos = doubleblockhalf == DoubleBlockHalf.UPPER ? secondpos.func_177977_b() : secondpos.func_177984_a();
            secondstate = worldIn.func_180495_p(secondpos);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            worldIn.func_180501_a(secondpos, (BlockState)secondstate.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(this.getMaxAge(), (Integer)state.func_177229_b((Property)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
        builder.func_206894_a(new Property[]{field_176492_b});
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180186_a((Vector3i)pos);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.NONE;
    }

    @Override
    public int getMaxAge() {
        return 7;
    }

    @Override
    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) >= this.getMaxAge();
    }
}

