/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import otsunozi.nikkorihazard.enchantment.NCustomEnchantmentType;
import otsunozi.nikkorihazard.init.NCustomEnchantment;
import otsunozi.nikkorihazard.item.enchantbook.ItemSpecialEnchantBook;

public class NCustomEnchantmentHelper {
    public static boolean hasOffhandFall(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.OFFHANDFALL, (ItemStack)stack) > 0;
    }

    public static int getPoweredWaveLevel(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.POWEREDWAVE, (ItemStack)stack);
    }

    public static int calFacebreakerVSmetal(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.FACEBREAKER, (ItemStack)stack);
    }

    public static int getMagicAmpLevel(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.MAGICAMP, (ItemStack)stack);
    }

    public static int getMagicBoosterLevel(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.MAGICBOOSTER, (ItemStack)stack);
    }

    public static boolean hasHaraherazu(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.HARAHERAZU, (ItemStack)stack) > 0;
    }

    public static boolean hasBounds(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.BOUNDS, (ItemStack)stack) > 0;
    }

    public static boolean hasSealedCritical(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.SEALEDCRITICAL, (ItemStack)stack) > 0;
    }

    public static int getMagicCriticalLevel(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.MAGICCRITICAL, (ItemStack)stack);
    }

    public static int getQuickChargeLevel(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.QUICKCHARGE, (ItemStack)stack);
    }

    public static boolean hasChestSearch(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.CHESTSEARCH, (ItemStack)stack) > 0;
    }

    public static boolean hasSafetyMagic(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NCustomEnchantment.SAFETYMAGIC, (ItemStack)stack) > 0;
    }

    public static boolean canUseWeaponBook(ItemStack stack) {
        return NCustomEnchantmentType.KinsetsuWeapon.apply((Object)stack.func_77973_b());
    }

    public static boolean canUseMagicBook(ItemStack stack) {
        return NCustomEnchantmentType.MagicWeapon.apply((Object)stack.func_77973_b());
    }

    public static ItemStack addRandomEnchantment(Random random, ItemStack p_77504_1_, int p_77504_2_, boolean allowTreasure) {
        boolean flag;
        List<EnchantmentData> list = NCustomEnchantmentHelper.buildEnchantmentList(random, p_77504_1_, p_77504_2_, allowTreasure);
        boolean bl = flag = p_77504_1_.func_77973_b() == Items.field_151122_aG;
        if (flag) {
            p_77504_1_ = new ItemStack((IItemProvider)Items.field_151134_bR);
        }
        for (EnchantmentData enchantmentdata : list) {
            if (flag) {
                EnchantedBookItem.func_92115_a((ItemStack)p_77504_1_, (EnchantmentData)enchantmentdata);
                continue;
            }
            p_77504_1_.func_77966_a(enchantmentdata.field_76302_b, enchantmentdata.field_76303_c);
        }
        return p_77504_1_;
    }

    public static List<EnchantmentData> buildEnchantmentList(Random randomIn, ItemStack itemStackIn, int level, boolean allowTreasure) {
        ArrayList list = Lists.newArrayList();
        Item item = itemStackIn.func_77973_b();
        int i = item.getItemEnchantability(itemStackIn);
        if (i <= 0) {
            return list;
        }
        level = level + 1 + randomIn.nextInt(i / 4 + 1) + randomIn.nextInt(i / 4 + 1);
        float f = (randomIn.nextFloat() + randomIn.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentData> list1 = NCustomEnchantmentHelper.getEnchantmentDatas(level = MathHelper.func_76125_a((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), itemStackIn, allowTreasure);
        if (!list1.isEmpty()) {
            list.add(WeightedRandom.func_76271_a((Random)randomIn, list1));
            while (randomIn.nextInt(50) <= level) {
                NCustomEnchantmentHelper.removeIncompatible(list1, (EnchantmentData)Util.func_223378_a((List)list));
                if (list1.isEmpty()) break;
                list.add(WeightedRandom.func_76271_a((Random)randomIn, list1));
                level /= 2;
            }
        }
        return list;
    }

    public static void removeIncompatible(List<EnchantmentData> dataList, EnchantmentData data) {
        Iterator<EnchantmentData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            if (data.field_76302_b.func_191560_c(iterator.next().field_76302_b)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentData> getEnchantmentDatas(int level, ItemStack stack, boolean allowTreasure) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.func_77973_b();
        boolean flag = stack.func_77973_b() == Items.field_151122_aG;
        block0: for (Enchantment enchantment : Registry.field_212628_q) {
            if (enchantment.func_185261_e() && !allowTreasure || enchantment.func_190936_d() || enchantment == Enchantments.field_185296_A || enchantment == NCustomEnchantment.SAFETYMAGIC || !enchantment.canApplyAtEnchantingTable(stack) && (!flag || !enchantment.isAllowedOnBooks())) continue;
            for (int i = enchantment.func_77325_b(); i > enchantment.func_77319_d() - 1; --i) {
                if (level < enchantment.func_77321_a(i) || level > enchantment.func_223551_b(i)) continue;
                list.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    public static ItemStack addEnchantmentWithSPbook(Random rand, ItemStack stack, int rarelevel) {
        ArrayList canenchlist = Lists.newArrayList();
        ArrayList addlist = Lists.newArrayList();
        if (stack.func_77973_b() instanceof ItemSpecialEnchantBook) {
            int enchantType = ((ItemSpecialEnchantBook)stack.func_77973_b()).getType();
            block0: for (Enchantment ench : Registry.field_212628_q) {
                int i;
                if (enchantType == 0) {
                    if (ench.field_77351_y != NCustomEnchantmentType.CET_KINSETSU && ench.field_77351_y != NCustomEnchantmentType.CET_KINSETSU_CANQUAKE && ench.field_77351_y != NCustomEnchantmentType.CET_KINSETSU_PARACHUL && ench != Enchantments.field_185307_s && ench != Enchantments.field_185296_A) continue;
                    for (i = ench.func_77325_b(); i > ench.func_77319_d() - 1; --i) {
                        if (rarelevel < ench.func_77321_a(i) || rarelevel > ench.func_223551_b(i)) continue;
                        canenchlist.add(new EnchantmentData(ench, i));
                        continue block0;
                    }
                    continue;
                }
                if (ench.field_77351_y != NCustomEnchantmentType.CET_MAGIC && ench.field_77351_y != NCustomEnchantmentType.CET_MAGIC_FISHROD && ench.field_77351_y != NCustomEnchantmentType.CET_MAGIC_WITHDAMAGE && ench.field_77351_y != NCustomEnchantmentType.CET_MAGIC_WITHBOUNDS && ench.field_77351_y != NCustomEnchantmentType.CET_MAGIC_WITHCHARGE && ench != Enchantments.field_185307_s && ench != Enchantments.field_185296_A || ench == NCustomEnchantment.SAFETYMAGIC) continue;
                for (i = ench.func_77325_b(); i > ench.func_77319_d() - 1; --i) {
                    if (rarelevel < ench.func_77321_a(i) || rarelevel > ench.func_223551_b(i)) continue;
                    canenchlist.add(new EnchantmentData(ench, i));
                    continue block0;
                }
            }
            if (!canenchlist.isEmpty()) {
                addlist.add(WeightedRandom.func_76271_a((Random)rand, (List)canenchlist));
                for (EnchantmentData enchantmentdata : addlist) {
                    NCustomEnchantmentHelper.addEnchantment(stack, enchantmentdata);
                }
            }
        } else {
            System.out.println("\u3010\u30a8\u30e9\u30fc\u3011\u30a8\u30f3\u30c1\u30e3\u30f3\u30c8\u5bfe\u8c61\u304c\u30b9\u30da\u30b7\u30e3\u30eb\u5f37\u5316\u306e\u66f8\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        return stack;
    }

    public static void addEnchantment(ItemStack stack, EnchantmentData stackIn) {
        ListNBT listnbt = NCustomEnchantmentHelper.getEnchantments(stack);
        boolean flag = true;
        ResourceLocation resourcelocation = Registry.field_212628_q.func_177774_c((Object)stackIn.field_76302_b);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            ResourceLocation resourcelocation1 = ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("id"));
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            if (compoundnbt.func_74762_e("lvl") < stackIn.field_76303_c) {
                compoundnbt.func_74777_a("lvl", (short)stackIn.field_76303_c);
            }
            flag = false;
            break;
        }
        if (flag) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_74778_a("id", String.valueOf(resourcelocation));
            compoundnbt1.func_74777_a("lvl", (short)stackIn.field_76303_c);
            listnbt.add((Object)compoundnbt1);
        }
        stack.func_196082_o().func_218657_a("StoredEnchantments", (INBT)listnbt);
    }

    public static ListNBT getEnchantments(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null ? compoundnbt.func_150295_c("StoredEnchantments", 10) : new ListNBT();
    }

    public static Map<Enchantment, Integer> getEnchantmentsForSPBook(ItemStack stack) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        ListNBT nbttaglist = NCustomEnchantmentHelper.getEnchantments(stack);
        return EnchantmentHelper.func_226652_a_((ListNBT)nbttaglist);
    }
}

