/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.enchantment;

import com.google.common.base.Predicate;
import java.util.Arrays;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.Item;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.item.weapon.ItemNikkoriParachul;
import otsunozi.nikkorihazard.item.weapon.magic.ItemEnergyFishRod;

public class NCustomEnchantmentType {
    private static final Item[] KinsetsuWeapons = new Item[]{NCustomItem.IRONHAMMER, NCustomItem.NIKKORIHAMMER, NCustomItem.NIKKORIHUDEPEN, NCustomItem.NIKKORIPARACHUL, NCustomItem.NIKKORYPOISON, NCustomItem.NIKKORYTABARZIN, NCustomItem.NIKKORIMACE, NCustomItem.NIKKORIKINGSSWORD, NCustomItem.OBSIDIANSWORD, NCustomItem.NIKKORICUTLASS, NCustomItem.SYORYUTOU, NCustomItem.NIKKORILONGSWORD, NCustomItem.BURNERKUKRI, NCustomItem.EMERALDBLADE, NCustomItem.FROZENBANANA, NCustomItem.BLOODYKNIFE, NCustomItem.NIKKORISICKLE, NCustomItem.NIKKORIICEMOUL, NCustomItem.SKELETON_RAPIER, NCustomItem.NIKKORIGOLEMHAMMER, NCustomItem.SMIRITEBLADE, NCustomItem.NIKKORIBLADE};
    private static final Item[] KinsetsuQuakeWeapons = new Item[]{NCustomItem.IRONHAMMER, NCustomItem.NIKKORIHAMMER, NCustomItem.NIKKORIMACE, NCustomItem.NIKKORIICEMOUL, NCustomItem.NIKKORIGOLEMHAMMER};
    private static final Item[] MagicWeapons = new Item[]{NCustomItem.ENERGYBOLT, NCustomItem.ENERGYFLAME, NCustomItem.NIKKORISKELETONSTAFF, NCustomItem.NIKKORILIGHTNING, NCustomItem.ENERGYFISHROD, NCustomItem.ENERGYFREEZE, NCustomItem.ENERGYFLINT, NCustomItem.NIKKORITORNADO, NCustomItem.ELITE_SKELETON_STAFF, NCustomItem.NIKKORIMAGICCLAW, NCustomItem.NIKKORICOLDBEAM, NCustomItem.NIKKORIPLOSION, NCustomItem.NIKKORIDEATHCRACKER};
    private static final Item[] MagicWeaponsWithDamage = new Item[]{NCustomItem.ENERGYBOLT, NCustomItem.ENERGYFLAME, NCustomItem.NIKKORISKELETONSTAFF, NCustomItem.NIKKORILIGHTNING, NCustomItem.ENERGYFREEZE, NCustomItem.ENERGYFLINT, NCustomItem.NIKKORITORNADO, NCustomItem.ELITE_SKELETON_STAFF, NCustomItem.NIKKORIMAGICCLAW, NCustomItem.NIKKORICOLDBEAM, NCustomItem.NIKKORIPLOSION, NCustomItem.NIKKORIDEATHCRACKER};
    private static final Item[] MagicWeaponsWithBounds = new Item[]{NCustomItem.ENERGYBOLT, NCustomItem.ENERGYFLAME, NCustomItem.NIKKORISKELETONSTAFF, NCustomItem.NIKKORILIGHTNING, NCustomItem.ENERGYFISHROD, NCustomItem.ENERGYFREEZE, NCustomItem.ENERGYFLINT, NCustomItem.NIKKORITORNADO, NCustomItem.ELITE_SKELETON_STAFF, NCustomItem.NIKKORIMAGICCLAW, NCustomItem.NIKKORICOLDBEAM, NCustomItem.NIKKORIPLOSION, NCustomItem.NIKKORIDEATHCRACKER};
    private static final Item[] MagicWeaponsWithCharge = new Item[]{NCustomItem.ENERGYBOLT, NCustomItem.ENERGYFLAME, NCustomItem.NIKKORISKELETONSTAFF, NCustomItem.NIKKORILIGHTNING, NCustomItem.ENERGYFREEZE, NCustomItem.NIKKORITORNADO, NCustomItem.ELITE_SKELETON_STAFF, NCustomItem.NIKKORIDEATHCRACKER};
    public static Predicate<Item> KinsetsuWeapon = new Predicate<Item>(){

        public boolean apply(Item item) {
            return Arrays.asList(KinsetsuWeapons).contains(item);
        }
    };
    private static Predicate<Item> KinsetsuHammerWeapon = new Predicate<Item>(){

        public boolean apply(Item item) {
            return Arrays.asList(KinsetsuQuakeWeapons).contains(item);
        }
    };
    private static Predicate<Item> KinsetsuParachulWeapon = new Predicate<Item>(){

        public boolean apply(Item item) {
            return item instanceof ItemNikkoriParachul;
        }
    };
    public static Predicate<Item> MagicWeapon = new Predicate<Item>(){

        public boolean apply(Item item) {
            return Arrays.asList(MagicWeapons).contains(item);
        }
    };
    private static Predicate<Item> MagicWeaponWithDamage = new Predicate<Item>(){

        public boolean apply(Item item) {
            return Arrays.asList(MagicWeaponsWithDamage).contains(item);
        }
    };
    private static Predicate<Item> MagicWeaponWithBounds = new Predicate<Item>(){

        public boolean apply(Item item) {
            return Arrays.asList(MagicWeaponsWithBounds).contains(item);
        }
    };
    private static Predicate<Item> MagicWeaponWithCharge = new Predicate<Item>(){

        public boolean apply(Item item) {
            return Arrays.asList(MagicWeaponsWithCharge).contains(item);
        }
    };
    private static Predicate<Item> MagicWeaponFishRod = new Predicate<Item>(){

        public boolean apply(Item item) {
            return item instanceof ItemEnergyFishRod;
        }
    };
    public static Predicate<Item> KinsetsuAndMagicWeapon = new Predicate<Item>(){

        public boolean apply(Item item) {
            return Arrays.asList(KinsetsuWeapons, MagicWeapons).contains(item);
        }
    };
    public static final EnchantmentType CET_KINSETSU = EnchantmentType.create((String)"CET_KINSETSU", KinsetsuWeapon);
    public static final EnchantmentType CET_KINSETSU_CANQUAKE = EnchantmentType.create((String)"CET_KINSETSU_HAMMER", KinsetsuHammerWeapon);
    public static final EnchantmentType CET_KINSETSU_PARACHUL = EnchantmentType.create((String)"CET_KINSETSU_PARACHUL", KinsetsuParachulWeapon);
    public static final EnchantmentType CET_MAGIC = EnchantmentType.create((String)"CET_MAGIC", MagicWeapon);
    public static final EnchantmentType CET_MAGIC_WITHDAMAGE = EnchantmentType.create((String)"CET_MAGIC_WITHDAMAGE", MagicWeaponWithDamage);
    public static final EnchantmentType CET_MAGIC_WITHBOUNDS = EnchantmentType.create((String)"CET_MAGIC_WITHBOUNDS", MagicWeaponWithBounds);
    public static final EnchantmentType CET_MAGIC_FISHROD = EnchantmentType.create((String)"CET_MAGIC_FISHROD", MagicWeaponFishRod);
    public static final EnchantmentType CET_MAGIC_WITHCHARGE = EnchantmentType.create((String)"CET_MAGIC_WIDECHARGE", MagicWeaponWithCharge);
    public static final EnchantmentType CET_KINSETSU_AND_MAGIC = EnchantmentType.create((String)"CET_KINSETSU_AND_MAGIC", KinsetsuWeapon);

    public static boolean isAdditionalEnch(Enchantment ench) {
        return ench.field_77351_y == CET_KINSETSU || ench.field_77351_y == CET_KINSETSU_CANQUAKE || ench.field_77351_y == CET_KINSETSU_PARACHUL || ench.field_77351_y == CET_MAGIC || ench.field_77351_y == CET_MAGIC_FISHROD || ench.field_77351_y == CET_MAGIC_WITHBOUNDS || ench.field_77351_y == CET_MAGIC_WITHDAMAGE || ench.field_77351_y == CET_MAGIC_WITHCHARGE;
    }
}

