/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity;

import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import otsunozi.nikkorihazard.ai.EntityAIReachSettingMeleeAttack;
import otsunozi.nikkorihazard.entity.INikkoriMob;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NCustomDamageSource;
import otsunozi.nikkorihazard.util.NElements;
import otsunozi.nikkorihazard.util.NMobDropUtil;
import otsunozi.nikkorihazard.util.WickedMoonProvider;

public class EntityNikkoligator
extends MonsterEntity
implements INikkoriMob,
INikkoriModMob {
    private int attackTimer;
    private int fireTimer;
    private double motionSaveX;
    private double motionSaveZ;
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityNikkoligator.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FACE_ROTATE = EntityDataManager.func_187226_a(EntityNikkoligator.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CHIN_STATE = EntityDataManager.func_187226_a(EntityNikkoligator.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DEATH = EntityDataManager.func_187226_a(EntityNikkoligator.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityNikkoligator(EntityType<? extends EntityNikkoligator> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 30;
        this.attackTimer = this.field_70146_Z.nextInt(120) + 60;
        this.motionSaveX = 0.0;
        this.motionSaveZ = 0.0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIReachSettingMeleeAttack((CreatureEntity)this, 1.25, 1.5f, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_NIKKORI;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.5f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(DEATH, (Object)false);
        this.field_70180_af.func_187214_a(FACE_ROTATE, (Object)0);
        this.field_70180_af.func_187214_a(CHIN_STATE, (Object)0);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 70.0).func_233815_a_(Attributes.field_233819_b_, 36.0).func_233815_a_(Attributes.field_233821_d_, 0.21).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public void func_70636_d() {
        if (this.func_110143_aJ() == 0.0f && !this.getNikkori()) {
            this.field_70180_af.func_187227_b(DEATH, (Object)true);
            this.setFaceRotate(0);
            this.setChinState(0);
        } else {
            if (this.attackTimer > 0 && this.func_70638_az() != null && !this.field_70729_aU) {
                --this.attackTimer;
                this.fireTimer = 0;
                if (this.attackTimer == 0 && !this.field_70729_aU) {
                    boolean canAttack1 = false;
                    boolean canAttack2 = false;
                    if (this.func_70638_az() != null) {
                        canAttack1 = this.func_70635_at().func_75522_a((Entity)this.func_70638_az());
                        boolean bl = canAttack2 = this.func_70032_d((Entity)this.func_70638_az()) <= 30.0f;
                    }
                    if (canAttack1 && canAttack2) {
                        this.fireTimer = 100;
                    } else {
                        this.attackTimer = this.field_70146_Z.nextInt(100) + 40;
                    }
                }
            } else if (this.attackTimer == 0 && this.fireTimer > 0 && this.func_110143_aJ() > 0.0f) {
                --this.fireTimer;
                if (this.fireTimer == 99) {
                    this.setFaceRotate(1);
                    this.setChinState(1);
                } else if (this.fireTimer == 90) {
                    this.setChinState(2);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORI_BRIZZARD_CHARGE, SoundCategory.BLOCKS, 3.0f, 1.0f);
                } else if (this.fireTimer == 50) {
                    if (this.func_70638_az() != null && !this.field_70729_aU) {
                        this.setChinState(3);
                        this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 90.0f, 90.0f);
                        Vector3d vec = this.func_70040_Z();
                        this.motionSaveX = vec.field_72450_a * (double)1.45f;
                        this.motionSaveZ = vec.field_72449_c * (double)1.45f;
                    }
                } else if (this.fireTimer >= 0 && this.fireTimer <= 50 && this.func_70638_az() != null && !this.field_70729_aU) {
                    this.func_70661_as().func_75499_g();
                    if ((this.field_70122_E || this.field_70171_ac) && this.fireTimer % 8 == 0) {
                        NCMotion.setMotionX((Entity)this, this.motionSaveX);
                        NCMotion.setMotionZ((Entity)this, this.motionSaveZ);
                        NCMotion.setAddMotionY((Entity)this, 0.6f);
                    } else if (!this.field_70122_E && !this.field_70171_ac && NCMotion.getMotionX((Entity)this) == 0.0 && NCMotion.getMotionZ((Entity)this) == 0.0) {
                        NCMotion.setAddMotionX((Entity)this, this.motionSaveX * (double)0.05f);
                        NCMotion.setAddMotionZ((Entity)this, this.motionSaveZ * (double)0.05f);
                    }
                    Vector3d vec = this.func_70040_Z();
                    AxisAlignedBB axis = this.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5).func_72317_d(vec.field_72450_a * (double)1.45f, 0.0, vec.field_72449_c * (double)1.45f);
                    int damage = 15;
                    Iterator iterator = this.field_70170_p.func_217357_a(LivingEntity.class, axis).iterator();
                    while (iterator.hasNext()) {
                        LivingEntity target = (LivingEntity)iterator.next();
                        if (target != this) {
                            MonsterEntity mob;
                            if (target instanceof MonsterEntity && (!NElements.isNonBoss((Entity)(mob = (MonsterEntity)target)) || mob.func_70668_bt() == NCustomCreatureAttribute.CCA_METAL)) {
                                this.setChinState(1);
                                this.func_70097_a(DamageSource.field_76380_i, 999.0f);
                                break;
                            }
                            target.func_70097_a(NCustomDamageSource.causeBaitDamage((Entity)this), (float)damage);
                        }
                        iterator.remove();
                    }
                }
                if (this.fireTimer > 50) {
                    NCMotion.setMultipliedMotionX((Entity)this, 0.05f);
                    NCMotion.setMultipliedMotionZ((Entity)this, 0.05f);
                }
                if (this.fireTimer == 0) {
                    this.setFaceRotate(0);
                    this.setChinState(0);
                    this.attackTimer = this.field_70146_Z.nextInt(120) + 100;
                }
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
                this.attackTimer = this.field_70146_Z.nextInt(120) + 60;
                this.setFaceRotate(0);
                this.setChinState(0);
            }
        }
        super.func_70636_d();
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FACE_ROTATE.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    public final void func_213323_x_() {
        super.func_213323_x_();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.getFaceRotate() == 1 ? EntitySize.func_220311_c((float)0.9f, (float)1.8f) : super.func_213305_a(poseIn);
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        NMobDropUtil.dropBaseItem((Entity)this, source, Items.field_151076_bf, this.field_70146_Z, recentlyHitIn, looting);
        NMobDropUtil.dropNikkorinium((LivingEntity)this, source, 50, recentlyHitIn, looting);
        NMobDropUtil.dropItem((Entity)this, NCustomItem.NIKKORINIUM, this.field_70146_Z.nextInt(2) + 1);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
        NMobDropUtil.dropEnchantBook((LivingEntity)this, damageSourceIn, 6.0f, this.field_70146_Z.nextInt(21) + 15, attackedRecently, 0, NMobDropUtil.DropBookKindSets.NORMAL_AND_SPECIAL_4);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 4.0f, NCustomItem.EGAOZIUM, 1, attackedRecently);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 66.0f, Items.field_151103_aS, this.field_70146_Z.nextInt(5) + 2, attackedRecently);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 14.2f, NCustomItem.HIPPO_FANG, 1, attackedRecently);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (NElements.isIceDamage(source)) {
            return super.func_70097_a(source, damage * 2.0f);
        }
        if (NElements.isThunderDamage(source)) {
            return super.func_70097_a(source, damage * 2.0f);
        }
        return super.func_70097_a(source, damage);
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return !WickedMoonProvider.isWickedMoon(worldIn) && worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityNikkoligator.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityNikkoligator.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187783_eT;
    }

    protected SoundEvent func_184615_bR() {
        return CustomSound.ENDERMAN_S_DEATH;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public boolean getNikkori() {
        return (Boolean)this.field_70180_af.func_187225_a(DEATH);
    }

    public void setPowered(boolean state) {
        this.field_70180_af.func_187227_b(POWERED, (Object)state);
    }

    public int getFaceRotate() {
        return (Integer)this.field_70180_af.func_187225_a(FACE_ROTATE);
    }

    public int getChinState() {
        return (Integer)this.field_70180_af.func_187225_a(CHIN_STATE);
    }

    public void setFaceRotate(int state) {
        this.field_70180_af.func_187227_b(FACE_ROTATE, (Object)state);
    }

    public void setChinState(int state) {
        this.field_70180_af.func_187227_b(CHIN_STATE, (Object)state);
    }
}

