/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity;

import java.util.Random;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import otsunozi.nikkorihazard.ai.EntityAINikkoriCreeperSwell;
import otsunozi.nikkorihazard.entity.INikkoriMob;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.entity.item.EntityNicolearBomb;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NElements;
import otsunozi.nikkorihazard.util.NMobDropUtil;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class EntityNikkoriCreeper
extends MonsterEntity
implements INikkoriMob,
INikkoriModMob,
IChargeableMob {
    private int lastActiveTime;
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityNikkoriCreeper.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityNikkoriCreeper.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityNikkoriCreeper.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int timeSinceIgnited;
    private int fuseTime = 30;

    public EntityNikkoriCreeper(EntityType<? extends EntityNikkoriCreeper> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new EntityAINikkoriCreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, OcelotEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, CatEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_NIKKORI;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 20;
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 0.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode(i);
            }
        }
        super.func_70071_h_();
    }

    private void explode(int state) {
        if (this.getPowered()) {
            if (!this.field_70170_p.field_72995_K) {
                EntityNicolearBomb tnt = new EntityNicolearBomb(this.field_70170_p, (float)this.func_226277_ct_(), this.func_226278_cu_() + 1.0, (float)this.func_226281_cx_(), (LivingEntity)this);
                NCMotion.setMotionX(tnt, -MathHelper.func_76126_a((float)(this.field_70759_as * (float)Math.PI / 180.0f)) * (float)state * 0.5f);
                NCMotion.setMotionZ(tnt, MathHelper.func_76134_b((float)(this.field_70759_as * (float)Math.PI / 180.0f)) * (float)state * 0.5f);
                NCMotion.setMotionY(tnt, this.field_70146_Z.nextDouble() * 0.3 + 0.1);
                tnt.setFuse(70);
                this.field_70170_p.func_217376_c((Entity)tnt);
            }
        } else if (!this.field_70170_p.field_72995_K) {
            TNTEntity tnt = new TNTEntity(this.field_70170_p, (double)((float)this.func_226277_ct_()), this.func_226278_cu_() + 1.0, (double)((float)this.func_226281_cx_()), (LivingEntity)this);
            NCMotion.setMotionX((Entity)tnt, -MathHelper.func_76126_a((float)(this.field_70759_as * (float)Math.PI / 180.0f)) * (float)state * 0.5f);
            NCMotion.setMotionZ((Entity)tnt, MathHelper.func_76134_b((float)(this.field_70759_as * (float)Math.PI / 180.0f)) * (float)state * 0.5f);
            NCMotion.setMotionY((Entity)tnt, this.field_70146_Z.nextDouble() * 0.3 + 0.3);
            tnt.func_184534_a(40);
            this.field_70170_p.func_217376_c((Entity)tnt);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70656_aK();
            this.func_241204_bJ_();
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(playerIn, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                itemstack.func_222118_a(1, (LivingEntity)playerIn, player -> player.func_213334_d(hand));
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(playerIn, hand);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        boolean flag = super.func_225503_b_(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return flag;
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public boolean func_225509_J__() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightning) {
        super.func_241841_a(world, lightning);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        NMobDropUtil.dropBaseItem((Entity)this, source, Items.field_151016_H, this.field_70146_Z, recentlyHitIn, looting);
        NMobDropUtil.dropNikkorinium((LivingEntity)this, source, 33, recentlyHitIn, looting);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
        NMobDropUtil.dropEnchantBook((LivingEntity)this, damageSourceIn, 5.0f, this.field_70146_Z.nextInt(21) + 15, attackedRecently, 0, NMobDropUtil.DropBookKindSets.NORMAL_AND_SPECIAL_2);
        for (int i = 0; i < 3; ++i) {
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 66.0f, Items.field_151016_H, 1, attackedRecently);
        }
    }

    public final boolean func_70097_a(DamageSource source, float amount) {
        if (NElements.isThunderDamage(source)) {
            this.field_70180_af.func_187227_b(POWERED, (Object)true);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && (double)pos.func_177956_o() <= 62.0 && !worldIn.func_175710_j(pos) && EntityNikkoriCreeper.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityNikkoriCreeper.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }
}

