/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity;

import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import otsunozi.nikkorihazard.biome.NCBiomes;
import otsunozi.nikkorihazard.block.BlockGhostCandyWall;
import otsunozi.nikkorihazard.entity.INikkoriMob;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.init.NCustomBlock;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NMobDropUtil;

public class EntityNikkoriGhost
extends MonsterEntity
implements INikkoriMob,
INikkoriModMob {
    @Nullable
    private BlockPos savedTorchPos = null;
    private int remainingCooldownBeforeLocatingNewTorch = 0;

    public EntityNikkoriGhost(EntityType<? extends EntityNikkoriGhost> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PollinateGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new EntityAIFindTorch());
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221657_bQ}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WanderGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal((MobEntity)this));
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_NIKKORI;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233822_e_, 0.6).func_233815_a_(Attributes.field_233821_d_, 0.27).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    public void func_70636_d() {
        if (this.remainingCooldownBeforeLocatingNewTorch > 0) {
            --this.remainingCooldownBeforeLocatingNewTorch;
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            float f = this.func_70013_c();
            BlockPos blockpos = new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_());
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_226660_f_(blockpos)) {
                this.func_70656_aK();
                this.func_241204_bJ_();
            }
        }
        super.func_70636_d();
    }

    private void startMovingTo(BlockPos pos) {
        Vector3d vector3d1;
        Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)pos);
        int i = 0;
        BlockPos blockpos = this.func_233580_cy_();
        int j = (int)vector3d.field_72448_b - blockpos.func_177956_o();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.func_218139_n((Vector3i)pos);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vector3d1 = RandomPositionGenerator.func_226344_b_((CreatureEntity)this, (int)k, (int)l, (int)i, (Vector3d)vector3d, (double)0.3141592741012573)) != null) {
            this.field_70699_by.func_226335_a_(0.5f);
            this.field_70699_by.func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, 1.0);
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }

            public void func_75501_e() {
                super.func_75501_e();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.hasFlower()) {
            compound.func_218657_a("FlowerPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getFlowerPos()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        this.savedTorchPos = null;
        if (compound.func_74764_b("FlowerPos")) {
            this.savedTorchPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("FlowerPos"));
        }
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        NMobDropUtil.dropBaseItem((Entity)this, source, Items.field_151121_aF, this.field_70146_Z, recentlyHitIn, looting);
        NMobDropUtil.dropNikkorinium((LivingEntity)this, source, 16, recentlyHitIn, looting);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
        NMobDropUtil.dropEnchantBook((LivingEntity)this, damageSourceIn, 1.0f, this.field_70146_Z.nextInt(21) + 15, attackedRecently, 1, NMobDropUtil.DropBookKindSets.NORMAL_AND_SPECIAL_1);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void func_180466_bG(ITag<Fluid> fluidTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
    }

    private boolean isWithinDistance(BlockPos pos, int distance) {
        return pos.func_218141_a((Vector3i)this.func_233580_cy_(), (double)distance);
    }

    private boolean isTorch(BlockPos pos) {
        return this.field_70170_p.func_195588_v(pos) && this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof TorchBlock;
    }

    private boolean isTooFar(BlockPos pos) {
        return !this.isWithinDistance(pos, 24);
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return (double)pos.func_177956_o() <= 50.0 && !worldIn.func_175710_j(pos) && worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityNikkoriGhost.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityNikkoriGhost.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected SoundEvent func_184639_G() {
        return CustomSound.NIKKORIGRASS_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187555_bJ;
    }

    @Nullable
    public BlockPos getFlowerPos() {
        return this.savedTorchPos;
    }

    public boolean hasFlower() {
        return this.savedTorchPos != null;
    }

    public void setFlowerPos(BlockPos pos) {
        this.savedTorchPos = pos;
    }

    class PollinateGoal
    extends PassiveGoal {
        private final Predicate<BlockState> torchPredicate;
        private int magicTicks;
        private int lastMagicTicks;
        private boolean running;
        private Vector3d nextTarget;
        private int ticks;

        PollinateGoal() {
            this.torchPredicate = p_226499_0_ -> p_226499_0_.func_177230_c() instanceof TorchBlock;
            this.magicTicks = 0;
            this.lastMagicTicks = 0;
            this.ticks = 0;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canGhostStart() {
            if (EntityNikkoriGhost.this.remainingCooldownBeforeLocatingNewTorch > 0) {
                return false;
            }
            if (EntityNikkoriGhost.this.field_70146_Z.nextFloat() < 0.7f) {
                return false;
            }
            Optional<BlockPos> optional = this.getTorch();
            if (optional.isPresent()) {
                EntityNikkoriGhost.this.savedTorchPos = optional.get();
                EntityNikkoriGhost.this.field_70699_by.func_75492_a((double)EntityNikkoriGhost.this.savedTorchPos.func_177958_n() + 0.5, (double)EntityNikkoriGhost.this.savedTorchPos.func_177956_o() + 0.5, (double)EntityNikkoriGhost.this.savedTorchPos.func_177952_p() + 0.5, (double)1.2f);
                return true;
            }
            return false;
        }

        @Override
        public boolean canGhostContinue() {
            if (!this.running) {
                return false;
            }
            if (!EntityNikkoriGhost.this.hasFlower()) {
                return false;
            }
            if (this.completedMagic()) {
                return EntityNikkoriGhost.this.field_70146_Z.nextFloat() < 0.2f;
            }
            if (EntityNikkoriGhost.this.field_70173_aa % 20 == 0 && !EntityNikkoriGhost.this.isTorch(EntityNikkoriGhost.this.savedTorchPos)) {
                EntityNikkoriGhost.this.savedTorchPos = null;
                return false;
            }
            return true;
        }

        private boolean completedMagic() {
            return this.magicTicks > 200;
        }

        private boolean isRunning() {
            return this.running;
        }

        private void cancel() {
            this.running = false;
        }

        public void func_75249_e() {
            this.magicTicks = 0;
            this.ticks = 0;
            this.lastMagicTicks = 0;
            this.running = true;
        }

        public void func_75251_c() {
            BlockState blockstate;
            if (this.completedMagic() && ForgeEventFactory.getMobGriefingEvent((World)EntityNikkoriGhost.this.field_70170_p, (Entity)EntityNikkoriGhost.this) && EntityNikkoriGhost.this.hasFlower() && (blockstate = EntityNikkoriGhost.this.field_70170_p.func_180495_p(EntityNikkoriGhost.this.getFlowerPos())).func_177230_c() instanceof TorchBlock && EntityNikkoriGhost.this.field_70170_p.func_226691_t_(EntityNikkoriGhost.this.savedTorchPos).getRegistryName().toString().equals(NCBiomes.NIKKORIBIOME.func_240901_a_().toString()) && blockstate.canEntityDestroy((IBlockReader)EntityNikkoriGhost.this.field_70170_p, EntityNikkoriGhost.this.getFlowerPos(), (Entity)EntityNikkoriGhost.this) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)EntityNikkoriGhost.this, (BlockPos)EntityNikkoriGhost.this.getFlowerPos(), (BlockState)blockstate)) {
                this.changeCandyFromTorch(blockstate);
            }
            this.running = false;
            EntityNikkoriGhost.this.field_70699_by.func_75499_g();
            EntityNikkoriGhost.this.remainingCooldownBeforeLocatingNewTorch = 100;
        }

        public void changeCandyFromTorch(BlockState state) {
            if (state.func_177230_c() instanceof WallTorchBlock) {
                Direction direction = (Direction)state.func_177229_b((Property)WallTorchBlock.field_196532_a);
                EntityNikkoriGhost.this.field_70170_p.func_180501_a(EntityNikkoriGhost.this.getFlowerPos(), (BlockState)NCustomBlock.GHOSTCANDY_WALL_BLOCK.func_176223_P().func_206870_a((Property)BlockGhostCandyWall.HORIZONTAL_FACING, (Comparable)direction), 2);
            } else if (state.func_177230_c() instanceof TorchBlock) {
                EntityNikkoriGhost.this.field_70170_p.func_180501_a(EntityNikkoriGhost.this.getFlowerPos(), NCustomBlock.GHOSTCANDY_BLOCK.func_176223_P(), 2);
            }
            EntityNikkoriGhost.this.func_70656_aK();
        }

        public void func_75246_d() {
            ++this.ticks;
            if (this.ticks > 400) {
                EntityNikkoriGhost.this.savedTorchPos = null;
            } else {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)EntityNikkoriGhost.this.savedTorchPos).func_72441_c(0.0, (double)0.6f, 0.0);
                if (vector3d.func_72438_d(EntityNikkoriGhost.this.func_213303_ch()) > 1.0) {
                    this.nextTarget = vector3d;
                    this.moveToNextTarget();
                } else {
                    if (this.nextTarget == null) {
                        this.nextTarget = vector3d;
                    }
                    boolean flag = EntityNikkoriGhost.this.func_213303_ch().func_72438_d(this.nextTarget) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.ticks > 600) {
                        EntityNikkoriGhost.this.savedTorchPos = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = EntityNikkoriGhost.this.field_70146_Z.nextInt(25) == 0;
                            if (flag2) {
                                this.nextTarget = new Vector3d(vector3d.func_82615_a() + (double)this.getRandomOffset(), vector3d.func_82617_b(), vector3d.func_82616_c() + (double)this.getRandomOffset());
                                EntityNikkoriGhost.this.field_70699_by.func_75499_g();
                            } else {
                                flag1 = false;
                            }
                            EntityNikkoriGhost.this.func_70671_ap().func_220679_a(vector3d.func_82615_a(), vector3d.func_82617_b(), vector3d.func_82616_c());
                        }
                        if (flag1) {
                            this.moveToNextTarget();
                        }
                        ++this.magicTicks;
                        if (EntityNikkoriGhost.this.field_70146_Z.nextFloat() < 0.05f && this.magicTicks > this.lastMagicTicks + 60) {
                            this.lastMagicTicks = this.magicTicks;
                            EntityNikkoriGhost.this.func_184185_a(SoundEvents.field_226129_ad_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget() {
            EntityNikkoriGhost.this.func_70605_aq().func_75642_a(this.nextTarget.func_82615_a(), this.nextTarget.func_82617_b(), this.nextTarget.func_82616_c(), (double)0.35f);
        }

        private float getRandomOffset() {
            return (EntityNikkoriGhost.this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> getTorch() {
            return this.findTorch(this.torchPredicate, 7.0);
        }

        private Optional<BlockPos> findTorch(Predicate<BlockState> p_226500_1_, double distance) {
            BlockPos blockpos = EntityNikkoriGhost.this.func_233580_cy_();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = 0;
            while ((double)i <= distance) {
                int j = 0;
                while ((double)j < distance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            blockpos$mutable.func_239621_a_((Vector3i)blockpos, k, i - 1, l);
                            if (blockpos.func_218141_a((Vector3i)blockpos$mutable, distance) && p_226500_1_.test((Object)EntityNikkoriGhost.this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable))) {
                                return Optional.of(blockpos$mutable);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityNikkoriGhost.this.field_70699_by.func_75500_f() && EntityNikkoriGhost.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return EntityNikkoriGhost.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.getRandomLocation();
            if (vector3d != null) {
                EntityNikkoriGhost.this.field_70699_by.func_75484_a(EntityNikkoriGhost.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d getRandomLocation() {
            Vector3d vector3d = EntityNikkoriGhost.this.func_70676_i(0.0f);
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)EntityNikkoriGhost.this, (int)8, (int)7, (Vector3d)vector3d, (float)1.5707964f, (int)2, (int)1);
            return RandomPositionGenerator.func_226338_a_((CreatureEntity)EntityNikkoriGhost.this, (int)8, (int)4, (int)-6, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }

    abstract class PassiveGoal
    extends Goal {
        private PassiveGoal() {
        }

        public abstract boolean canGhostStart();

        public abstract boolean canGhostContinue();

        public boolean func_75250_a() {
            return this.canGhostStart();
        }

        public boolean func_75253_b() {
            return this.canGhostContinue();
        }
    }

    public class EntityAIFindTorch
    extends PassiveGoal {
        private int ticks;

        EntityAIFindTorch() {
            this.ticks = EntityNikkoriGhost.this.field_70170_p.field_73012_v.nextInt(10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canGhostStart() {
            return EntityNikkoriGhost.this.savedTorchPos != null && this.shouldMoveToFlower() && EntityNikkoriGhost.this.isTorch(EntityNikkoriGhost.this.savedTorchPos) && !EntityNikkoriGhost.this.isWithinDistance(EntityNikkoriGhost.this.savedTorchPos, 2);
        }

        @Override
        public boolean canGhostContinue() {
            return this.canGhostStart();
        }

        public void func_75249_e() {
            this.ticks = 0;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.ticks = 0;
            EntityNikkoriGhost.this.field_70699_by.func_75499_g();
            EntityNikkoriGhost.this.field_70699_by.func_226336_g_();
        }

        public void func_75246_d() {
            if (EntityNikkoriGhost.this.savedTorchPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    EntityNikkoriGhost.this.savedTorchPos = null;
                } else if (!EntityNikkoriGhost.this.field_70699_by.func_226337_n_()) {
                    if (EntityNikkoriGhost.this.isTooFar(EntityNikkoriGhost.this.savedTorchPos)) {
                        EntityNikkoriGhost.this.savedTorchPos = null;
                    } else {
                        EntityNikkoriGhost.this.startMovingTo(EntityNikkoriGhost.this.savedTorchPos);
                    }
                }
            }
        }

        private boolean shouldMoveToFlower() {
            return true;
        }
    }
}

