/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import otsunozi.nikkorihazard.ai.EntityAIReachSettingMeleeAttack;
import otsunozi.nikkorihazard.ai.EntityAISoilManFarming;
import otsunozi.nikkorihazard.ai.EntityAISoilManShareItem;
import otsunozi.nikkorihazard.entity.AbstractNikkoriGolem;
import otsunozi.nikkorihazard.entity.EntityNikkoriVillager;
import otsunozi.nikkorihazard.entity.INikkoriMob;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.init.NCustomBlock;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.item.AbstractItemNikkoriCropSeeds;
import otsunozi.nikkorihazard.util.NElements;
import otsunozi.nikkorihazard.util.NMobDropUtil;

public class EntityNikkoriSoilman
extends AbstractNikkoriGolem
implements INikkoriMob,
INikkoriModMob {
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityNikkoriSoilman.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final Inventory soilmanInventory = new Inventory(8);
    private static final Set<Item> ALLOWED_INVENTORY_ITEMS = ImmutableSet.of((Object)NCustomItem.NIKKORIORANGE, (Object)NCustomItem.NIKKORIORANGE_SEED, (Object)NCustomItem.NIKKORIAPPLE, (Object)NCustomItem.NIKKORIAPPLE_SEED);

    public EntityNikkoriSoilman(EntityType<? extends EntityNikkoriSoilman> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 15;
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIReachSettingMeleeAttack((CreatureEntity)this, 1.25, 1.4f, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new EntityAISoilManFarming(NCustomBlock.NIKKORIPLANTER, this, 1.2, 12));
        this.field_70714_bg.func_75776_a(3, (Goal)new EntityAISoilManShareItem(this, EntityNikkoriVillager.class));
        this.field_70714_bg.func_75776_a(4, (Goal)new EntityAISoilManShareItem(this, PlayerEntity.class));
        this.field_70714_bg.func_75776_a(4, (Goal)new EntityAISoilManShareItem(this, ArmorStandEntity.class));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public void func_70636_d() {
        if (this.func_70090_H()) {
            this.func_70097_a(DamageSource.field_76369_e, 2.0f);
        }
        super.func_70636_d();
    }

    public Inventory getSoilmanInventory() {
        return this.soilmanInventory;
    }

    public boolean isFarmItemInInventory() {
        return this.getSoilmanInventory().func_213902_a((Set)ImmutableSet.of((Object)NCustomItem.NIKKORIAPPLE_SEED, (Object)NCustomItem.NIKKORIORANGE_SEED));
    }

    public boolean hasEnoughItems() {
        int counter = 0;
        for (int i = 0; i < this.soilmanInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.soilmanInventory.func_70301_a(i);
            if (itemstack.func_190926_b() || itemstack.func_190916_E() < 50 || ++counter < 7) continue;
            return false;
        }
        return true;
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_230293_i_(itemstack)) {
            Inventory inventory = this.getSoilmanInventory();
            boolean flag = inventory.func_233541_b_(itemstack);
            if (!flag) {
                return;
            }
            this.func_233630_a_(itemEntity);
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            ItemStack itemstack1 = inventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    public boolean func_230293_i_(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        return ALLOWED_INVENTORY_ITEMS.contains(item) && this.getSoilmanInventory().func_233541_b_(itemstack) && this.canPickUpSeed(item);
    }

    public boolean canPickUpSeed(Item item) {
        if (item instanceof AbstractItemNikkoriCropSeeds) {
            Inventory inventory = this.getSoilmanInventory();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b() || !stack.func_77973_b().equals(item) || stack.func_190916_E() < stack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        NMobDropUtil.dropBaseItem((Entity)this, source, Item.func_150898_a((Block)Blocks.field_150346_d), this.field_70146_Z, recentlyHitIn, looting);
        NMobDropUtil.dropNikkorinium((LivingEntity)this, source, 25, recentlyHitIn, looting);
        List itemList = this.soilmanInventory.func_233543_f_();
        if (itemList != null) {
            for (ItemStack stack : itemList) {
                this.func_199701_a_(stack);
            }
        }
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
        NMobDropUtil.dropEnchantBook((LivingEntity)this, damageSourceIn, 5.0f, this.field_70146_Z.nextInt(21) + 15, attackedRecently, 0, NMobDropUtil.DropBookKindSets.NORMAL_AND_SPECIAL_2);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 2.0f, NCustomItem.EGAOZIUM, 1, attackedRecently);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 40.0f, NCustomItem.STRONG_PLANTFIBER, 1 + this.field_70146_Z.nextInt(2), attackedRecently);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 2.0f, Items.field_151172_bF, 1, attackedRecently);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 2.0f, Items.field_151174_bG, 1, attackedRecently);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76347_k()) {
            return super.func_70097_a(source, damage / 2.0f);
        }
        if (NElements.isIceDamage(source)) {
            return super.func_70097_a(source, damage * 2.0f);
        }
        if (source.func_94541_c()) {
            return super.func_70097_a(source, 100.0f);
        }
        return super.func_70097_a(source, damage);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Inventory", (INBT)this.soilmanInventory.func_70487_g());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.soilmanInventory.func_70486_a(compound.func_150295_c("Inventory", 10));
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return ((double)pos.func_177956_o() >= 64.0 || worldIn.func_175710_j(pos)) && worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityNikkoriSoilman.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityNikkoriSoilman.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }
}

