/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import otsunozi.nikkorihazard.entity.EntityCrazyNikkori;
import otsunozi.nikkorihazard.entity.EntityNikkoriClayman;
import otsunozi.nikkorihazard.entity.EntityNikkoriGanger;
import otsunozi.nikkorihazard.entity.EntityNikkoriGrass;
import otsunozi.nikkorihazard.entity.EntityNikkoriMantis;
import otsunozi.nikkorihazard.entity.EntityNikkoriMiner;
import otsunozi.nikkorihazard.entity.EntityNikkoriPinecone;
import otsunozi.nikkorihazard.entity.EntityNikkoriSoilman;
import otsunozi.nikkorihazard.entity.EntityNikkoriSpider;
import otsunozi.nikkorihazard.entity.EntityNikkoriStoneman;
import otsunozi.nikkorihazard.entity.EntityNikkoriVillager;
import otsunozi.nikkorihazard.entity.EntityNikkoriZombie;
import otsunozi.nikkorihazard.entity.EntityNikoribbies;
import otsunozi.nikkorihazard.entity.EntityWickedNikkori;
import otsunozi.nikkorihazard.entity.EntityWickedZealot;
import otsunozi.nikkorihazard.entity.INikkoriBossMob;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.entity.INikkoriOtherBossMob;
import otsunozi.nikkorihazard.entity.IWickedMob;
import otsunozi.nikkorihazard.entity.passive.EntityGoldenSmile;
import otsunozi.nikkorihazard.entity.passive.merchant.EntityMaskedMerchant;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NElements;
import otsunozi.nikkorihazard.util.WickedMoonProvider;

public class EntitySpawnTrap
extends LivingEntity {
    public int summonCount;
    private int summonTimer;
    private double runningRange;
    private double summonRange;
    private boolean sentTrapEvent;
    private boolean canSpawnWicked;
    private boolean spawned;
    private final NonNullList<ItemStack> handItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> armorItems = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private static final DataParameter<Integer> ALEAT_STATE = EntityDataManager.func_187226_a(EntitySpawnTrap.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SUMMON_TYPE = EntityDataManager.func_187226_a(EntitySpawnTrap.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntitySpawnTrap(EntityType<? extends EntitySpawnTrap> p_i50225_1_, World world) {
        super(p_i50225_1_, world);
        this.field_70138_W = 0.0f;
        this.summonCount = 15;
        this.summonTimer = 60;
        this.runningRange = 6.0;
        this.summonRange = 8.0;
        this.canSpawnWicked = true;
        this.spawned = false;
    }

    public EntitySpawnTrap(World worldIn, double x, double y, double z) {
        this(InitEntity.SPAWN_TRAP, worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntitySpawnTrap(World worldIn, int summonCount) {
        this(InitEntity.SPAWN_TRAP, worldIn);
        this.summonCount = summonCount;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ALEAT_STATE, (Object)0);
        this.func_184212_Q().func_187214_a(SUMMON_TYPE, (Object)0);
    }

    public Iterable<ItemStack> func_184214_aD() {
        return this.handItems;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return this.armorItems;
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public boolean getCanSpawnWicked(ServerWorld world) {
        return this.canSpawnWicked && WickedMoonProvider.isWickedMoon((IServerWorld)world);
    }

    public void setCanSpawnWicked(boolean casSpawnWicked) {
        this.canSpawnWicked = casSpawnWicked;
    }

    public double getRunningRange() {
        return this.runningRange;
    }

    public void setRunningRange(float runningRange) {
        this.runningRange = runningRange;
    }

    public void func_181015_d(BlockPos pos) {
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.5f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected boolean isAllowedSpawn(ServerWorld world, Entity living, boolean isNikkoriHouse) {
        if (world instanceof ServerWorld) {
            if (living instanceof INikkoriBossMob || living instanceof INikkoriOtherBossMob || living instanceof EntityNikkoriPinecone || living instanceof EntityNikoribbies || living instanceof EntityMaskedMerchant || living instanceof SlimeEntity || !NElements.isNonBoss(living)) {
                return false;
            }
            if (living instanceof IWickedMob && !this.getCanSpawnWicked(world)) {
                return false;
            }
            if (living instanceof EntityGoldenSmile && !this.getCanSpawnWicked(world)) {
                return false;
            }
            return !isNikkoriHouse || living instanceof INikkoriModMob;
        }
        return false;
    }

    public void func_70636_d() {
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g(this.getRunningRange()));
        if (this.getAlertState() == 0) {
            if (!list.isEmpty()) {
                for (LivingEntity living : list) {
                    boolean runflag = living instanceof PlayerEntity && !((PlayerEntity)living).func_184812_l_() && !((PlayerEntity)living).func_175149_v() || living instanceof TameableEntity && ((TameableEntity)living).func_70909_n();
                    if (!runflag || !this.func_70685_l((Entity)living)) continue;
                    this.runSpawn(blockpos);
                }
            }
            if (!this.spawned && this.getAlertState() == 0 && !this.field_70170_p.field_72995_K && this.field_70170_p.func_175640_z(blockpos)) {
                this.runSpawn(blockpos);
            }
        } else {
            if (this.summonTimer == 10) {
                this.summonMob(blockpos);
                this.spawned = true;
                this.drawRunMessage();
            } else if (this.summonTimer == 0) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 20; ++i) {
                        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d3 = 10.0;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d0 * 10.0, this.func_226278_cu_() + ((double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - d1 * 10.0), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d2 * 10.0, d0, d1, d2);
                    }
                }
                this.func_241204_bJ_();
            }
            --this.summonTimer;
        }
        super.func_70636_d();
    }

    private void drawRunMessage() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(this.getRunningRange() * 3.0);
        List list1 = this.field_70170_p.func_217357_a(PlayerEntity.class, axisalignedbb);
        if (this.getSummonType() == 0) {
            if (this.field_70170_p.field_72995_K && !list1.isEmpty()) {
                for (PlayerEntity entityplayer : list1) {
                    entityplayer.func_145747_a((ITextComponent)new TranslationTextComponent("nc.msg.spawntrap.info.base"), Util.field_240973_b_);
                    entityplayer.func_145747_a((ITextComponent)new TranslationTextComponent("nc.msg.spawntrap.info.normal"), Util.field_240973_b_);
                }
            }
        } else if (this.getSummonType() == 1) {
            if (this.field_70170_p.field_72995_K && !list1.isEmpty()) {
                for (PlayerEntity entityplayer : list1) {
                    entityplayer.func_145747_a((ITextComponent)new TranslationTextComponent("nc.msg.spawntrap.info.base"), Util.field_240973_b_);
                    entityplayer.func_145747_a((ITextComponent)new TranslationTextComponent("nc.msg.spawntrap.info.nikkorihouse"), Util.field_240973_b_);
                }
            }
        } else if (this.getSummonType() == 2) {
            return;
        }
    }

    private void runSpawn(BlockPos pos) {
        if (!this.spawned && this.getAlertState() == 0) {
            if (!this.sentTrapEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentTrapEvent = true;
            }
            if (this.field_70170_p.func_175623_d(pos.func_177984_a())) {
                this.setAlertState(1);
            } else {
                this.setAlertState(2);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void summonMob(BlockPos blockpos) {
        if (this.getSummonType() != 0 && this.getSummonType() != 1) return;
        List allMobList = this.field_70170_p.func_226691_t_(blockpos).func_242433_b().func_242559_a(EntityClassification.MONSTER);
        ArrayList<MobSpawnInfo.Spawners> spawnList = new ArrayList<MobSpawnInfo.Spawners>();
        if (allMobList == null || allMobList.isEmpty()) return;
        for (MobSpawnInfo.Spawners entry : allMobList) {
            try {
                Entity entity;
                if (!(this.field_70170_p instanceof ServerWorld) || !this.isAllowedSpawn((ServerWorld)this.field_70170_p, entity = entry.field_242588_c.func_200721_a(this.field_70170_p), this.getSummonType() == 1)) continue;
                spawnList.add(entry);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("\u30a2\u30e9\u30fc\u30c8\u30b9\u30dd\u30ca\u30fcmob\u9078\u5225\u30a8\u30e9\u30fc\uff01" + entry.field_242588_c.toString() + "\u3092\u7121\u6761\u4ef6\u306b\u9664\u5916\u3057\u307e\u3059");
            }
        }
        int summonSucCount = 0;
        if (this.field_70170_p.field_72995_K) return;
        for (int i = 0; i < 50; ++i) {
            void var7_21;
            block18: {
                MobSpawnInfo.Spawners spawnlistentry = (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)this.field_70170_p.field_73012_v, spawnList);
                try {
                    void var7_13;
                    LivingEntity livingEntity = (LivingEntity)spawnlistentry.field_242588_c.func_200721_a(this.field_70170_p);
                    if (i <= 0) {
                        EntityNikkoriGanger entityNikkoriGanger = new EntityNikkoriGanger(InitEntity.NIKKORI_GANGER, this.field_70170_p);
                    }
                    if (var7_13 instanceof EntityCrazyNikkori || var7_13 instanceof EntityWickedNikkori) {
                        MonsterEntity monsterEntity = this.field_70146_Z.nextBoolean() ? new EntityNikkoriZombie(InitEntity.NIKKORIZOMBIE, this.field_70170_p) : new EntityNikkoriStoneman((EntityType<? extends EntityNikkoriStoneman>)InitEntity.NIKKORI_STONEMAN, this.field_70170_p);
                        break block18;
                    }
                    if (var7_13 instanceof EntityNikkoriSoilman) {
                        if (this.func_226278_cu_() < 64.0) {
                            if (this.getSummonType() == 1) {
                                EntityNikkoriClayman entityNikkoriClayman = new EntityNikkoriClayman(InitEntity.NIKKORI_CLAYMAN, this.field_70170_p);
                                entityNikkoriClayman.setPowered(true);
                            } else {
                                EntityNikkoriClayman entityNikkoriClayman = new EntityNikkoriClayman(InitEntity.NIKKORI_CLAYMAN, this.field_70170_p);
                            }
                        }
                        break block18;
                    }
                    if (var7_13 instanceof EntityNikkoriSpider) {
                        if (this.getSummonType() == 1 || this.field_70146_Z.nextInt(2) == 0) {
                            EntityNikkoriGanger entityNikkoriGanger = new EntityNikkoriGanger(InitEntity.NIKKORI_GANGER, this.field_70170_p);
                        }
                        break block18;
                    }
                    if (var7_13 instanceof EntityNikkoriVillager || var7_13 instanceof EntityWickedZealot) {
                        if (this.getSummonType() == 1) {
                            EntityNikkoriMiner entityNikkoriMiner = new EntityNikkoriMiner(InitEntity.NIKKORI_MINER, this.field_70170_p);
                        } else {
                            EntityNikkoriGanger entityNikkoriGanger = new EntityNikkoriGanger(InitEntity.NIKKORI_GANGER, this.field_70170_p);
                        }
                        break block18;
                    }
                    if (!(var7_13 instanceof EntityNikkoriGrass) || !(this.func_226278_cu_() < 64.0)) break block18;
                    EntityNikkoriMantis entityNikkoriMantis = new EntityNikkoriMantis(InitEntity.NIKKORI_MANTIS, this.field_70170_p);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            double d0 = (double)blockpos.func_177958_n() + (this.field_70146_Z.nextDouble() - 0.5) * this.summonRange + 0.5;
            double d1 = this.getAlertState() == 1 ? (double)(blockpos.func_177956_o() + this.field_70170_p.field_73012_v.nextInt(5) - 1) : (double)(blockpos.func_177956_o() - this.field_70170_p.field_73012_v.nextInt(10));
            double d2 = (double)blockpos.func_177952_p() + (this.field_70146_Z.nextDouble() - 0.5) * this.summonRange + 0.5;
            var7_21.func_70012_b((double)((float)d0), d1, (double)((float)d2), this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            if (this.canSuumonMob((LivingEntity)var7_21) && this.field_70170_p.func_217376_c((Entity)var7_21)) {
                ((MobEntity)var7_21).func_213386_a((IServerWorld)((ServerWorld)this.field_70170_p), this.field_70170_p.func_175649_E(var7_21.func_233580_cy_()), SpawnReason.REINFORCEMENT, (ILivingEntityData)null, (CompoundNBT)null);
                ((MobEntity)var7_21).func_70656_aK();
                ++summonSucCount;
            }
            if (summonSucCount >= this.summonCount) return;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213293_j(0.0, 0.0, 0.0);
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70177_z = 180.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4 && !this.func_174814_R()) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.SPAWNTRAP_ALERT_01, SoundCategory.BLOCKS, 4.0f, 1.0f, false);
        }
    }

    public boolean canSuumonMob(LivingEntity living) {
        return this.field_70170_p.func_226668_i_((Entity)living) && this.field_70170_p.func_226665_a__((Entity)living, living.func_174813_aQ());
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76371_c || source == DamageSource.field_76368_d || source == DamageSource.field_76369_e) {
            return false;
        }
        this.runSpawn(this.func_233580_cy_());
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("summonCount", this.summonCount);
        compound.func_74768_a("summonType", this.getSummonType());
        compound.func_74757_a("canSpawnWicked", this.canSpawnWicked);
        compound.func_74757_a("spawned", this.spawned);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("summonCount", 99)) {
            this.summonCount = compound.func_74762_e("summonCount");
        }
        if (compound.func_150297_b("summonType", 99)) {
            this.setSummonType(compound.func_74762_e("summonType"));
        }
        if (compound.func_150297_b("canSpawnWicked", 99)) {
            this.canSpawnWicked = compound.func_74767_n("canSpawnWicked");
        }
        if (compound.func_150297_b("spawned", 99)) {
            this.spawned = compound.func_74767_n("spawned");
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void setAlertState(int state) {
        this.field_70180_af.func_187227_b(ALEAT_STATE, (Object)state);
    }

    public int getAlertState() {
        return (Integer)this.field_70180_af.func_187225_a(ALEAT_STATE);
    }

    public int getSummonType() {
        return (Integer)this.field_70180_af.func_187225_a(SUMMON_TYPE);
    }

    public void setSummonType(int summonType) {
        this.field_70180_af.func_187227_b(SUMMON_TYPE, (Object)summonType);
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return (ItemStack)this.handItems.get(slotIn.func_188454_b());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(slotIn.func_188454_b());
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(stack);
                this.handItems.set(slotIn.func_188454_b(), (Object)stack);
                break;
            }
            case ARMOR: {
                this.func_184606_a_(stack);
                this.armorItems.set(slotIn.func_188454_b(), (Object)stack);
            }
        }
    }
}

