/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import otsunozi.nikkorihazard.ai.EntityAIReachSettingMeleeAttack;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.entity.IWickedMob;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.entity.item.EntityPoisonFang;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.util.NMobDropUtil;
import otsunozi.nikkorihazard.util.WickedMoonProvider;

public class EntityWickedSkeleton
extends MonsterEntity
implements IWickedMob,
INikkoriModMob {
    private int attackTimer;
    private int fireTimer;
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityWickedSkeleton.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Item[] randomDrops = new Item[]{Items.field_151042_j, Items.field_151166_bC, Items.field_151042_j, Items.field_151043_k};

    public EntityWickedSkeleton(EntityType<? extends EntityWickedSkeleton> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 30;
        this.attackTimer = 60;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ARMS_RAISED, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIReachSettingMeleeAttack((CreatureEntity)this, 1.0, 2.0f, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_WICKED;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.2f;
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.17).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 15.0);
    }

    public void func_70636_d() {
        if (this.attackTimer > 0 && this.func_70638_az() != null && !this.field_70729_aU) {
            --this.attackTimer;
            this.fireTimer = 0;
            if (this.attackTimer == 0 && !this.field_70729_aU) {
                if (this.func_70638_az() != null) {
                    this.fireTimer = 15;
                } else {
                    this.attackTimer = this.field_70146_Z.nextInt(30) + 40;
                }
            }
        } else if (this.attackTimer <= 0 && this.func_110143_aJ() > 0.0f) {
            if (!this.field_70170_p.field_72995_K && this.fireTimer == 15) {
                this.setArmsRaised(true);
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191248_br, SoundCategory.HOSTILE, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.9f);
            } else if (this.fireTimer == 1 && !this.func_180799_ab() && !this.func_70027_ad()) {
                this.castSpell();
            }
            --this.fireTimer;
            if (this.fireTimer <= 0) {
                this.attackTimer = 60 + this.field_70146_Z.nextInt(70);
                this.setArmsRaised(false);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
            this.attackTimer = this.field_70146_Z.nextInt(60) + 30;
            this.setArmsRaised(false);
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            float f = this.func_70013_c();
            BlockPos blockpos = new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_());
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_226660_f_(blockpos)) {
                this.func_70656_aK();
                this.field_70170_p.func_184148_a((PlayerEntity)null, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), SoundEvents.field_187942_hp, SoundCategory.NEUTRAL, 0.6f, 1.0f);
                this.func_241204_bJ_();
            }
        }
        super.func_70636_d();
    }

    protected void castSpell() {
        block5: {
            LivingEntity entitylivingbase = this.func_70638_az();
            if (entitylivingbase == null) break block5;
            double d0 = Math.min(entitylivingbase.func_226278_cu_(), this.func_226278_cu_());
            double d1 = Math.max(entitylivingbase.func_226278_cu_(), this.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.func_226281_cx_() - this.func_226281_cx_()), (double)(entitylivingbase.func_226277_ct_() - this.func_226277_ct_()));
            if (this.func_70068_e((Entity)entitylivingbase) < 12.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f1) * 1.9, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f1) * 1.9, d0, d1, f1, 0);
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 3.2, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 3.2, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 18; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = 1 * l;
                    this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                }
            }
        }
    }

    private void spawnFangs(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
        BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)this.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
        if (flag) {
            EntityPoisonFang trap = new EntityPoisonFang(this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)this);
            this.field_70170_p.func_217376_c((Entity)trap);
        }
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        NMobDropUtil.dropBaseRandomItems((LivingEntity)this, source, randomDrops, 3, this.field_70146_Z, recentlyHitIn, looting);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
        NMobDropUtil.dropEnchantBook((LivingEntity)this, damageSourceIn, 8.0f, 30, attackedRecently, 1, NMobDropUtil.DropBookKindSets.WICKED_HARD);
        NMobDropUtil.dropCriticalMedal((LivingEntity)this, damageSourceIn, 16.0f, attackedRecently, NMobDropUtil.DropMedalKindSets.STRONG_MOB);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 8.0f, NCustomItem.DARK_NIKKORINIUM, 1, attackedRecently);
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return WickedMoonProvider.isWickedMoon(worldIn) && worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityWickedSkeleton.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityWickedSkeleton.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_190039_hd;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 0.7f);
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }
}

