/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.entity.IWickedMob;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.util.NElements;
import otsunozi.nikkorihazard.util.NMobDropUtil;
import otsunozi.nikkorihazard.util.WickedMoonProvider;

public class EntityWickedmoonBear
extends MonsterEntity
implements IWickedMob,
INikkoriModMob {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityWickedmoonBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;
    private static final Item[] randomDrops = new Item[]{Items.field_196087_aX, Items.field_151074_bl, Items.field_151166_bC, Items.field_151043_k, Items.field_151074_bl};

    public EntityWickedmoonBear(EntityType<? extends EntityWickedmoonBear> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 30;
        this.field_70138_W = 2.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected float func_189749_co() {
        return 0.99f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AIBearMeleeAttack());
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_WICKED;
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.28).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233824_g_, 2.5).func_233815_a_(Attributes.field_233823_f_, 15.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if (NElements.isNonBoss(entityIn)) {
            f1 += 5.0f;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                if (NElements.isNonBoss(entityIn)) {
                    entityIn.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * f1 * 0.5f), this.field_70146_Z.nextDouble() * 0.2 + 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * f1 * 0.5f));
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, 1.0, 0.7));
                } else {
                    ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                }
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.clientSideStandAnimation > 0.0f) {
            float f = this.clientSideStandAnimation / 6.0f;
            float f1 = 1.0f + f;
            return super.func_213305_a(poseIn).func_220312_a(1.0f, f1);
        }
        return super.func_213305_a(poseIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideStandAnimation != this.clientSideStandAnimation0) {
                this.func_213323_x_();
            }
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            float f = this.func_70013_c();
            BlockPos blockpos = new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_());
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_226660_f_(blockpos)) {
                this.func_70656_aK();
                this.field_70170_p.func_184148_a((PlayerEntity)null, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), SoundEvents.field_187942_hp, SoundCategory.NEUTRAL, 0.6f, 1.0f);
                this.func_241204_bJ_();
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S() && this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            boolean flag = false;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (!(block instanceof LeavesBlock)) continue;
                flag = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || flag;
            }
            if (!flag && this.field_70122_E) {
                this.func_70664_aZ();
            }
        }
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        NMobDropUtil.dropBaseRandomItems((LivingEntity)this, source, randomDrops, 5, this.field_70146_Z, recentlyHitIn, looting);
        NMobDropUtil.dropBaseItem((Entity)this, source, Items.field_196087_aX, this.field_70146_Z, recentlyHitIn, looting);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
        NMobDropUtil.dropEnchantBook((LivingEntity)this, damageSourceIn, 10.0f, 30, attackedRecently, 0, NMobDropUtil.DropBookKindSets.WICKED_HARD);
        NMobDropUtil.dropCriticalMedal((LivingEntity)this, damageSourceIn, 20.0f, attackedRecently, NMobDropUtil.DropMedalKindSets.STRONG_MOB);
        NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 15.0f, NCustomItem.DARK_NIKKORINIUM, 1, attackedRecently);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (NElements.isIceDamage(source)) {
            return super.func_70097_a(source, damage * 2.0f);
        }
        return super.func_70097_a(source, damage);
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return WickedMoonProvider.isWickedMoon(worldIn) && worldIn.func_175710_j(pos) && worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityWickedmoonBear.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityWickedmoonBear.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.2f, 0.5f);
            this.warningSoundTicks = 40;
        }
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return MathHelper.func_219799_g((float)p_189795_1_, (float)this.clientSideStandAnimation0, (float)this.clientSideStandAnimation) / 6.0f;
    }

    class AIBearMeleeAttack
    extends MeleeAttackGoal {
        public AIBearMeleeAttack() {
            super((CreatureEntity)EntityWickedmoonBear.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
                EntityWickedmoonBear.this.setStanding(false);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    EntityWickedmoonBear.this.setStanding(false);
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    EntityWickedmoonBear.this.setStanding(true);
                    EntityWickedmoonBear.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
                EntityWickedmoonBear.this.setStanding(false);
            }
        }

        public void func_75251_c() {
            EntityWickedmoonBear.this.setStanding(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 7.0f + attackTarget.func_213311_cf();
        }
    }
}

