/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.boss;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NElements;

public class EntityBombRock
extends LivingEntity
implements INikkoriModMob {
    private final NonNullList<ItemStack> handItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> armorItems = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int fuseTimer = this.field_70146_Z.nextInt(100) + 100;
    private int plosionTimer = 50;
    private static final DataParameter<Boolean> IGNITION = EntityDataManager.func_187226_a(EntityBombRock.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> PLOSION_STATE = EntityDataManager.func_187226_a(EntityBombRock.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityBombRock(EntityType<? extends EntityBombRock> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityBombRock(World worldIn, int fuseTimer) {
        this(InitEntity.BOMB_ROCK, worldIn);
        this.fuseTimer = fuseTimer;
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLOSION_STATE, (Object)0);
        this.field_70180_af.func_187214_a(IGNITION, (Object)false);
    }

    public void func_70636_d() {
        if (!this.getIgnition()) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.fuseTimer > 0) {
                    --this.fuseTimer;
                } else if (this.fuseTimer <= 0) {
                    this.setIgnition(true);
                }
            }
        } else {
            --this.plosionTimer;
            if (this.plosionTimer == 49) {
                NCMotion.setMotionY((Entity)this, 0.1f);
                this.setPlosionState(1);
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            } else if (this.plosionTimer == 20) {
                this.setPlosionState(2);
            } else if (this.plosionTimer == 5) {
                this.setPlosionState(3);
            }
            if (this.plosionTimer <= 0) {
                this.func_241204_bJ_();
                if (!this.field_70170_p.field_72995_K) {
                    this.explode();
                }
            } else {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    private void explode() {
        this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.0f, false, Explosion.Mode.NONE);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        NCMotion.setMotionX((Entity)this, x *= (double)velocity);
        NCMotion.setMotionY((Entity)this, y *= (double)velocity);
        NCMotion.setMotionZ((Entity)this, z *= (double)velocity);
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public int randomThrow() {
        if (this.field_70146_Z.nextInt(2) == 0) {
            return -1;
        }
        return 1;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (NElements.isIceDamage(source) && !this.getIgnition()) {
            return super.func_70097_a(source, damage);
        }
        if (NElements.isFireDamage(source) && !this.getIgnition()) {
            this.setIgnition(true);
        } else if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, damage);
        }
        return false;
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return effectInstanceIn.func_188419_a() == Effects.field_188423_x ? super.func_195064_c(effectInstanceIn) : false;
    }

    public int getPlosionState() {
        return (Integer)this.field_70180_af.func_187225_a(PLOSION_STATE);
    }

    public void setPlosionState(int state) {
        this.field_70180_af.func_187227_b(PLOSION_STATE, (Object)state);
    }

    public boolean getIgnition() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITION);
    }

    public void setIgnition(boolean state) {
        this.field_70180_af.func_187227_b(IGNITION, (Object)state);
    }

    public void func_181015_d(BlockPos pos) {
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    public Iterable<ItemStack> func_184214_aD() {
        return this.handItems;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return this.armorItems;
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }
}

