/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.boss;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.entity.INikkoriBossMob;
import otsunozi.nikkorihazard.entity.INikkoriOtherBossMob;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NCustomDamageSource;
import otsunozi.nikkorihazard.util.NElements;

public class EntityIceTornado
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private final int maxLifeTicks = 220;
    private int lifeTicks = 220;
    private int damage = 4;
    private LivingEntity caster;
    private UUID casterUuid;
    public int field_200606_g;
    private float hosei;
    private static final DataParameter<Boolean> ATTACK_START = EntityDataManager.func_187226_a(EntityIceTornado.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityIceTornado(EntityType<EntityIceTornado> magicTornado, World p_i50170_2_) {
        super(magicTornado, p_i50170_2_);
    }

    public EntityIceTornado(World worldIn, double x, double y, double z, float yaw, int warmupDelayTicks, LivingEntity casterIn, int type) {
        this(InitEntity.ICE_TORNADO, worldIn);
        this.warmupDelayTicks = warmupDelayTicks;
        this.setCaster(casterIn);
        this.field_200606_g = type;
        this.field_70177_z = yaw * 57.295776f;
        this.func_70107_b(x, y, z);
    }

    public EntityIceTornado(World worldIn, double x, double y, double z, float yaw, int warmupDelayTicks, LivingEntity casterIn, int type, int hosei, int damage) {
        this(worldIn, x, y, z, yaw, warmupDelayTicks, casterIn, type);
        this.damage = damage;
        this.hosei = 0.7853982f * (float)hosei;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ATTACK_START, (Object)false);
    }

    public void func_181015_d(BlockPos pos) {
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.warmupDelayTicks = compound.func_74762_e("Warmup");
        this.damage = compound.func_74762_e("Damage");
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
        this.lifeTicks = compound.func_74762_e("LifeTicks");
        this.field_200606_g = compound.func_74762_e("Type");
        this.hosei = compound.func_74760_g("Hosei");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Warmup", this.warmupDelayTicks);
        compound.func_74768_a("Damage", this.damage);
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
        compound.func_74768_a("Type", this.field_200606_g);
        compound.func_74768_a("MaxLifeTicks", this.maxLifeTicks);
        compound.func_74768_a("LifeTicks", this.lifeTicks);
        compound.func_74776_a("Hosei", this.hosei);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.setAttacking(true);
        if (this.field_70170_p.field_72995_K) {
            if (this.getAttackState()) {
                --this.lifeTicks;
                if (this.lifeTicks > 10) {
                    for (int i = 0; i < 2; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 1.2, this.func_226278_cu_() + 0.4, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 1.2, (this.field_70146_Z.nextDouble() - 0.5) * 1.5, this.field_70146_Z.nextDouble() + 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 1.5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.field_200606_g == 0) {
                NCMotion.setMotionX(this, MathHelper.func_76126_a((float)(this.hosei + (float)(this.maxLifeTicks - this.lifeTicks) * (float)Math.PI / 80.0f)));
                NCMotion.setMotionZ(this, MathHelper.func_76126_a((float)(this.hosei + 1.5707964f + (float)(this.maxLifeTicks - this.lifeTicks) * (float)Math.PI / 80.0f)));
            } else if (this.field_200606_g == 1) {
                NCMotion.setMotionX(this, MathHelper.func_76126_a((float)(this.hosei + (float)(this.maxLifeTicks - this.lifeTicks) * (float)(-Math.PI) / 80.0f)));
                NCMotion.setMotionZ(this, MathHelper.func_76126_a((float)(this.hosei + 1.5707964f + (float)(this.maxLifeTicks - this.lifeTicks) * (float)(-Math.PI) / 80.0f)));
            } else if (this.field_200606_g == 2) {
                NCMotion.setMotionX(this, (double)MathHelper.func_76126_a((float)(this.hosei + (float)(this.maxLifeTicks - this.lifeTicks) * (float)Math.PI / 80.0f)) * 2.5);
                NCMotion.setMotionZ(this, (double)MathHelper.func_76126_a((float)(this.hosei + 1.5707964f + (float)(this.maxLifeTicks - this.lifeTicks) * (float)Math.PI / 80.0f)) * 2.5);
            } else if (this.field_200606_g == 3) {
                NCMotion.setMotionX(this, (double)MathHelper.func_76126_a((float)(this.hosei + (float)(this.maxLifeTicks - this.lifeTicks) * (float)(-Math.PI) / 80.0f)) * 2.5);
                NCMotion.setMotionZ(this, (double)MathHelper.func_76126_a((float)(this.hosei + 1.5707964f + (float)(this.maxLifeTicks - this.lifeTicks) * (float)(-Math.PI) / 80.0f)) * 2.5);
            } else if (this.field_200606_g == 4) {
                NCMotion.setMotionX(this, (double)MathHelper.func_76126_a((float)(this.hosei + (float)this.lifeTicks * (float)Math.PI / 90.0f)) * 4.0);
                NCMotion.setMotionZ(this, (double)MathHelper.func_76126_a((float)(this.hosei + 1.5707964f + (float)this.lifeTicks * (float)Math.PI / 90.0f)) * 4.0);
            } else if (this.field_200606_g == 5) {
                NCMotion.setMotionX(this, (double)MathHelper.func_76126_a((float)(this.hosei + (float)this.lifeTicks * (float)(-Math.PI) / 80.0f)) * 4.0);
                NCMotion.setMotionZ(this, (double)MathHelper.func_76126_a((float)(this.hosei + 1.5707964f + (float)this.lifeTicks * (float)(-Math.PI) / 80.0f)) * 4.0);
            }
            this.func_70107_b(this.func_226277_ct_() + NCMotion.getMotionX(this) * (double)0.12f, this.func_226278_cu_(), this.func_226281_cx_() + NCMotion.getMotionZ(this) * (double)0.12f);
            if (this.warmupDelayTicks <= -5 && this.warmupDelayTicks >= -this.maxLifeTicks) {
                List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.95, 1.0, 0.95));
                for (LivingEntity entitylivingbase : list) {
                    this.damage(entitylivingbase);
                }
            }
            if (this.lifeTicks > 0 && this.lifeTicks % 30 == 0) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORI_BRIZZARD_MEGA_BLIZZARD, SoundCategory.BLOCKS, 1.0f, 0.7f);
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
    }

    private void damage(LivingEntity target) {
        LivingEntity entitylivingbase = this.getCaster();
        if (target.func_70089_S() && !target.func_190530_aW()) {
            boolean damageFlag;
            boolean bl = damageFlag = !(target instanceof INikkoriBossMob) && !(target instanceof INikkoriOtherBossMob);
            if (entitylivingbase == null) {
                if (damageFlag) {
                    target.func_70097_a(NCustomDamageSource.causeIceTornadoDamage((Entity)this.caster, this), (float)this.damage);
                }
                if (NElements.isNonBoss((Entity)target)) {
                    NCMotion.setMotionY((Entity)target, this.field_70146_Z.nextDouble() + 0.3);
                    NCMotion.setMotionX((Entity)target, (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                    NCMotion.setMotionZ((Entity)target, (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            } else {
                if (entitylivingbase != null && entitylivingbase.func_184191_r((Entity)target)) {
                    return;
                }
                if (damageFlag) {
                    target.func_70097_a(NCustomDamageSource.causeIceTornadoDamage((Entity)this.caster, this), (float)this.damage);
                }
                if (NElements.isNonBoss((Entity)target)) {
                    NCMotion.setMotionY((Entity)target, this.field_70146_Z.nextDouble() + 0.3);
                    NCMotion.setMotionX((Entity)target, (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                    NCMotion.setMotionZ((Entity)target, (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.setAttacking(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float p_190550_1_) {
        if (!this.getAttackState()) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_190550_1_) / 20.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean getAttackState() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACK_START);
    }

    public void setAttacking(boolean state) {
        this.field_70180_af.func_187227_b(ATTACK_START, (Object)state);
    }
}

