/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.boss;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import otsunozi.nikkorihazard.entity.EntityCrazyNikkori;
import otsunozi.nikkorihazard.entity.EntityNikkoryWoods;
import otsunozi.nikkorihazard.entity.INikkoriBossMob;
import otsunozi.nikkorihazard.entity.INikkoriMob;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.entity.boss.EntityTargetOfHammer;
import otsunozi.nikkorihazard.entity.item.bullet.EntityWoodBoomerang;
import otsunozi.nikkorihazard.entity.item.bullet.EntityWoodMissile;
import otsunozi.nikkorihazard.entity.passive.EntityBossDropChest;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.BlockBreakCheck;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NElements;
import otsunozi.nikkorihazard.util.NTextUtil;

public class EntityNikkoriWoodHammer
extends MonsterEntity
implements IRangedAttackMob,
INikkoriMob,
INikkoriBossMob {
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS);
    int challengeCount = 0;
    boolean challengeFlag = false;
    private int attackIdleTimer;
    private int attackingTimer;
    private int wakeupTimer;
    private int boomerangCount;
    private boolean startWakeup;
    private boolean ikari;
    private int attackcategory;
    private int shoothand;
    private int spAttackFlag;
    private LivingEntity targetedEntity;
    private static final DataParameter<Boolean> FIRE_POWERED = EntityDataManager.func_187226_a(EntityNikkoriWoodHammer.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ARM_STATE = EntityDataManager.func_187226_a(EntityNikkoriWoodHammer.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityNikkoriWoodHammer.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> HEAD_STATE = EntityDataManager.func_187226_a(EntityNikkoriWoodHammer.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BODY_STATE = EntityDataManager.func_187226_a(EntityNikkoriWoodHammer.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityNikkoriWoodHammer.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityNikkoriWoodHammer.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityNikkoriWoodHammer(EntityType<? extends EntityNikkoriWoodHammer> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 50;
        this.attackIdleTimer = this.field_70146_Z.nextInt(60) + 10;
        this.ikari = false;
        this.wakeupTimer = 80;
        this.bossInfo.func_186758_d(false);
        this.startWakeup = false;
    }

    protected void func_184651_r() {
    }

    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_NIKKORIBOSS;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(FIRE_POWERED, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)true);
        this.field_70180_af.func_187214_a(ARM_STATE, (Object)0);
        this.field_70180_af.func_187214_a(BODY_STATE, (Object)0);
        this.field_70180_af.func_187214_a(HEAD_STATE, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233821_d_, 0.002).func_233815_a_(Attributes.field_233826_i_, 3.0).func_233815_a_(Attributes.field_233819_b_, 45.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 3.0f;
    }

    public boolean isEmergency() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public void func_70636_d() {
        if (this.func_70638_az() != null) {
            this.setTargetedEntity(this.func_70638_az().func_145782_y());
        }
        if (this.getSleepingState()) {
            BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            int arroundWoodsCount = this.field_70170_p.func_217357_a(EntityNikkoryWoods.class, new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g(15.0)).size();
            if (!this.startWakeup) {
                this.wakeupTimer = arroundWoodsCount <= 0 ? --this.wakeupTimer : 80;
                if (this.wakeupTimer <= 40) {
                    this.startWakeup = true;
                }
            } else if (this.startWakeup) {
                if (this.wakeupTimer == 40) {
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIWOODHAMMER_LIVING, SoundCategory.HOSTILE, 4.0f, 1.0f);
                    this.setHeadState(1);
                    this.setBodyState(1);
                    this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
                    this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
                    this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 30.0f));
                }
                if (this.wakeupTimer == 0) {
                    this.bossInfo.func_186758_d(true);
                    this.setHeadState(0);
                    this.setBodyState(0);
                    this.field_70180_af.func_187227_b(SLEEPING, (Object)false);
                    this.func_70656_aK();
                }
                --this.wakeupTimer;
            }
        } else {
            if (this.attackIdleTimer > 0 && this.func_70638_az() != null && !this.field_70729_aU) {
                --this.attackIdleTimer;
                if (this.attackIdleTimer == 0 && !this.field_70729_aU) {
                    LivingEntity target = this.func_70638_az();
                    BlockPos targetPos = target.func_233580_cy_();
                    double targetDist = this.func_70032_d((Entity)target);
                    double distX = target.func_226277_ct_() - this.func_226277_ct_();
                    double distZ = target.func_226281_cx_() - this.func_226281_cx_();
                    double targetDistXZ = Math.sqrt(distX * distX + distZ * distZ);
                    if (this.isEmergency()) {
                        if (this.getPowered()) {
                            if (!this.getFirePowered()) {
                                this.attackcategory = 4;
                            } else if (!this.ikari) {
                                this.ikari = true;
                                if (targetDistXZ >= 5.0 && this.field_70170_p.func_175710_j(targetPos)) {
                                    this.attackcategory = this.field_70146_Z.nextInt(3) + 2;
                                    if (this.attackcategory == 4) {
                                        this.attackcategory = 2;
                                    }
                                } else {
                                    this.attackcategory = 3;
                                }
                            } else if (targetDistXZ >= 5.0 && this.field_70170_p.func_175710_j(targetPos)) {
                                this.attackcategory = this.field_70146_Z.nextInt(4);
                                if (this.attackcategory == 4) {
                                    this.attackcategory = 2;
                                }
                            } else {
                                this.attackcategory = this.field_70146_Z.nextInt(3);
                                if (this.attackcategory == 2) {
                                    this.attackcategory = 3;
                                }
                            }
                        } else if (!this.ikari) {
                            this.ikari = true;
                            if (targetDistXZ >= 5.0 && this.field_70170_p.func_175710_j(targetPos)) {
                                this.attackcategory = this.field_70146_Z.nextInt(3) + 2;
                                if (this.attackcategory == 4) {
                                    this.attackcategory = 2;
                                }
                            } else {
                                this.attackcategory = 3;
                            }
                        } else if (this.spAttackFlag <= 0) {
                            if (targetDistXZ >= 5.0 && this.field_70170_p.func_175710_j(targetPos)) {
                                this.attackcategory = this.field_70146_Z.nextInt(4);
                                if (this.attackcategory == 4) {
                                    this.attackcategory = 2;
                                }
                            } else {
                                this.attackcategory = this.field_70146_Z.nextInt(3);
                                if (this.attackcategory == 2) {
                                    this.attackcategory = 3;
                                }
                            }
                        } else if (targetDist <= 5.0) {
                            this.attackcategory = this.field_70146_Z.nextInt(3);
                            if (this.attackcategory == 2) {
                                this.attackcategory = 0;
                            }
                        } else {
                            this.attackcategory = this.field_70146_Z.nextInt(3);
                            if (this.attackcategory == 2) {
                                this.attackcategory = 1;
                            }
                        }
                    } else if (this.getPowered()) {
                        if (!this.getFirePowered()) {
                            this.attackcategory = 4;
                        } else if (targetDist <= 5.0) {
                            this.attackcategory = this.field_70146_Z.nextInt(3);
                            if (this.attackcategory == 2) {
                                this.attackcategory = 0;
                            }
                        } else {
                            this.attackcategory = this.field_70146_Z.nextInt(3);
                            if (this.attackcategory == 2) {
                                this.attackcategory = 1;
                            }
                        }
                    } else if (targetDist <= 5.0) {
                        this.attackcategory = this.field_70146_Z.nextInt(3);
                        if (this.attackcategory == 2) {
                            this.attackcategory = 0;
                        }
                    } else {
                        this.attackcategory = this.field_70146_Z.nextInt(3);
                        if (this.attackcategory == 2) {
                            this.attackcategory = 1;
                        }
                    }
                    if (this.spAttackFlag > 0) {
                        --this.spAttackFlag;
                    }
                    switch (this.attackcategory) {
                        case 0: {
                            this.attackingTimer = this.field_70146_Z.nextInt(40) + 75;
                            break;
                        }
                        case 1: {
                            this.attackingTimer = 80;
                            this.boomerangCount = this.field_70146_Z.nextInt(3) + 2;
                            break;
                        }
                        case 2: {
                            this.attackingTimer = 20;
                            this.spAttackFlag = 2;
                            break;
                        }
                        case 3: {
                            this.attackingTimer = 50;
                            this.spAttackFlag = 2;
                            break;
                        }
                        case 4: {
                            this.attackingTimer = 80;
                        }
                    }
                }
            } else if (this.attackIdleTimer == 0 && this.attackcategory == 0 && !this.field_70729_aU) {
                if (this.attackingTimer == 75) {
                    this.setArmState(1);
                } else if (this.attackingTimer == 70) {
                    this.setArmState(2);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORICALAMARO_CHARGE, SoundCategory.PLAYERS, 2.0f, 1.3f);
                } else if (this.attackingTimer == 45) {
                    this.setArmState(3);
                    this.setHeadState(2);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORI_BRIZZARD_MEGA_BLIZZARD, SoundCategory.BLOCKS, 2.0f, 0.3f);
                } else if (this.attackingTimer <= 42) {
                    List list;
                    if (!this.field_70170_p.field_72995_K) {
                        this.destroyBlocksInAABB(this.func_174813_aQ().func_72314_b(2.8, 0.0, 2.8));
                        if (this.getFirePowered() && this.attackingTimer <= 42 && this.attackingTimer % 12 == 0) {
                            this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 4.0f, true, Explosion.Mode.NONE);
                        }
                    }
                    if (!(list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(2.9, 0.0, 2.9))).isEmpty()) {
                        for (LivingEntity entityIn : list) {
                            if (!entityIn.func_70089_S() || entityIn == this || this.field_70170_p.field_72995_K) continue;
                            entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 7.0f);
                            int i = 6;
                            if (NElements.isNonBoss((Entity)entityIn)) {
                                i = 4;
                            }
                            entityIn.func_213293_j((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), this.field_70146_Z.nextDouble() * 0.3 + 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                            entityIn.field_70160_al = true;
                        }
                    }
                }
                --this.attackingTimer;
                if (this.attackingTimer == 0) {
                    this.setArmState(0);
                    this.setHeadState(0);
                    this.attackIdleTimer = this.getFirePowered() ? this.field_70146_Z.nextInt(30) + 10 : this.field_70146_Z.nextInt(30) + 60;
                }
            } else if (this.attackIdleTimer == 0 && this.attackcategory == 1 && !this.field_70729_aU) {
                if (this.attackingTimer == 80) {
                    this.setHeadState(1);
                } else if (this.attackingTimer <= 70 && this.attackingTimer % 7 == 0) {
                    if (this.boomerangCount > 0) {
                        LivingEntity entitylivingbase = this.func_70638_az();
                        if (entitylivingbase != null && !this.field_70170_p.field_72995_K) {
                            double d0 = this.func_70068_e((Entity)entitylivingbase);
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                            double d1 = entitylivingbase.func_226277_ct_() - this.func_226277_ct_();
                            double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.func_213302_cg() / 2.0f) - (this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f)) - 1.0;
                            double d3 = entitylivingbase.func_226281_cx_() - this.func_226281_cx_();
                            EntityWoodBoomerang boomerang = new EntityWoodBoomerang(this.field_70170_p, (LivingEntity)this, d1 + this.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)f, 80, 5);
                            boomerang.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_() + 5.0, this.func_226281_cx_(), this.func_184229_a(Rotation.NONE), 0.0f);
                            if (this.getFirePowered()) {
                                boomerang.setPowered(true);
                            }
                            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187606_E, SoundCategory.PLAYERS, 4.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 3.5f);
                            this.field_70170_p.func_217376_c((Entity)boomerang);
                        }
                        --this.boomerangCount;
                    } else {
                        this.attackingTimer = 1;
                    }
                }
                --this.attackingTimer;
                if (this.attackingTimer == 0) {
                    this.setArmState(0);
                    this.setHeadState(0);
                    this.attackIdleTimer = this.field_70146_Z.nextInt(10) + 10;
                }
            } else if (this.attackIdleTimer == 0 && this.attackcategory == 2 && !this.field_70729_aU) {
                if (this.attackingTimer == 20) {
                    this.setHeadState(1);
                    this.setArmState(7);
                } else if (this.attackingTimer == 10) {
                    this.hammerSpell(0);
                }
                --this.attackingTimer;
                if (this.attackingTimer == 0) {
                    this.setArmState(0);
                    this.setHeadState(0);
                    this.attackIdleTimer = this.field_70146_Z.nextInt(40) + 30;
                }
            } else if (this.attackIdleTimer == 0 && this.attackcategory == 3 && !this.field_70729_aU) {
                LivingEntity entitylivingbase;
                if (this.attackingTimer == 50) {
                    this.setHeadState(1);
                    this.setArmState(4);
                    this.shoothand = 2;
                } else if (this.attackingTimer == 40) {
                    this.setArmState(5);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIQUEENWASP_CHARGE, SoundCategory.HOSTILE, 3.0f, 1.5f);
                }
                if (this.getFirePowered()) {
                    LivingEntity entitylivingbase2;
                    if (this.attackingTimer <= 30 && this.attackingTimer % 5 == 0 && (entitylivingbase2 = this.func_70638_az()) != null && !this.field_70170_p.field_72995_K) {
                        float f1 = MathHelper.func_76134_b((float)((this.field_70761_aq + (float)(180 * this.shoothand)) * ((float)Math.PI / 180)));
                        float f2 = MathHelper.func_76126_a((float)((this.field_70761_aq + (float)(180 * this.shoothand)) * ((float)Math.PI / 180)));
                        this.shoothand = this.shoothand == 1 ? 2 : 1;
                        double shootX = this.func_226277_ct_() + (double)f1 * (double)1.3f;
                        double shootZ = this.func_226281_cx_() + (double)f2 * (double)1.3f;
                        double d0 = this.func_70068_e((Entity)entitylivingbase2);
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        double d1 = (entitylivingbase2.func_226277_ct_() - this.func_226277_ct_()) * (double)0.7f;
                        double d2 = (entitylivingbase2.func_174813_aQ().field_72338_b + (double)(entitylivingbase2.func_213302_cg() / 2.0f) - (this.func_226278_cu_() - 1.8 + (double)(this.func_213302_cg() / 2.0f))) * (double)0.7f;
                        double d3 = (entitylivingbase2.func_226281_cx_() - this.func_226281_cx_()) * (double)0.7f;
                        EntityWoodMissile missile = new EntityWoodMissile(this.field_70170_p, (LivingEntity)this, d1 + this.func_70681_au().nextGaussian() * (double)0.2f * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)0.2f * (double)f, 60, 10);
                        missile.func_70080_a(shootX, this.func_226278_cu_() + 1.4, shootZ, this.field_70177_z, this.field_70125_A);
                        missile.field_70126_B = this.field_70177_z;
                        missile.field_70127_C = this.field_70125_A;
                        if (this.getFirePowered()) {
                            missile.setPowered(true);
                        }
                        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORICALAMARO_SPLASH, SoundCategory.HOSTILE, 2.0f, 0.7f);
                        this.field_70170_p.func_217376_c((Entity)missile);
                    }
                } else if (!(this.attackingTimer != 20 && this.attackingTimer != 10 || (entitylivingbase = this.func_70638_az()) == null || this.field_70170_p.field_72995_K)) {
                    float f1 = MathHelper.func_76134_b((float)((this.field_70761_aq + (float)(180 * this.shoothand)) * ((float)Math.PI / 180)));
                    float f2 = MathHelper.func_76126_a((float)((this.field_70761_aq + (float)(180 * this.shoothand)) * ((float)Math.PI / 180)));
                    this.shoothand = this.shoothand == 1 ? 2 : 1;
                    double shootX = this.func_226277_ct_() + (double)f1 * (double)1.3f;
                    double shootZ = this.func_226281_cx_() + (double)f2 * (double)1.3f;
                    double d0 = this.func_70068_e((Entity)entitylivingbase);
                    float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                    double d1 = (entitylivingbase.func_226277_ct_() - this.func_226277_ct_()) * (double)0.7f;
                    double d2 = (entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.func_213302_cg() / 2.0f) - (this.func_226278_cu_() - 1.8 + (double)(this.func_213302_cg() / 2.0f))) * (double)0.7f;
                    double d3 = (entitylivingbase.func_226281_cx_() - this.func_226281_cx_()) * (double)0.7f;
                    EntityWoodMissile missile = new EntityWoodMissile(this.field_70170_p, (LivingEntity)this, d1 + this.func_70681_au().nextGaussian() * (double)0.2f * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)0.2f * (double)f, 60, 10);
                    missile.func_70080_a(shootX, this.func_226278_cu_() + 1.4, shootZ, this.field_70177_z, this.field_70125_A);
                    missile.field_70126_B = this.field_70177_z;
                    missile.field_70127_C = this.field_70125_A;
                    if (this.getFirePowered()) {
                        missile.setPowered(true);
                    }
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORICALAMARO_SPLASH, SoundCategory.HOSTILE, 2.0f, 0.7f);
                    this.field_70170_p.func_217376_c((Entity)missile);
                }
                if (this.attackingTimer == 20) {
                    this.setArmState(6);
                } else if (this.attackingTimer == 10) {
                    this.setArmState(7);
                }
                if (this.func_70638_az() != null) {
                    this.func_70661_as().func_75499_g();
                    this.func_70605_aq().func_188488_a(-0.5f, 0.5f);
                    this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 30.0f);
                }
                --this.attackingTimer;
                if (this.attackingTimer == 0) {
                    this.setArmState(0);
                    this.setHeadState(0);
                    this.attackIdleTimer = this.field_70146_Z.nextInt(10) + 10;
                }
            } else if (this.attackIdleTimer == 0 && this.attackcategory == 4 && !this.field_70729_aU) {
                if (this.attackingTimer == 80) {
                    this.setHeadState(2);
                    this.setArmState(8);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIWOODHAMMER_FIRE_01, SoundCategory.HOSTILE, 3.0f, 1.0f);
                } else if (this.attackingTimer == 40) {
                    this.setHeadState(1);
                    this.setArmState(2);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIWOODHAMMER_FIRE_02, SoundCategory.HOSTILE, 3.0f, 0.8f);
                } else if (this.attackingTimer == 10) {
                    this.setArmState(0);
                    this.setHeadState(0);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 3.0f, 0.8f);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187942_hp, SoundCategory.HOSTILE, 2.0f, 1.3f);
                    this.field_70180_af.func_187227_b(FIRE_POWERED, (Object)true);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    }
                }
                --this.attackingTimer;
                if (this.attackingTimer == 0) {
                    this.setArmState(0);
                    this.setHeadState(0);
                    this.attackIdleTimer = 20;
                }
            }
            if (!this.field_70170_p.field_72995_K && this.attackIdleTimer > 0) {
                this.setArmState(0);
                this.setHeadState(0);
                this.setBodyState(0);
            }
        }
        super.func_70636_d();
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB axis) {
        if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            int i = MathHelper.func_76128_c((double)axis.field_72340_a);
            int j = MathHelper.func_76128_c((double)axis.field_72338_b);
            int k = MathHelper.func_76128_c((double)axis.field_72339_c);
            int l = MathHelper.func_76128_c((double)axis.field_72336_d);
            int i1 = MathHelper.func_76128_c((double)axis.field_72337_e);
            int j1 = MathHelper.func_76128_c((double)axis.field_72334_f);
            boolean flag1 = false;
            for (int k1 = i; k1 <= l; ++k1) {
                for (int l1 = j; l1 <= i1; ++l1) {
                    for (int i2 = k; i2 <= j1; ++i2) {
                        BlockPos blockpos = new BlockPos(k1, l1, i2);
                        BlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        Block block = iblockstate.func_177230_c();
                        if (!iblockstate.canEntityDestroy((IBlockReader)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)iblockstate) || !BlockBreakCheck.canDestroyBlockWithObsidian(iblockstate.func_177230_c()) && (this.getFirePowered() || block != Blocks.field_150480_ab)) continue;
                        this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this);
                        flag1 = true;
                    }
                }
            }
            if (flag1) {
                double d0 = axis.field_72340_a + (axis.field_72336_d - axis.field_72340_a) * (double)this.field_70146_Z.nextFloat();
                double d1 = axis.field_72338_b + (axis.field_72337_e - axis.field_72338_b) * (double)this.field_70146_Z.nextFloat();
                double d2 = axis.field_72339_c + (axis.field_72334_f - axis.field_72339_c) * (double)this.field_70146_Z.nextFloat();
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 5) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_() + 3.0, this.func_226281_cx_(), 1.0, 0.0, 0.0);
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 1.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_() + 3.0, this.func_226281_cx_(), 1.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_() + 5.0, this.func_226281_cx_(), 1.0, 0.0, 0.0);
            }
        }
    }

    public void func_70071_h_() {
        block4: {
            super.func_70071_h_();
            if (!this.getFirePowered()) break block4;
            if (!this.func_70026_G()) {
                this.func_70015_d(5);
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 4.0f) - 2.0, this.func_226278_cu_() + 3.0 + (double)(this.field_70146_Z.nextFloat() * 3.0f) - 1.5, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 4.0f) - 2.0, d0, d1, d2);
                }
            } else {
                for (int i = 0; i > 5; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + this.field_70146_Z.nextDouble() * 0.5 * 1.55, this.func_226278_cu_() + 2.7, this.func_226281_cx_() + this.field_70146_Z.nextDouble() * 0.5 * 1.55, this.field_70146_Z.nextDouble() * 0.5 * 0.65, 0.25, this.field_70146_Z.nextDouble() * 0.5 * 0.65);
                }
            }
        }
    }

    protected void hammerSpell(int type) {
        LivingEntity entitylivingbase = this.func_70638_az();
        if (entitylivingbase != null) {
            double d0 = Math.min(entitylivingbase.func_226278_cu_(), this.func_226278_cu_()) - 15.0;
            double d1 = Math.max(entitylivingbase.func_226278_cu_(), this.func_226278_cu_()) + 15.0;
            if (this.getPowered()) {
                d1 = Math.max(entitylivingbase.func_226278_cu_(), this.func_226278_cu_()) + 2.0;
            }
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.func_226281_cx_() - this.func_226281_cx_()), (double)(entitylivingbase.func_226277_ct_() - this.func_226277_ct_()));
            if (type == 0) {
                float f2 = f + (float)this.field_70146_Z.nextInt(5) * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                this.spawnTargets(entitylivingbase.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 8.5, entitylivingbase.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 8.5, d0, d1, f2, 0);
                float f3 = f + 2.3561945f + 1.2566371f;
                this.spawnTargets(entitylivingbase.func_226277_ct_(), entitylivingbase.func_226281_cx_(), entitylivingbase.func_226278_cu_() - 2.0, entitylivingbase.func_226278_cu_() + 2.0, f3, 3);
                if (this.field_70146_Z.nextInt(3) == 0) {
                    float f4 = f2 + 2.0943952f;
                    this.spawnTargets(entitylivingbase.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f4) * 8.5, entitylivingbase.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f4) * 8.5, d0, d1, f4, 8);
                    float f5 = f4 + 2.0943952f;
                    this.spawnTargets(entitylivingbase.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f5) * 8.5, entitylivingbase.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f5) * 8.5, d0, d1, f5, 15);
                }
            } else if (type == 1) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI / 3.0f;
                    this.spawnTargets(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f1) * 8.8, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f1) * 8.8, d0, d1, f1, 0);
                }
            }
        }
    }

    private void spawnTargets(double x, double z, double minY, double maxY, float rotationYaw, int delayTick) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)this.field_70170_p, blockpos1.func_177977_b(), Direction.UP) || !this.field_70170_p.func_175710_j(blockpos1) && !this.getPowered()) continue;
            if (!this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
        if (flag) {
            EntityTargetOfHammer targetthunder = new EntityTargetOfHammer(this.field_70170_p, x, (double)blockpos.func_177956_o() + d0, z, rotationYaw, delayTick, (LivingEntity)this, this.getFirePowered());
            this.field_70170_p.func_217376_c((Entity)targetthunder);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        BlockPos bosspos = this.func_233580_cy_();
        block0: for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 20; ++j) {
                BlockPos blockpos = bosspos.func_177982_a(-6 + this.field_70146_Z.nextInt(13), -4 + this.field_70146_Z.nextInt(7), -6 + this.field_70146_Z.nextInt(13));
                EntityNikkoryWoods woods = new EntityNikkoryWoods(InitEntity.NIKKORYWOODS, this.field_70170_p);
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                if (!blockstate.func_224755_d((IBlockReader)this.field_70170_p, blockpos, Direction.UP) || blockpos.equals((Object)bosspos) || !this.field_70170_p.func_175623_d(blockpos.func_177984_a())) continue;
                woods.func_70012_b(blockpos.func_177958_n(), blockpos.func_177984_a().func_177956_o(), blockpos.func_177952_p(), this.field_70177_z, 0.0f);
                this.field_70170_p.func_217376_c((Entity)woods);
                continue block0;
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public final void func_70108_f(Entity entityIn) {
        this.func_213293_j(0.0, NCMotion.getMotionY((Entity)this), 0.0);
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                EntityBossDropChest chest = new EntityBossDropChest((EntityType<? extends EntityBossDropChest>)InitEntity.BOSS_DROP_CHEST, this.field_70170_p);
                chest.setBossType(4);
                if (this.getPowered()) {
                    chest.setChestColor(1);
                } else {
                    chest.setChestColor(0);
                }
                if (i == 0) {
                    chest.setBossType(5);
                }
                chest.func_195064_c(new EffectInstance(Effects.field_188423_x, 1200, 1, false, false));
                double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 1.0 - 0.5);
                double y = this.func_226278_cu_() + 2.0;
                double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 1.0 - 0.5);
                chest.func_70012_b(x, y, z, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)chest);
            }
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187945_hs, this.func_184176_by(), 1.0f, 1.0f);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.getSleepingState() && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (source.func_76346_g() instanceof ArrowEntity || source.func_76364_f() instanceof ArrowEntity) {
            return super.func_70097_a(source, damage / 2.0f);
        }
        if (source.func_76346_g() instanceof EntityNikkoriWoodHammer) {
            return super.func_70097_a(source, damage / 2.0f);
        }
        if (NElements.isFireDamage(source) || NElements.isWindDamage(source)) {
            if (this.getFirePowered()) {
                return false;
            }
            return super.func_70097_a(source, damage * 2.0f);
        }
        if (NElements.isIceDamage(source)) {
            if (this.getFirePowered()) {
                return false;
            }
            return super.func_70097_a(source, damage);
        }
        if (source.func_76346_g() instanceof EntityCrazyNikkori) {
            source.func_76346_g().func_70106_y();
            if (!this.getPowered()) {
                this.nikkoriPossession();
            }
            return false;
        }
        if (source.func_76346_g() instanceof MonsterEntity && NElements.isNonBoss(source.func_76346_g())) {
            return super.func_70097_a(source, 1.0f);
        }
        return super.func_70097_a(source, damage);
    }

    public final void func_82196_d(LivingEntity target, float distanceFactor) {
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("powered", this.getPowered());
        compound.func_74757_a("challengeFlag", this.challengeFlag);
        compound.func_74768_a("challengeCount", this.challengeCount);
        if (((Boolean)this.field_70180_af.func_187225_a(SLEEPING)).booleanValue()) {
            compound.func_74757_a("sleeping", true);
        }
        compound.func_74757_a("ikari", this.ikari);
        compound.func_74768_a("spAttackFlag", this.spAttackFlag);
        if (((Boolean)this.field_70180_af.func_187225_a(FIRE_POWERED)).booleanValue()) {
            compound.func_74757_a("firepowered", true);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPowered(compound.func_74767_n("powered"));
        this.challengeFlag = compound.func_74767_n("challengeFlag");
        this.challengeCount = compound.func_74762_e("challengeCount");
        if (this.getPowered()) {
            this.setPossession();
        }
        this.ikari = compound.func_74767_n("ikari");
        this.spAttackFlag = compound.func_74762_e("spAttackFlag");
        this.field_70180_af.func_187227_b(FIRE_POWERED, (Object)compound.func_74767_n("firepowered"));
        this.field_70180_af.func_187227_b(SLEEPING, (Object)compound.func_74767_n("sleeping"));
        if (!this.getSleepingState()) {
            this.bossInfo.func_186758_d(true);
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
            this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 30.0f));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K) {
            this.updateChallengeCount();
        }
    }

    @Override
    public void updateChallengeCount() {
        if (this.challengeFlag) {
            if (this.challengeCount > 0) {
                if (this.challengeCount % 20 == 0) {
                    String timeLimit = this.getChallengeCountString();
                    String bossNameString = NTextUtil.getMobName((Entity)this);
                    TranslationTextComponent text = new TranslationTextComponent("nc.msg.bossmob.challenge", new Object[]{bossNameString, timeLimit});
                    if (this.getPowered()) {
                        text = new TranslationTextComponent("nc.msg.bossmob.challenge", new Object[]{new TranslationTextComponent("nc.msg.possession.name", new Object[]{bossNameString}), timeLimit});
                    }
                    this.setCrazyName(text);
                }
            } else {
                if (this.getPowered()) {
                    TranslationTextComponent text = new TranslationTextComponent("nc.msg.possession.name", new Object[]{NTextUtil.getMobName((Entity)this)});
                    this.setCrazyName(text);
                } else {
                    this.bossInfo.func_186739_a(this.func_145748_c_());
                }
                this.challengeFlag = false;
            }
            --this.challengeCount;
        }
    }

    public String getChallengeCountString() {
        if (this.challengeFlag) {
            int sec = this.challengeCount / 20;
            int min = MathHelper.func_76125_a((int)(sec / 60), (int)0, (int)60);
            int formatSec = sec % 60 == 0 ? 0 : sec - min * 60;
            String timeLimit = min + ":" + String.format("%02d", formatSec);
            return timeLimit;
        }
        return "";
    }

    @Override
    public void setChallengeCount(int count) {
        if (this.getSleepingState()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_199702_a((IItemProvider)NCustomItem.CHALLENGER_GLOVE, 1);
            }
        } else {
            if (!this.challengeFlag) {
                this.challengeFlag = true;
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.MAGIC_CHARGE_01, this.func_184176_by(), 2.0f, 0.8f);
                this.viewDuelMessage();
            }
            this.challengeCount = count;
        }
    }

    public void viewDuelMessage() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(30.0);
        List list1 = this.field_70170_p.func_217357_a(PlayerEntity.class, axisalignedbb);
        String itemname = new ItemStack((IItemProvider)NCustomItem.CHALLENGER_GLOVE).func_200301_q().getString();
        if (!list1.isEmpty()) {
            for (PlayerEntity entityplayer : list1) {
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306b \u00a7e" + itemname + "\u00a7d \u304c \u30d2\u30c3\u30c8\u3057\u305f\uff01"), Util.field_240973_b_);
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306f \u30b4\u30df\u3092\u6295\u3052\u3089\u308c\u305f\u3068\u601d\u3044\u8fbc\u3093\u3067 \u6012\u3063\u3066\u3044\u308b\uff01"), Util.field_240973_b_);
            }
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191268_hm, SoundCategory.HOSTILE, 3.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_181015_d(BlockPos pos) {
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (!state.func_203425_a(Blocks.field_196553_aF) && !state.func_203425_a(Blocks.field_222434_lW)) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.challengeFlag;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setPowered(boolean state) {
        this.field_70180_af.func_187227_b(POWERED, (Object)state);
    }

    public boolean getFirePowered() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRE_POWERED);
    }

    public int getHeadState() {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_STATE);
    }

    public boolean getSleepingState() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public int getArmState() {
        return (Integer)this.field_70180_af.func_187225_a(ARM_STATE);
    }

    public int getBodyState() {
        return (Integer)this.field_70180_af.func_187225_a(BODY_STATE);
    }

    public void setHeadState(int state) {
        this.field_70180_af.func_187227_b(HEAD_STATE, (Object)state);
    }

    public void setArmState(int state) {
        this.field_70180_af.func_187227_b(ARM_STATE, (Object)state);
    }

    public void setBodyState(int state) {
        this.field_70180_af.func_187227_b(BODY_STATE, (Object)state);
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @Override
    public void nikkoriPossession() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(50.0);
        List list1 = this.field_70170_p.func_217357_a(PlayerEntity.class, axisalignedbb);
        boolean success = false;
        if (this.func_110143_aJ() >= this.func_110138_aP() * 0.5f) {
            if (!list1.isEmpty()) {
                for (PlayerEntity entityplayer : list1) {
                    entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306b \u00a7e\u72c2\u6c17\u306e\u7b11\u9854 \u00a7d\u304c\u53d6\u308a\u3064\u3044\u3066\u3057\u307e\u3063\u305f\uff01"), Util.field_240973_b_);
                    entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306f \u3053\u306e\u8fba\u4e00\u5e2f\u3092 \u706b\u306e\u6d77\u306b\u3059\u308b\u3053\u3068\u306b\u6c7a\u3081\u305f\uff01"), Util.field_240973_b_);
                }
            }
            success = true;
        } else if (!list1.isEmpty()) {
            for (PlayerEntity entityplayer : list1) {
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306b \u00a7e\u72c2\u6c17\u306e\u7b11\u9854 \u00a7d\u304c\u53d6\u308a\u3064\u3053\u3046\u3068\u3057\u305f\uff01"), Util.field_240973_b_);
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d\u3057\u304b\u3057 " + NTextUtil.getMobName((Entity)this) + " \u306f\u7a2e\u306e\u7d76\u6ec5\u3092\u6050\u308c\u308b\u3042\u307e\u308a\u304b \u53d6\u308a\u3064\u304f\u4f59\u5730\u304c\u306a\u3044\uff01"), Util.field_240973_b_);
            }
        }
        if (success) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187942_hp, SoundCategory.HOSTILE, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 1.2f);
            this.setPossession();
        }
    }

    @Override
    public void setPossession() {
        TranslationTextComponent text = new TranslationTextComponent("nc.msg.possession.name", new Object[]{NTextUtil.getMobName((Entity)this)});
        String bossNameString = NTextUtil.getMobName((Entity)this);
        if (this.challengeFlag) {
            text = new TranslationTextComponent("nc.msg.bossmob.challenge", new Object[]{new TranslationTextComponent("nc.msg.possession.name", new Object[]{bossNameString}), this.getChallengeCountString()});
        }
        this.setCrazyName(text);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    @Override
    public void setCrazyName(TranslationTextComponent possessionName) {
        IFormattableTextComponent bossname = ScorePlayerTeam.func_237500_a_((Team)this.func_96124_cp(), (ITextComponent)possessionName).func_240700_a_(style -> style.func_240716_a_(this.func_174823_aP()).func_240714_a_(this.func_189512_bd()));
        bossname.func_150256_b().func_240716_a_(this.func_174823_aP());
        bossname.func_150256_b().func_240714_a_(this.func_189512_bd());
        this.bossInfo.func_186739_a((ITextComponent)bossname);
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityNikkoriWoodHammer.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && worldIn.func_175710_j(pos) && randomIn.nextInt(3) == 0 && EntityNikkoriWoodHammer.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected SoundEvent func_184639_G() {
        if (!this.getSleepingState()) {
            return CustomSound.NIKKORIWOODHAMMER_LIVING;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187881_gQ;
    }

    protected SoundEvent func_184615_bR() {
        return CustomSound.NIKKORI_BRIZZARD_DEATH;
    }
}

