/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.boss;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import otsunozi.nikkorihazard.ai.EntityAIReachSettingMeleeAttack;
import otsunozi.nikkorihazard.entity.EntityCrazyNikkori;
import otsunozi.nikkorihazard.entity.INikkoriBossMob;
import otsunozi.nikkorihazard.entity.INikkoriMob;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.entity.item.EntityNicolearBomb;
import otsunozi.nikkorihazard.entity.item.bullet.EntityFireAppleCannon;
import otsunozi.nikkorihazard.entity.passive.EntityBossDropChest;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.BlockBreakCheck;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NElements;
import otsunozi.nikkorihazard.util.NTextUtil;

public class EntityNikkoriminator
extends MonsterEntity
implements INikkoriMob,
INikkoriBossMob {
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS);
    int challengeCount = 0;
    boolean challengeFlag = false;
    private int punchAttackTimer;
    private int punchIdleTimer;
    private boolean canPunch;
    private int quakeIdleTimer;
    private int TNTCounter;
    private int resetCounter;
    private boolean canQuake;
    private int bombCounter;
    private int bombShootCount;
    private int jumpCount;
    public float armTick = 0.0f;
    public float armTickPre = 0.0f;
    private static final DataParameter<Integer> ATTACK_STATE = EntityDataManager.func_187226_a(EntityNikkoriminator.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityNikkoriminator.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityNikkoriminator(EntityType<? extends EntityNikkoriminator> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 100;
        this.quakeIdleTimer = 100 + this.field_70146_Z.nextInt(100);
        this.resetCounter = 60;
        this.bombCounter = 100 + this.field_70146_Z.nextInt(100);
        this.TNTCounter = 60 + this.field_70146_Z.nextInt(100);
        this.canQuake = false;
        this.canPunch = false;
        this.jumpCount = 2;
        this.challengeCount = 1200;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIReachSettingMeleeAttack((CreatureEntity)this, 1.0, 1.7f, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_NIKKORIBOSS;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_STATE, (Object)0);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 500.0).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233819_b_, 42.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 9.0);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.0f;
    }

    public int func_82143_as() {
        return 20;
    }

    public boolean isEmergency() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public void func_70636_d() {
        LivingEntity entitylivingbase;
        boolean powered = this.getPowered();
        if (this.bombCounter > 0 && this.func_70638_az() != null) {
            --this.bombCounter;
            if (this.bombCounter == 20 && !this.field_70729_aU) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIMINATOR_RELOAD, SoundCategory.HOSTILE, 3.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
            } else if (this.bombCounter == 0 && !this.field_70729_aU) {
                entitylivingbase = this.func_70638_az();
                double d0 = this.func_70068_e((Entity)entitylivingbase);
                float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                double d1 = entitylivingbase.func_226277_ct_() - this.func_226277_ct_();
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.func_213302_cg() / 2.0f) - (this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f));
                double d3 = entitylivingbase.func_226281_cx_() - this.func_226281_cx_();
                this.bombShootCount = this.isEmergency() ? 3 : 1;
                for (int i = 1; i <= this.bombShootCount; ++i) {
                    EntityFireAppleCannon entitysmallfireball = new EntityFireAppleCannon(this.field_70170_p, (LivingEntity)this, d1 + this.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)f, 40);
                    entitysmallfireball.func_70107_b(entitysmallfireball.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f) + 0.5, entitysmallfireball.func_226281_cx_());
                    this.field_70170_p.func_217376_c((Entity)entitysmallfireball);
                }
                this.bombCounter = this.field_70146_Z.nextInt(80) + 120;
            }
        }
        if (this.quakeIdleTimer > 0 && this.func_70638_az() != null) {
            --this.quakeIdleTimer;
            if (this.quakeIdleTimer == 0 && !this.canQuake && !this.field_70729_aU) {
                this.quakeAttack();
            }
        } else if (this.quakeIdleTimer == 0) {
            --this.resetCounter;
            if (this.resetCounter == 0) {
                this.canQuake = false;
                this.quakeIdleTimer = this.field_70146_Z.nextInt(100) + 20;
                this.resetCounter = 60;
            }
        }
        if (this.canPunch) {
            if (this.punchAttackTimer <= 0) {
                if (this.punchIdleTimer > 0) {
                    --this.punchIdleTimer;
                } else if (this.punchIdleTimer <= 0) {
                    this.punchAttackTimer = 40;
                }
            } else {
                --this.punchAttackTimer;
                if (this.punchAttackTimer == 39) {
                    this.setAttackState(1);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.KAOPAD_LIVING, SoundCategory.HOSTILE, 3.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                } else if (this.punchAttackTimer == 30) {
                    this.setAttackState(2);
                } else if (this.punchAttackTimer == 25) {
                    this.setAttackState(3);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIMINATOR_SHOOT, SoundCategory.HOSTILE, 3.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.punchAttackTimer < 25 && this.punchAttackTimer > 15) {
                    if (this.punchAttackTimer % 5 == 0) {
                        this.punchDamage(this.punchAttackTimer == 20 ? 0.0f : 1.0f);
                    }
                    if (this.punchAttackTimer == 20) {
                        this.breakBlock();
                    }
                } else if (this.punchAttackTimer == 15) {
                    this.setAttackState(4);
                } else if (this.punchAttackTimer == 5) {
                    this.setAttackState(5);
                } else if (this.punchAttackTimer <= 0) {
                    this.canPunch = false;
                    this.setAttackState(0);
                    if (this.getPowered() && this.field_70146_Z.nextInt(5) >= 2) {
                        this.canPunch = true;
                        this.punchIdleTimer = 5;
                    }
                }
            }
        }
        if (this.isEmergency()) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.func_226278_cu_() + 2.7, this.func_226281_cx_() + this.field_70146_Z.nextDouble() * 0.5 - 0.25, 0.0, 0.25, 0.0);
            if (this.TNTCounter > 0 && this.func_70638_az() != null) {
                --this.TNTCounter;
                if (this.TNTCounter == 30 && !this.field_70729_aU) {
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIMINATOR_ALERT, SoundCategory.HOSTILE, 3.0f, 2.0f);
                }
                if (this.TNTCounter == 0 && !this.field_70729_aU && (entitylivingbase = this.func_70638_az()) != null && !this.field_70170_p.field_72995_K) {
                    float f1;
                    TNTEntity tnt = new TNTEntity(this.field_70170_p, (double)((float)this.func_226277_ct_()), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * 1.2, (double)((float)this.func_226281_cx_()), (LivingEntity)this);
                    float f = (float)(this.func_226277_ct_() - entitylivingbase.func_226277_ct_());
                    double d0 = MathHelper.func_76129_c((float)(f * f + (f1 = (float)(this.func_226281_cx_() - entitylivingbase.func_226281_cx_())) * f1));
                    if (d0 < 8.0 && this.func_226278_cu_() + 20.0 < entitylivingbase.func_226278_cu_()) {
                        NCMotion.setMotionY((Entity)tnt, this.field_70146_Z.nextDouble() * 0.3 + 1.65);
                        NCMotion.setMotionX((Entity)tnt, 0.0);
                        NCMotion.setMotionZ((Entity)tnt, 0.0);
                        tnt.func_184534_a(24);
                    } else if (d0 < 8.0 && this.func_226278_cu_() + 6.0 < entitylivingbase.func_226278_cu_()) {
                        NCMotion.setMotionY((Entity)tnt, this.field_70146_Z.nextDouble() * 0.3 + 1.0);
                        NCMotion.setMotionX((Entity)tnt, 0.0);
                        NCMotion.setMotionZ((Entity)tnt, 0.0);
                        tnt.func_184534_a(18);
                    } else if (d0 >= 2.0 && d0 <= 18.0 && this.func_226278_cu_() - 6.0 > entitylivingbase.func_226278_cu_()) {
                        NCMotion.setMotionY((Entity)tnt, this.field_70146_Z.nextDouble() * 0.3 + 0.3);
                        NCMotion.setMotionX((Entity)tnt, -MathHelper.func_76126_a((float)(this.field_70759_as * (float)Math.PI / 180.0f)));
                        NCMotion.setMotionZ((Entity)tnt, MathHelper.func_76134_b((float)(this.field_70759_as * (float)Math.PI / 180.0f)));
                        tnt.func_184534_a(40);
                    } else {
                        NCMotion.setMotionY((Entity)tnt, this.field_70146_Z.nextDouble() * 0.3 + 0.3);
                        NCMotion.setMotionX((Entity)tnt, -MathHelper.func_76126_a((float)(this.field_70759_as * (float)Math.PI / 180.0f)));
                        NCMotion.setMotionZ((Entity)tnt, MathHelper.func_76134_b((float)(this.field_70759_as * (float)Math.PI / 180.0f)));
                        tnt.func_184534_a(25);
                    }
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIMINATOR_SHOOT, SoundCategory.HOSTILE, 3.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.7f);
                    this.field_70170_p.func_217376_c((Entity)tnt);
                    this.TNTCounter = this.field_70146_Z.nextInt(90) + 60;
                }
            }
        }
        if (this.field_70171_ac && !this.field_70729_aU) {
            this.func_195064_c(new EffectInstance(Effects.field_76424_c, 40, 4));
            this.func_195064_c(new EffectInstance(Effects.field_76430_j, 10, 3));
        }
        super.func_70636_d();
    }

    private void punchDamage(float height) {
        AxisAlignedBB axis = this.func_174813_aQ().func_72314_b(2.0, -0.5, 2.0).func_72317_d(0.0, (double)(height + 0.3f), 0.0);
        int damage = 15;
        Iterator iterator = this.field_70170_p.func_217357_a(LivingEntity.class, axis).iterator();
        while (iterator.hasNext()) {
            LivingEntity target = (LivingEntity)iterator.next();
            if (target != this) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIDISASTER_ATTACK, SoundCategory.HOSTILE, 2.0f, 1.1f);
                if (target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)damage)) {
                    float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
                    target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (f1 += 4.0f) * 0.5f), this.field_70146_Z.nextDouble() * 0.2 + 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * f1 * 0.5f));
                }
            }
            iterator.remove();
        }
    }

    private void breakBlock() {
        if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            AxisAlignedBB axis = this.func_174813_aQ().func_72314_b(1.5, 0.5, 1.5).func_72317_d(0.0, (double)0.8f, 0.0);
            int i = MathHelper.func_76128_c((double)axis.field_72340_a);
            int j = MathHelper.func_76128_c((double)axis.field_72338_b);
            int k = MathHelper.func_76128_c((double)axis.field_72339_c);
            int l = MathHelper.func_76128_c((double)axis.field_72336_d);
            int i1 = MathHelper.func_76128_c((double)axis.field_72337_e);
            int j1 = MathHelper.func_76128_c((double)axis.field_72334_f);
            for (int k1 = i; k1 <= l; ++k1) {
                for (int l1 = j; l1 <= i1; ++l1) {
                    for (int i2 = k; i2 <= j1; ++i2) {
                        BlockPos blockpos = new BlockPos(k1, l1, i2);
                        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                        if (!blockstate.canEntityDestroy((IBlockReader)this.field_70170_p, blockpos, (Entity)this) || !BlockBreakCheck.canDestroyBlockWithObsidian(blockstate.func_177230_c()) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                        this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this);
                    }
                }
            }
        }
    }

    private void quakeAttack() {
        if (this.isEmergency()) {
            NCMotion.setMotionY((Entity)this, 1.0f + this.field_70146_Z.nextFloat() * 0.5f);
        } else {
            NCMotion.setMotionY((Entity)this, 1.0);
        }
        if (this.field_70171_ac) {
            NCMotion.setMotionX((Entity)this, (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            NCMotion.setMotionZ((Entity)this, (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        this.canQuake = true;
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                EntityBossDropChest chest = new EntityBossDropChest((EntityType<? extends EntityBossDropChest>)InitEntity.BOSS_DROP_CHEST, this.field_70170_p);
                chest.setBossType(0);
                if (this.getPowered()) {
                    chest.setChestColor(1);
                } else {
                    chest.setChestColor(0);
                }
                if (i == 0) {
                    chest.setBossType(1);
                }
                chest.func_195064_c(new EffectInstance(Effects.field_188423_x, 1200, 1, false, false));
                double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 1.0 - 0.5);
                double y = this.func_226278_cu_() + 2.0;
                double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 1.0 - 0.5);
                chest.func_70012_b(x, y, z, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)chest);
            }
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187945_hs, this.func_184176_by(), 1.0f, 1.0f);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_70638_az() != null && this.punchAttackTimer <= 0 && !this.canPunch) {
            this.punchIdleTimer = 20 + this.field_70146_Z.nextInt(70);
            this.canPunch = true;
        }
        if (source == DamageSource.field_76379_h || source.func_76347_k() || NElements.isIceDamage(source) || source.func_94541_c() && source.func_76346_g() == this) {
            return false;
        }
        if (NElements.isThunderDamage(source)) {
            return super.func_70097_a(source, damage * 2.0f);
        }
        if (source.func_76346_g() instanceof EntityCrazyNikkori) {
            source.func_76346_g().func_70106_y();
            if (!this.getPowered()) {
                this.nikkoriPossession();
            }
            return false;
        }
        if (source.func_76346_g() instanceof EntityNicolearBomb) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void spawnGolemExplosionParticle() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 30; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d0 * d3, this.func_226278_cu_() + (double)this.field_70146_Z.nextFloat() - d1 * d3, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d2 * d3, d0, d1, d2);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)20);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        this.canQuake = distance >= 4.0f && !this.field_70729_aU;
        if (this.canQuake) {
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(7.0, 2.0, 7.0);
            List list1 = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
            this.spawnGolemExplosionParticle();
            if (!list1.isEmpty()) {
                for (LivingEntity entitylivingbase : list1) {
                    double d0 = this.func_70068_e((Entity)entitylivingbase);
                    if (!(d0 < 50.0) || entitylivingbase instanceof EntityNikkoriminator || !entitylivingbase.func_233570_aj_()) continue;
                    NCMotion.setMotionY((Entity)entitylivingbase, 0.6);
                    entitylivingbase.func_70097_a(DamageSource.field_76379_h, 6.0f);
                }
            }
            if (this.isEmergency() && this.jumpCount > 0) {
                this.canQuake = false;
                this.quakeIdleTimer = 10;
                --this.jumpCount;
            } else {
                this.canQuake = false;
                this.quakeIdleTimer = this.field_70146_Z.nextInt(120) + 60;
                this.jumpCount = 2;
            }
        } else {
            this.canQuake = true;
            if (true) {
                this.canQuake = false;
                this.quakeIdleTimer = this.field_70146_Z.nextInt(100) + 10;
                this.jumpCount = 2;
            }
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("powered", this.getPowered());
        compound.func_74757_a("challengeFlag", this.challengeFlag);
        compound.func_74768_a("challengeCount", this.challengeCount);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPowered(compound.func_74767_n("powered"));
        this.challengeFlag = compound.func_74767_n("challengeFlag");
        this.challengeCount = compound.func_74762_e("challengeCount");
        if (this.getPowered()) {
            this.setPossession();
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K) {
            this.updateChallengeCount();
        }
    }

    @Override
    public void updateChallengeCount() {
        if (this.challengeFlag) {
            if (this.challengeCount > 0) {
                if (this.challengeCount % 20 == 0) {
                    String timeLimit = this.getChallengeCountString();
                    String bossNameString = NTextUtil.getMobName((Entity)this);
                    TranslationTextComponent text = new TranslationTextComponent("nc.msg.bossmob.challenge", new Object[]{bossNameString, timeLimit});
                    if (this.getPowered()) {
                        text = new TranslationTextComponent("nc.msg.bossmob.challenge", new Object[]{new TranslationTextComponent("nc.msg.possession.name", new Object[]{bossNameString}), timeLimit});
                    }
                    this.setCrazyName(text);
                }
            } else {
                if (this.getPowered()) {
                    TranslationTextComponent text = new TranslationTextComponent("nc.msg.possession.name", new Object[]{NTextUtil.getMobName((Entity)this)});
                    this.setCrazyName(text);
                } else {
                    this.bossInfo.func_186739_a(this.func_145748_c_());
                }
                this.challengeFlag = false;
            }
            --this.challengeCount;
        }
    }

    public String getChallengeCountString() {
        if (this.challengeFlag) {
            int sec = this.challengeCount / 20;
            int min = MathHelper.func_76125_a((int)(sec / 60), (int)0, (int)60);
            int formatSec = sec % 60 == 0 ? 0 : sec - min * 60;
            String timeLimit = min + ":" + String.format("%02d", formatSec);
            return timeLimit;
        }
        return "";
    }

    @Override
    public void setChallengeCount(int count) {
        if (!this.challengeFlag) {
            this.challengeFlag = true;
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.MAGIC_CHARGE_01, this.func_184176_by(), 2.0f, 0.8f);
            this.viewDuelMessage();
        }
        this.challengeCount = count;
    }

    public void viewDuelMessage() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(30.0);
        List list1 = this.field_70170_p.func_217357_a(PlayerEntity.class, axisalignedbb);
        String itemname = new ItemStack((IItemProvider)NCustomItem.CHALLENGER_GLOVE).func_200301_q().getString();
        if (!list1.isEmpty()) {
            for (PlayerEntity entityplayer : list1) {
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306b \u00a7e" + itemname + "\u00a7d \u304c \u30d2\u30c3\u30c8\u3057\u305f\uff01"), Util.field_240973_b_);
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306f\u30b7\u30e7\u30c3\u30af\u3067 \u3053\u306e\u5730\u70b9\u5468\u8fba\u3092 \u76ee\u7684\u5730\u306b\u8a2d\u5b9a\u3057\u305f\uff01"), Util.field_240973_b_);
            }
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_181015_d(BlockPos pos) {
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (!state.func_203425_a(Blocks.field_196553_aF) && !state.func_203425_a(Blocks.field_222434_lW)) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.challengeFlag;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setPowered(boolean state) {
        this.field_70180_af.func_187227_b(POWERED, (Object)state);
    }

    @Override
    public void nikkoriPossession() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(50.0);
        List list1 = this.field_70170_p.func_217357_a(PlayerEntity.class, axisalignedbb);
        boolean success = false;
        if (this.func_110143_aJ() >= this.func_110138_aP() * 0.5f) {
            if (!list1.isEmpty()) {
                for (PlayerEntity entityplayer : list1) {
                    entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306b \u00a7e\u72c2\u6c17\u306e\u7b11\u9854 \u00a7d\u304c\u53d6\u308a\u3064\u3044\u3066\u3057\u307e\u3063\u305f\uff01"), Util.field_240973_b_);
                    entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306f \u904e\u5270\u306a\u30cb\u30c3\u30b3\u30ea\u96fb\u8377\u304c\u52a0\u308f\u308a \u307e\u3059\u307e\u3059\u72c2\u3063\u305f\uff01"), Util.field_240973_b_);
                }
            }
            success = true;
        } else if (!list1.isEmpty()) {
            for (PlayerEntity entityplayer : list1) {
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306b \u00a7e\u72c2\u6c17\u306e\u7b11\u9854 \u00a7d\u304c\u53d6\u308a\u3064\u3053\u3046\u3068\u3057\u305f\uff01"), Util.field_240973_b_);
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d\u3057\u304b\u3057 " + NTextUtil.getMobName((Entity)this) + " \u306e\u982d\u8133\u304c\u5b8c\u5168\u306b\u72c2\u3063\u3066\u304a\u308a \u53d6\u308a\u3064\u3051\u306a\u304b\u3063\u305f\uff01"), Util.field_240973_b_);
            }
        }
        if (success) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187942_hp, SoundCategory.HOSTILE, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 1.2f);
            this.setPossession();
        }
    }

    @Override
    public void setPossession() {
        TranslationTextComponent text = new TranslationTextComponent("nc.msg.possession.name", new Object[]{NTextUtil.getMobName((Entity)this)});
        String bossNameString = NTextUtil.getMobName((Entity)this);
        if (this.challengeFlag) {
            text = new TranslationTextComponent("nc.msg.bossmob.challenge", new Object[]{new TranslationTextComponent("nc.msg.possession.name", new Object[]{bossNameString}), this.getChallengeCountString()});
        }
        this.setCrazyName(text);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    @Override
    public void setCrazyName(TranslationTextComponent possessionName) {
        IFormattableTextComponent bossname = ScorePlayerTeam.func_237500_a_((Team)this.func_96124_cp(), (ITextComponent)possessionName).func_240700_a_(style -> style.func_240716_a_(this.func_174823_aP()).func_240714_a_(this.func_189512_bd()));
        bossname.func_150256_b().func_240716_a_(this.func_174823_aP());
        bossname.func_150256_b().func_240714_a_(this.func_189512_bd());
        this.bossInfo.func_186739_a((ITextComponent)bossname);
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityNikkoriminator.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && worldIn.func_175710_j(pos) && randomIn.nextInt(3) == 0 && EntityNikkoriminator.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    public int getAttackState() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getArmAmount(float particalTicks) {
        float PI = (float)Math.PI;
        float PI2 = PI * 2.0f;
        this.armTickPre = this.armTick;
        if (this.getAttackState() == 1) {
            this.armTick += PI / 160.0f;
            if (this.armTick > PI / 4.0f) {
                this.armTick = PI / 4.0f;
            }
        } else if (this.getAttackState() == 2) {
            this.armTick = PI / 4.0f;
        } else if (this.getAttackState() == 3) {
            this.armTick -= PI / 20.0f;
        } else if (this.getAttackState() == 4) {
            this.armTick = PI / 2.0f;
        } else if (this.getAttackState() == 5) {
            this.armTick -= PI / 80.0f;
            if (this.armTick < 0.0f) {
                this.armTick = 0.0f;
            }
        } else {
            this.armTick = 0.0f;
        }
        if (this.armTick > PI2) {
            this.armTick -= PI2;
            this.armTickPre -= PI2;
        }
        return this.armTickPre;
    }
}

