/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.boss;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import otsunozi.nikkorihazard.ai.EntityAIReachSettingMeleeAttack;
import otsunozi.nikkorihazard.entity.EntityCrazyNikkori;
import otsunozi.nikkorihazard.entity.EntityWickedNikkori;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.entity.INikkoriOtherBossMob;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.entity.boss.EntityBombRock;
import otsunozi.nikkorihazard.entity.item.bullet.EntityLavaStone;
import otsunozi.nikkorihazard.entity.item.bullet.EntityOtsurockBuster;
import otsunozi.nikkorihazard.entity.passive.EntityBossDropChest;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NCustomDamageSource;
import otsunozi.nikkorihazard.util.NElements;
import otsunozi.nikkorihazard.util.NTextUtil;

public class EntityOtsuRock
extends MonsterEntity
implements INikkoriModMob,
INikkoriOtherBossMob {
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
    int challengeCount = 0;
    boolean challengeFlag = false;
    private int attackTimer;
    private int blockThrowTimer;
    private int heatUpTimer;
    private int rockBusterTimer;
    private int attackcategory;
    private int wakeupTimer;
    private boolean startWakeup;
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityOtsuRock.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ROCK_BUSTER = EntityDataManager.func_187226_a(EntityOtsuRock.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DANCING_STATE = EntityDataManager.func_187226_a(EntityOtsuRock.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BODY_STATE = EntityDataManager.func_187226_a(EntityOtsuRock.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BODY_TIME = EntityDataManager.func_187226_a(EntityOtsuRock.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ON_JUKEBOX = EntityDataManager.func_187226_a(EntityOtsuRock.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WAKEUP_STATE = EntityDataManager.func_187226_a(EntityOtsuRock.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityOtsuRock(EntityType<? extends EntityOtsuRock> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 100;
        this.func_94061_f(false);
        this.attackTimer = this.field_70146_Z.nextInt(60) + 10;
        this.wakeupTimer = 90;
        this.field_70138_W = 1.0f;
        this.bossInfo.func_186758_d(false);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
    }

    private void setMainAI() {
        this.bossInfo.func_186758_d(true);
        this.field_70180_af.func_187227_b(SLEEPING, (Object)false);
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIReachSettingMeleeAttack((CreatureEntity)this, 1.0, 1.5f, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_ETCBOSS;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLEEPING, (Object)true);
        this.field_70180_af.func_187214_a(ROCK_BUSTER, (Object)false);
        this.field_70180_af.func_187214_a(ON_JUKEBOX, (Object)false);
        this.field_70180_af.func_187214_a(DANCING_STATE, (Object)0);
        this.field_70180_af.func_187214_a(WAKEUP_STATE, (Object)0);
        this.field_70180_af.func_187214_a(BODY_STATE, (Object)0);
        this.field_70180_af.func_187214_a(BODY_TIME, (Object)1200);
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 400.0).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233819_b_, 55.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 4.5f;
    }

    public int func_82143_as() {
        return 30;
    }

    public boolean isEmergency() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public void func_70636_d() {
        if (this.getSleeping()) {
            BlockPos blockpos;
            int arroundHorrowCount;
            if (this.getSleepingState() < 3) {
                NCMotion.setMotionX((Entity)this, 0.0);
                NCMotion.setMotionY((Entity)this, 0.0);
                NCMotion.setMotionZ((Entity)this, 0.0);
            }
            if ((arroundHorrowCount = this.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)(blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_())).func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g(9.0)).size()) >= 1 && !this.startWakeup) {
                this.startWakeup = true;
            } else if (this.startWakeup) {
                if (this.wakeupTimer == 80) {
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.OTSUROCK_LIVING, SoundCategory.HOSTILE, 4.0f, 1.0f);
                    this.field_70180_af.func_187227_b(WAKEUP_STATE, (Object)1);
                }
                if (this.wakeupTimer == 60) {
                    this.field_70180_af.func_187227_b(WAKEUP_STATE, (Object)2);
                }
                if (this.wakeupTimer == 40) {
                    this.field_70180_af.func_187227_b(WAKEUP_STATE, (Object)3);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0, 0.0, 0.0);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (0.4f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    NCMotion.setMotionY((Entity)this, 1.1f);
                }
                if (this.wakeupTimer == 10) {
                    this.field_70180_af.func_187227_b(WAKEUP_STATE, (Object)4);
                }
                if (this.wakeupTimer == 0) {
                    this.setMainAI();
                }
                --this.wakeupTimer;
            }
        } else {
            if (this.attackTimer > 0 && this.func_70638_az() != null && !this.field_70729_aU) {
                this.field_70708_bq = 0;
                --this.attackTimer;
                if (this.attackTimer == 0 && !this.field_70729_aU) {
                    if (this.getBodyState() == 0) {
                        this.attackcategory = this.isEmergency() ? this.field_70146_Z.nextInt(3) : this.field_70146_Z.nextInt(2);
                        this.heatUpTimer = 90;
                        this.blockThrowTimer = 30;
                        this.rockBusterTimer = 50;
                    } else if (this.getBodyState() == 1) {
                        this.attackcategory = this.isEmergency() ? this.field_70146_Z.nextInt(3) : this.field_70146_Z.nextInt(2);
                        this.heatUpTimer = 90;
                        this.blockThrowTimer = 30;
                        this.rockBusterTimer = 50;
                    } else if (this.getBodyState() == 2) {
                        this.attackcategory = this.isEmergency() ? (this.field_70146_Z.nextInt(8) == 0 && this.attackcategory != 3 ? 3 : this.field_70146_Z.nextInt(2) + 1) : (this.field_70146_Z.nextInt(8) == 0 && this.attackcategory != 3 ? 3 : 1);
                        this.blockThrowTimer = 30;
                        this.rockBusterTimer = 50;
                        this.heatUpTimer = 115;
                    }
                }
            }
            if (this.attackTimer == 0 && this.attackcategory == 0 && !this.field_70729_aU) {
                if (this.heatUpTimer > 20) {
                    NCMotion.setMotionX((Entity)this, 0.0);
                    NCMotion.setMotionY((Entity)this, 0.0);
                    NCMotion.setMotionZ((Entity)this, 0.0);
                }
                if (this.heatUpTimer == 90) {
                    this.field_70180_af.func_187227_b(ON_JUKEBOX, (Object)true);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIMINATOR_RELOAD, SoundCategory.BLOCKS, 2.0f, 2.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                    this.func_70656_aK();
                    if (this.field_70170_p.field_72995_K) {
                        for (int i = 0; i < 10; ++i) {
                            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d3 = 10.0;
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197602_M, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 1.0, this.func_226278_cu_() + 6.0 + (double)(this.field_70146_Z.nextFloat() * 1.0f) - 2.0, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 1.0, d0, d1, d2);
                        }
                    }
                } else if (this.heatUpTimer == 75) {
                    this.field_70180_af.func_187227_b(DANCING_STATE, (Object)1);
                    if (this.getBodyState() == 1) {
                        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.OTSUROCK_HEATUP_02, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    } else {
                        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.OTSUROCK_HEATUP, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    }
                } else if (this.heatUpTimer == 20) {
                    this.field_70180_af.func_187227_b(DANCING_STATE, (Object)2);
                    this.field_70180_af.func_187227_b(ON_JUKEBOX, (Object)false);
                    if (this.getBodyState() == 1) {
                        boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
                        this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_() + 3.0, this.func_226281_cx_(), 5.0f, false, flag ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
                        if (this.func_70638_az() != null) {
                            LivingEntity target = this.func_70638_az();
                            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
                            double d1 = target.func_226278_cu_() - this.func_226278_cu_();
                            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
                            NCMotion.setMotionX((Entity)this, d0 * 0.1);
                            NCMotion.setMotionY((Entity)this, d1 * 0.1 + 1.0);
                            NCMotion.setMotionZ((Entity)this, d2 * 0.1);
                        } else {
                            NCMotion.setMotionY((Entity)this, 1.0);
                        }
                    } else {
                        this.setBodyState(1);
                        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORI_BRIZZARD_DEATH, SoundCategory.BLOCKS, 2.5f, 1.9f);
                        this.setBodyTime(1000);
                    }
                }
                --this.heatUpTimer;
                if (this.heatUpTimer == 0) {
                    this.field_70180_af.func_187227_b(DANCING_STATE, (Object)0);
                    this.attackTimer = this.field_70146_Z.nextInt(20) + 100;
                }
            } else if (this.attackTimer == 0 && this.attackcategory == 1 && !this.field_70729_aU) {
                if (this.blockThrowTimer == 20 && !this.field_70729_aU) {
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187643_bs, SoundCategory.HOSTILE, 4.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                } else if (this.blockThrowTimer == 0 && !this.field_70729_aU) {
                    LivingEntity entitylivingbase = this.func_70638_az();
                    if (entitylivingbase != null && !this.field_70170_p.field_72995_K) {
                        double d0 = this.func_70068_e((Entity)entitylivingbase);
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        double d1 = entitylivingbase.func_226277_ct_() - this.func_226277_ct_();
                        double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.func_213302_cg() / 2.0f) - (this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f));
                        double d3 = entitylivingbase.func_226281_cx_() - this.func_226281_cx_();
                        boolean burning = false;
                        boolean canbreakbrock = true;
                        if (this.getBodyState() == 1) {
                            burning = true;
                        }
                        if (this.getBodyState() == 2) {
                            canbreakbrock = false;
                        }
                        EntityLavaStone lavastone = new EntityLavaStone(this.field_70170_p, (LivingEntity)this, d1 + this.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)f, 60, 8, burning, canbreakbrock);
                        lavastone.func_70107_b(lavastone.func_226277_ct_(), this.func_226278_cu_() + 3.0, lavastone.func_226281_cx_());
                        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187606_E, SoundCategory.HOSTILE, 4.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                        this.field_70170_p.func_217376_c((Entity)lavastone);
                    }
                    this.attackTimer = this.field_70146_Z.nextInt(20) + 40;
                }
                --this.blockThrowTimer;
            } else if (this.attackTimer == 0 && this.attackcategory == 2 && !this.field_70729_aU) {
                LivingEntity entitylivingbase;
                if (this.rockBusterTimer == 50 && !this.field_70729_aU) {
                    this.field_70180_af.func_187227_b(ROCK_BUSTER, (Object)true);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187643_bs, SoundCategory.HOSTILE, 4.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                } else if (this.rockBusterTimer <= 30 && !this.field_70729_aU && this.rockBusterTimer % 3 == 0 && (entitylivingbase = this.func_70638_az()) != null && !this.field_70170_p.field_72995_K) {
                    double d0 = this.func_70068_e((Entity)entitylivingbase);
                    float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                    double d1 = entitylivingbase.func_226277_ct_() - this.func_226277_ct_();
                    double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.func_213302_cg() / 2.0f) - (this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f));
                    double d3 = entitylivingbase.func_226281_cx_() - this.func_226281_cx_();
                    boolean canbreakbrock = false;
                    boolean canExplosion = true;
                    if (this.getBodyState() == 1) {
                        canbreakbrock = true;
                    }
                    if (this.getBodyState() == 2) {
                        canExplosion = false;
                    }
                    EntityOtsurockBuster rockbuster = new EntityOtsurockBuster(this.field_70170_p, (LivingEntity)this, d1 + this.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)f, 60, canbreakbrock, canExplosion);
                    rockbuster.func_70107_b(rockbuster.func_226277_ct_(), this.func_226278_cu_() + 3.0, rockbuster.func_226281_cx_());
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187606_E, SoundCategory.HOSTILE, 2.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                    this.field_70170_p.func_217376_c((Entity)rockbuster);
                }
                if (this.rockBusterTimer <= 0) {
                    this.field_70180_af.func_187227_b(ROCK_BUSTER, (Object)false);
                    this.attackTimer = this.field_70146_Z.nextInt(40) + 60;
                }
                --this.rockBusterTimer;
            } else if (this.attackTimer == 0 && this.attackcategory == 3 && !this.field_70729_aU) {
                if (this.heatUpTimer > 20) {
                    NCMotion.setMotionX((Entity)this, 0.0);
                    NCMotion.setMotionY((Entity)this, 0.0);
                    NCMotion.setMotionZ((Entity)this, 0.0);
                }
                if (this.heatUpTimer == 115) {
                    this.field_70180_af.func_187227_b(ON_JUKEBOX, (Object)true);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIMINATOR_RELOAD, SoundCategory.BLOCKS, 2.0f, 2.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                    this.func_70656_aK();
                    if (this.field_70170_p.field_72995_K) {
                        for (int i = 0; i < 10; ++i) {
                            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d3 = 10.0;
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197602_M, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 1.0, this.func_226278_cu_() + 6.0 + (double)(this.field_70146_Z.nextFloat() * 1.0f) - 2.0, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 1.0, d0, d1, d2);
                        }
                    }
                } else if (this.heatUpTimer == 95) {
                    this.field_70180_af.func_187227_b(DANCING_STATE, (Object)3);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.OTSUROCK_HEATUP_03, SoundCategory.BLOCKS, 4.0f, 1.0f);
                } else if (this.heatUpTimer == 20) {
                    this.field_70180_af.func_187227_b(DANCING_STATE, (Object)2);
                    this.field_70180_af.func_187227_b(ON_JUKEBOX, (Object)false);
                    if (!this.field_70729_aU && !this.field_70170_p.field_72995_K) {
                        if (this.func_70638_az() != null) {
                            LivingEntity target = this.func_70638_az();
                            Vector3d targetvec = target.func_213303_ch();
                            Vector3d vec = this.func_213303_ch();
                            vec = vec.func_178787_e(targetvec.func_216371_e());
                            vec = vec.func_72432_b();
                            double d0 = vec.func_82615_a();
                            double d1 = vec.func_82617_b();
                            double d2 = vec.func_82616_c();
                            NCMotion.setMotionX((Entity)this, d0 * 0.6);
                            NCMotion.setMotionY((Entity)this, d1 * 0.6 + 0.8);
                            NCMotion.setMotionZ((Entity)this, d2 * 0.6);
                            int count = this.isEmergency() ? 12 : 7;
                            for (int i = 0; i < count; ++i) {
                                EntityBombRock bombrock = new EntityBombRock(this.field_70170_p, this.field_70146_Z.nextInt(120) + 80);
                                BlockPos targetPos = this.func_70638_az().func_233580_cy_();
                                double x = (double)targetPos.func_177958_n() - this.func_226277_ct_();
                                double y = 1.4;
                                double z = (double)targetPos.func_177952_p() - this.func_226281_cx_();
                                float f = MathHelper.func_76133_a((double)(x * x + z * z)) * 0.19f;
                                bombrock.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.8, this.func_226281_cx_(), this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                                bombrock.shoot(x, y + (double)f, z, 1.6f, 45.0f);
                                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187924_gx, SoundCategory.HOSTILE, 2.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 2.7f) + f * 0.5f);
                                this.field_70170_p.func_217376_c((Entity)bombrock);
                            }
                        } else {
                            NCMotion.setMotionY((Entity)this, 0.8f);
                        }
                    }
                }
                --this.heatUpTimer;
                if (this.heatUpTimer == 0) {
                    this.field_70180_af.func_187227_b(DANCING_STATE, (Object)0);
                    this.attackTimer = this.field_70146_Z.nextInt(60) + 20;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.getDancingState() == 0) {
            this.attackTimer = this.field_70146_Z.nextInt(60) + 20;
        }
        if (!this.field_70170_p.field_72995_K && this.attackTimer > 0) {
            this.field_70180_af.func_187227_b(ROCK_BUSTER, (Object)false);
            this.field_70180_af.func_187227_b(DANCING_STATE, (Object)0);
            this.field_70180_af.func_187227_b(ON_JUKEBOX, (Object)false);
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        int i;
        super.func_70071_h_();
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        if (this.getBodyState() == 1 && this.field_70170_p.field_72995_K) {
            for (i = 0; i < 10; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 4.0f) - 2.0, this.func_226278_cu_() + 3.0 + (double)(this.field_70146_Z.nextFloat() * 3.0f) - 1.5, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 4.0f) - 2.0, d0, d1, d2);
            }
        }
        if (this.getDancingState() == 1 && this.getBodyState() == 1 && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 1.0f) - 0.5, this.func_226278_cu_() + 6.7, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 1.0f) - 0.5, (double)this.field_70146_Z.nextInt(20) / 24.0, d1, d2);
            for (i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 4.0f) - 2.0, this.func_226278_cu_() + 3.0 + (double)(this.field_70146_Z.nextFloat() * 3.0f) - 1.5, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 4.0f) - 2.0, d0, d1, d2);
            }
        } else if ((this.getDancingState() == 1 || this.getDancingState() == 3) && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 1.0f) - 0.5, this.func_226278_cu_() + 6.7, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 1.0f) - 0.5, (double)this.field_70146_Z.nextInt(10) / 24.0, d1, d2);
        }
        if (this.getBodyState() == 1) {
            if (this.field_70173_aa % 15 == 0) {
                AxisAlignedBB axis = this.func_174813_aQ().func_186662_g(3.0);
                Iterator iterator = this.field_70170_p.func_217357_a(LivingEntity.class, axis).iterator();
                while (iterator.hasNext()) {
                    LivingEntity target = (LivingEntity)iterator.next();
                    if (target != this) {
                        target.func_70097_a(NCustomDamageSource.causeHotAirDamage((LivingEntity)this, (Entity)this), 4.0f);
                        target.func_70015_d(1);
                    }
                    iterator.remove();
                }
            }
            if (!this.func_180799_ab() && this.getDancingState() == 0) {
                int r = this.getBodyTime() - 1;
                this.setBodyTime(r);
                if (this.getBodyTime() <= 0) {
                    this.setBodyState(2);
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 3.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                    if (this.field_70170_p.field_72995_K) {
                        for (int i2 = 0; i2 < 20; ++i2) {
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 4.0f) - 2.0, this.func_226278_cu_() + 3.0 + (double)(this.field_70146_Z.nextFloat() * 3.0f) - 1.5, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 4.0f) - 2.0, d0, d1, d2);
                        }
                    }
                    this.setBodyTime(800);
                }
            }
        } else if (this.getBodyState() == 2) {
            int r = this.getBodyTime() - 1;
            if (this.func_180799_ab()) {
                r -= 2;
            }
            this.setBodyTime(r);
            if (this.getBodyTime() <= 0) {
                this.setBodyState(0);
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 3.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 0.5f);
                this.func_70656_aK();
                this.setBodyTime(800);
            }
        }
    }

    public final void func_70108_f(Entity entityIn) {
        if (entityIn instanceof LivingEntity && !(entityIn instanceof EntityOtsuRock)) {
            float distance = this.func_70032_d(entityIn);
            if (distance <= 1.0f) {
                entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 10.0f);
            } else {
                entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
            }
        }
        super.func_70108_f(entityIn);
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                EntityBossDropChest chest = new EntityBossDropChest((EntityType<? extends EntityBossDropChest>)InitEntity.BOSS_DROP_CHEST, this.field_70170_p);
                chest.setBossType(2);
                chest.setChestColor(2);
                if (i == 0) {
                    chest.setBossType(3);
                }
                chest.func_195064_c(new EffectInstance(Effects.field_188423_x, 1200, 1, false, false));
                double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 1.0 - 0.5);
                double y = this.func_226278_cu_() + 2.0;
                double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 1.0 - 0.5);
                chest.func_70012_b(x, y, z, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)chest);
            }
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187945_hs, this.func_184176_by(), 1.0f, 1.0f);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.getSleeping() && source != DamageSource.field_76380_i) {
            return false;
        }
        if (NElements.isIceDamage(source)) {
            return super.func_70097_a(source, damage * 2.0f);
        }
        if (source.func_76346_g() instanceof ArrowEntity || source.func_76364_f() instanceof ArrowEntity) {
            return false;
        }
        if (NElements.isWindDamage(source) || NElements.isFireDamage(source)) {
            return false;
        }
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (source.func_94541_c() && (source.func_76346_g() instanceof EntityOtsuRock || source.func_76346_g() instanceof EntityBombRock)) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityCrazyNikkori || source.func_76346_g() instanceof EntityWickedNikkori) {
            source.func_76346_g().func_70106_y();
            return false;
        }
        if (source.func_76364_f() instanceof SnowballEntity) {
            return super.func_70097_a(source, 2.0f);
        }
        if (this.getBodyState() == 2) {
            return super.func_70097_a(source, damage / 2.0f);
        }
        return super.func_70097_a(source, damage);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("sleeping", this.getSleeping());
        compound.func_74768_a("bodystate", this.getBodyState());
        compound.func_74768_a("bodytime", this.getBodyTime());
        compound.func_74757_a("challengeFlag", this.challengeFlag);
        compound.func_74768_a("challengeCount", this.challengeCount);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(SLEEPING, (Object)compound.func_74767_n("sleeping"));
        this.setBodyState(compound.func_74762_e("bodystate"));
        this.setBodyTime(compound.func_74762_e("bodytime"));
        this.challengeFlag = compound.func_74767_n("challengeFlag");
        this.challengeCount = compound.func_74762_e("challengeCount");
        if (!this.getSleeping()) {
            this.setMainAI();
        }
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K) {
            this.updateChallengeCount();
        }
    }

    @Override
    public void updateChallengeCount() {
        if (this.challengeFlag) {
            if (this.challengeCount > 0) {
                if (this.challengeCount % 20 == 0) {
                    String timeLimit = this.getChallengeCountString();
                    String bossNameString = NTextUtil.getMobName((Entity)this);
                    TranslationTextComponent text = new TranslationTextComponent("nc.msg.bossmob.challenge", new Object[]{bossNameString, timeLimit});
                    IFormattableTextComponent bossname = ScorePlayerTeam.func_237500_a_((Team)this.func_96124_cp(), (ITextComponent)text).func_240700_a_(style -> style.func_240716_a_(this.func_174823_aP()).func_240714_a_(this.func_189512_bd()));
                    bossname.func_150256_b().func_240716_a_(this.func_174823_aP());
                    bossname.func_150256_b().func_240714_a_(this.func_189512_bd());
                    this.bossInfo.func_186739_a((ITextComponent)bossname);
                }
            } else {
                this.bossInfo.func_186739_a(this.func_145748_c_());
                this.challengeFlag = false;
            }
            --this.challengeCount;
        }
    }

    public String getChallengeCountString() {
        if (this.challengeFlag) {
            int sec = this.challengeCount / 20;
            int min = MathHelper.func_76125_a((int)(sec / 60), (int)0, (int)60);
            int formatSec = sec % 60 == 0 ? 0 : sec - min * 60;
            String timeLimit = min + ":" + String.format("%02d", formatSec);
            return timeLimit;
        }
        return "";
    }

    @Override
    public void setChallengeCount(int count) {
        if (!this.challengeFlag) {
            this.challengeFlag = true;
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.MAGIC_CHARGE_01, this.func_184176_by(), 2.0f, 0.8f);
            this.viewDuelMessage();
        }
        this.challengeCount = count;
    }

    public void viewDuelMessage() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(30.0);
        List list1 = this.field_70170_p.func_217357_a(PlayerEntity.class, axisalignedbb);
        String itemname = new ItemStack((IItemProvider)NCustomItem.CHALLENGER_GLOVE).func_200301_q().getString();
        if (!list1.isEmpty()) {
            for (PlayerEntity entityplayer : list1) {
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306b \u00a7e" + itemname + "\u00a7d \u304c \u30d2\u30c3\u30c8\u3057\u305f\uff01"), Util.field_240973_b_);
                entityplayer.func_145747_a((ITextComponent)new StringTextComponent("\u00a7d" + NTextUtil.getMobName((Entity)this) + " \u306f \u6c17\u304c\u5411\u3044\u305f\u306e\u304b \u3057\u3070\u3089\u304f\u5468\u8fba\u306b\u5c45\u5ea7\u308b\u3088\u3046\u3060\u3002"), Util.field_240973_b_);
            }
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_181015_d(BlockPos pos) {
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (!state.func_203425_a(Blocks.field_196553_aF) && !state.func_203425_a(Blocks.field_222434_lW)) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.challengeFlag;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected float func_189749_co() {
        return 0.99f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public static boolean getCanSpawnHere(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityOtsuRock.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && ((double)pos.func_177956_o() <= 90.0 && (double)pos.func_177956_o() > 40.0 && randomIn.nextInt(6) == 0 || (double)pos.func_177956_o() <= 40.0 && randomIn.nextInt(3) == 0) && EntityOtsuRock.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 0.4f);
    }

    protected SoundEvent func_184639_G() {
        return !this.getSleeping() ? CustomSound.OTSUROCK_LIVING : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187835_fT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    public boolean getSleeping() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getCanSeeJukebox() {
        return (Boolean)this.field_70180_af.func_187225_a(ON_JUKEBOX);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getRockBuster() {
        return (Boolean)this.field_70180_af.func_187225_a(ROCK_BUSTER);
    }

    public int getSleepingState() {
        return (Integer)this.field_70180_af.func_187225_a(WAKEUP_STATE);
    }

    public int getDancingState() {
        return (Integer)this.field_70180_af.func_187225_a(DANCING_STATE);
    }

    public int getBodyState() {
        return (Integer)this.field_70180_af.func_187225_a(BODY_STATE);
    }

    public int getBodyTime() {
        return (Integer)this.field_70180_af.func_187225_a(BODY_TIME);
    }

    public void setSleepingState(int state) {
        this.field_70180_af.func_187227_b(WAKEUP_STATE, (Object)state);
    }

    public void setBodyState(int state) {
        this.field_70180_af.func_187227_b(BODY_STATE, (Object)state);
    }

    public void setBodyTime(int state) {
        this.field_70180_af.func_187227_b(BODY_TIME, (Object)state);
    }
}

