/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.boss;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.entity.item.EntityCustomModelBulletBase;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NCustomDamageSource;
import otsunozi.nikkorihazard.util.NElements;

public class EntitySnowTyphoon
extends EntityCustomModelBulletBase {
    private boolean clientSideAttackStarted;
    private boolean sentSpikeEvent;
    private static final DataParameter<Boolean> PLEAYER_SHOOT = EntityDataManager.func_187226_a(EntitySnowTyphoon.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntitySnowTyphoon(EntityType<? extends EntitySnowTyphoon> p_i50170_1_, World world) {
        super((EntityType<? extends EntityCustomModelBulletBase>)p_i50170_1_, world);
    }

    public EntitySnowTyphoon(double posX, double posY, double posZ, double accelX, double accelY, double accelZ, World world) {
        super((EntityType<? extends EntityCustomModelBulletBase>)InitEntity.SNOW_TYPHOON, posX, posY, posZ, accelX, accelY, accelZ, world);
    }

    public EntitySnowTyphoon(World world, LivingEntity shooter, double accelX, double accelY, double accelZ, int flyTime, int damage) {
        super(InitEntity.SNOW_TYPHOON, shooter, accelX, accelY, accelZ, world, flyTime, damage);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)accelX, (double)accelZ) * 57.29577951308232);
    }

    public EntitySnowTyphoon(World world, LivingEntity shooter, double accelX, double accelY, double accelZ, int flyTime, int damage, float velocity) {
        super(InitEntity.SNOW_TYPHOON, shooter, accelX, accelY, accelZ, world, flyTime, damage, velocity);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)accelX, (double)accelZ) * 57.29577951308232);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLEAYER_SHOOT, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && !this.sentSpikeEvent) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            this.sentSpikeEvent = true;
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_(), this.func_226278_cu_() + (double)1.2f, this.func_226281_cx_(), (this.field_70146_Z.nextDouble() - 0.5) * 4.0, (this.field_70146_Z.nextDouble() - 0.5) * 4.0, (this.field_70146_Z.nextDouble() - 0.5) * 4.0);
            }
        }
        super.func_70071_h_();
        double motionX = NCMotion.getMotionX((Entity)this);
        double motionY = NCMotion.getMotionY((Entity)this);
        double motionZ = NCMotion.getMotionZ((Entity)this);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)motionX, (double)motionZ) * 57.29577951308232);
        float f4 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)motionY, (double)f4) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    @Override
    protected void func_213868_a(EntityRayTraceResult result) {
        if (result.func_216348_a().func_70097_a(NCustomDamageSource.causeIceDamage(this.func_234616_v_()), (float)this.damage)) {
            int knockbackStrength = NElements.isNonBoss(result.func_216348_a()) ? 3 : 1;
            float f1 = MathHelper.func_76133_a((double)(NCMotion.getMotionX((Entity)this) * NCMotion.getMotionX((Entity)this) + NCMotion.getMotionZ((Entity)this) * NCMotion.getMotionZ((Entity)this)));
            result.func_216348_a().func_70024_g(NCMotion.getMotionX((Entity)this) * (double)knockbackStrength * (double)0.6f / (double)f1, this.field_70146_Z.nextDouble() * 0.2 + 0.6, NCMotion.getMotionZ((Entity)this) * (double)knockbackStrength * (double)0.6f / (double)f1);
        }
    }

    public void func_181015_d(BlockPos pos) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float p_190550_1_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.getTicksInAir() - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_190550_1_) / 20.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197613_f;
    }

    public boolean getPlayerShoot() {
        return (Boolean)this.field_70180_af.func_187225_a(PLEAYER_SHOOT);
    }

    public void setPlayerShoot(boolean state) {
        this.field_70180_af.func_187227_b(PLEAYER_SHOOT, (Object)state);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("playershoot", this.getPlayerShoot());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPlayerShoot(compound.func_74767_n("playershoot"));
    }
}

