/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.boss;

import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import otsunozi.nikkorihazard.ai.EntityAIStomesBomerSwell;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.entity.boss.AbstractStorms;
import otsunozi.nikkorihazard.entity.boss.EntityIceTornado;
import otsunozi.nikkorihazard.util.NCMotion;

public class EntityStormsBomber
extends AbstractStorms {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 20;
    private int attackTimer;
    private boolean canfly;
    private boolean flying;
    private static final DataParameter<Boolean> N_POWERED = EntityDataManager.func_187226_a(EntityStormsBomber.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityStormsBomber.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityStormsBomber.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityStormsBomber(EntityType<? extends EntityStormsBomber> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIStomesBomerSwell(this));
        super.func_184651_r();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)0);
        this.field_70180_af.func_187214_a(N_POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.28).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233823_f_, 10.0);
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return NCustomCreatureAttribute.CCA_NIKKORI;
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    @Override
    public void func_70636_d() {
        if (this.attackTimer > 0 && !this.field_70729_aU) {
            --this.attackTimer;
            if (this.attackTimer == 20 && this.canfly && !this.field_70729_aU) {
                LivingEntity entity = this.func_70638_az();
                if (entity != null && this.func_70068_e((Entity)entity) >= 81.0) {
                    NCMotion.setMotionY((Entity)this, 0.5);
                    NCMotion.setMotionX((Entity)this, (this.field_70146_Z.nextDouble() - 0.5) * 1.5);
                    NCMotion.setMotionZ((Entity)this, (this.field_70146_Z.nextDouble() - 0.5) * 1.5);
                    this.flying = true;
                }
            } else if (this.flying && this.attackTimer <= 19 && this.attackTimer >= 15 && !this.field_70729_aU) {
                NCMotion.setMotionY((Entity)this, 0.5);
                NCMotion.setMultipliedMotionX((Entity)this, 1.1f);
                NCMotion.setMultipliedMotionZ((Entity)this, 1.1f);
            }
        } else {
            this.attackTimer = this.field_70146_Z.nextInt(100) + 100;
            this.canfly = this.field_70146_Z.nextInt(4) == 0;
            this.flying = false;
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setState(1);
            }
            if ((i = this.getState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getPowered()) {
                EntityIceTornado tornado = new EntityIceTornado(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_(), 2.2f, 1, (LivingEntity)this.getSummonner(), this.field_70146_Z.nextInt(4), this.field_70146_Z.nextInt(8), 10);
                this.field_70170_p.func_217376_c((Entity)tornado);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            } else {
                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
                this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.0f, false, flag ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
            }
            this.func_70656_aK();
            this.func_241204_bJ_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFlashIntensity(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(N_POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(N_POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public int getState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(N_POWERED);
    }

    public void setPowered(boolean state) {
        this.field_70180_af.func_187227_b(N_POWERED, (Object)state);
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }
}

