/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.boss;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.entity.item.bullet.EntityGigantWoodHammer;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.sound.CustomSound;

public class EntityTargetOfHammer
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 42;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private boolean powered;

    public EntityTargetOfHammer(EntityType<? extends EntityTargetOfHammer> p_i50170_1_, World p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public EntityTargetOfHammer(World worldIn, double x, double y, double z, float rotationYaw, int delayTick, LivingEntity casterIn, boolean powered) {
        this(InitEntity.TARGET_OF_HAMMER, worldIn);
        this.warmupDelayTicks = delayTick;
        this.setCaster(casterIn);
        this.field_70177_z = rotationYaw * 57.295776f;
        this.func_70107_b(x, y, z);
        this.powered = powered;
    }

    public void func_181015_d(BlockPos pos) {
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.warmupDelayTicks = compound.func_74762_e("Warmup");
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
        this.powered = compound.func_74767_n("powered");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
        compound.func_74757_a("powered", this.powered);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -38 && this.getCaster() != null) {
                EntityGigantWoodHammer hammer = new EntityGigantWoodHammer(this.field_70170_p, this.getCaster(), 0.0, -4.5, 0.0, 200, 14);
                hammer.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 20.0, this.func_226281_cx_());
                if (this.powered) {
                    hammer.setPowered(true);
                }
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187606_E, SoundCategory.BLOCKS, 3.0f, 1.0f / (this.field_70146_Z.nextFloat() * 1.2f) + 3.5f);
                this.field_70170_p.func_217376_c((Entity)hammer);
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORIMINATOR_ALERT, SoundCategory.BLOCKS, 0.4f, 1.0f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float p_190550_1_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_190550_1_) / 42.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBlightAnimationProgress() {
        if (!this.clientSideAttackStarted) {
            return 42;
        }
        return this.lifeTicks;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
    }
}

