/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityArrowLikeProjectileBase
extends ProjectileEntity {
    @Nullable
    public BlockState inBlockState;
    protected boolean inGround;
    protected int timeInGround;
    protected int maxTimeInGround = 200;
    public int arrowShake;
    public int ticksInGround;
    public float damage = 2.0f;
    public int knockbackStrength;
    private SoundEvent hitSound = this.getHitEntitySound();

    protected EntityArrowLikeProjectileBase(EntityType<? extends EntityArrowLikeProjectileBase> type, World worldIn) {
        super(type, worldIn);
    }

    protected EntityArrowLikeProjectileBase(EntityType<? extends EntityArrowLikeProjectileBase> type, double x, double y, double z, World worldIn) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
    }

    protected EntityArrowLikeProjectileBase(EntityType<? extends EntityArrowLikeProjectileBase> type, LivingEntity shooter, World worldIn, float damage) {
        this(type, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_(), worldIn);
        this.func_212361_a((Entity)shooter);
        this.damage = damage;
    }

    public void setHitSound(SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityArrowLikeProjectileBase.func_184183_bd()) * d0;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, velocity, inaccuracy);
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        super.func_70016_h(x, y, z);
        this.ticksInGround = 0;
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70071_h_();
        boolean flag = this.getNoClip();
        Vector3d vector3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntityArrowLikeProjectileBase.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround && !flag) {
            if (this.inBlockState != blockstate && this.func_234593_u_()) {
                this.func_234594_z_();
            } else if (!this.field_70170_p.field_72995_K) {
                this.despawn();
            }
            ++this.timeInGround;
        } else {
            EntityRayTraceResult entityraytraceresult;
            Vector3d vector3d3;
            this.timeInGround = 0;
            Vector3d vector3d2 = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vector3d3 = raytraceresult.func_216347_e();
            }
            if ((entityraytraceresult = this.rayTraceEntities(vector3d2, vector3d3)) != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                Entity entity1 = this.func_234616_v_();
                if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a((RayTraceResult)raytraceresult);
                this.field_70160_al = true;
            }
            vector3d = this.func_213322_ci();
            double d3 = vector3d.field_72450_a;
            double d4 = vector3d.field_72448_b;
            double d0 = vector3d.field_72449_c;
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)EntityArrowLikeProjectileBase.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            this.field_70125_A = EntityArrowLikeProjectileBase.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = EntityArrowLikeProjectileBase.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            float f2 = this.getMotionDecay();
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.getWaterDrag();
            }
            this.func_213317_d(vector3d.func_186678_a((double)f2));
            if (!this.func_189652_ae() && !flag) {
                Vector3d vector3d4 = this.func_213322_ci();
                this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b - (double)0.05f, vector3d4.field_72449_c);
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)result);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            this.func_230299_a_((BlockRayTraceResult)result);
        }
    }

    public float getMotionDecay() {
        return 0.99f;
    }

    private boolean func_234593_u_() {
        return this.inGround && this.field_70170_p.func_226664_a_(new AxisAlignedBB(this.func_213303_ch(), this.func_213303_ch()).func_186662_g(0.06));
    }

    private void func_234594_z_() {
        this.inGround = false;
        Vector3d vector3d = this.func_213322_ci();
        this.func_213317_d(vector3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        this.ticksInGround = 0;
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
        if (typeIn != MoverType.SELF && this.func_234593_u_()) {
            this.func_234594_z_();
        }
    }

    protected void despawn() {
        ++this.ticksInGround;
        if (this.ticksInGround >= this.maxTimeInGround) {
            this.func_70106_y();
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        super.func_213868_a(result);
        Entity entity = result.func_216348_a();
        Entity entity1 = this.func_234616_v_();
        if (entity1 != null && entity1 instanceof LivingEntity) {
            ((LivingEntity)entity1).func_130011_c(entity);
        }
        this.func_70106_y();
        if (this.damage(entity, entity1)) {
            if (entity instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockbackStrength > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
            }
            this.func_184185_a(this.hitSound, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        } else {
            this.notDamage();
        }
    }

    public abstract boolean damage(Entity var1, @Nullable Entity var2);

    public void notDamage() {
        this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
        this.field_70177_z += 180.0f;
        this.field_70126_B += 180.0f;
        if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
            this.func_70106_y();
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        this.inBlockState = this.field_70170_p.func_180495_p(result.func_216350_a());
        super.func_230299_a_(result);
        Vector3d vector3d = result.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        this.func_184185_a(this.getHitGroundSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.arrowShake = 7;
        this.setHitSound(SoundEvents.field_187731_t);
    }

    protected SoundEvent getHitEntitySound() {
        return SoundEvents.field_187731_t;
    }

    protected final SoundEvent getHitGroundSound() {
        return this.hitSound;
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), arg_0 -> ((EntityArrowLikeProjectileBase)this).func_230298_a_(arg_0));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("life", (short)this.ticksInGround);
        if (this.inBlockState != null) {
            compound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.inBlockState));
        }
        compound.func_74774_a("shake", (byte)this.arrowShake);
        compound.func_74757_a("inGround", this.inGround);
        compound.func_74776_a("damage", this.damage);
        compound.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c((Object)this.hitSound).toString());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.ticksInGround = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.inBlockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        this.arrowShake = compound.func_74771_c("shake") & 0xFF;
        this.inGround = compound.func_74767_n("inGround");
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74760_g("damage");
        }
        if (compound.func_150297_b("SoundEvent", 8)) {
            this.hitSound = Registry.field_212633_v.func_241873_b(new ResourceLocation(compound.func_74779_i("SoundEvent"))).orElse(this.getHitEntitySound());
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void setDamage(float damageIn) {
        this.damage = damageIn;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.13f;
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    public boolean getNoClip() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return false;
    }
}

