/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NCustomDamageSource;
import otsunozi.nikkorihazard.util.NMagicWeaponUtil;

public class EntityCustomLightning
extends Entity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private boolean effectOnly = false;
    private boolean damageandsound = true;
    private boolean damagenotpassarmor;
    private float soundVol = 3.0f;
    private int damage = 5;
    private int criticalChance = 0;
    private int wideburnlevel = 0;
    private boolean onceCritical;
    public LivingEntity shootingEntity;
    private boolean safetymagic;
    private boolean isMagic;

    public EntityCustomLightning(EntityType<? extends EntityCustomLightning> p_i231491_1_, World world) {
        super(p_i231491_1_, world);
        this.field_70158_ak = true;
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
    }

    public EntityCustomLightning(EntityType<? extends EntityCustomLightning> p_i231491_1_, World world, boolean damageandsound) {
        this(p_i231491_1_, world);
        this.damageandsound = damageandsound;
    }

    public EntityCustomLightning(EntityType<? extends EntityCustomLightning> p_i231491_1_, World world, LivingEntity shooter, boolean effectOnlyIn, int damage) {
        this(p_i231491_1_, world, true);
        this.damage = damage;
        this.shootingEntity = shooter;
    }

    public EntityCustomLightning(EntityType<? extends EntityCustomLightning> p_i231491_1_, World worldIn, LivingEntity shooter, boolean effectOnlyIn, int damage, float soundVol) {
        this(p_i231491_1_, worldIn, shooter, effectOnlyIn, damage);
        this.soundVol = soundVol;
    }

    public EntityCustomLightning(EntityType<? extends EntityCustomLightning> p_i231491_1_, World worldIn, LivingEntity shooter, boolean effectOnlyIn, int damage, float soundVol, boolean damagenotpassarmor) {
        this(p_i231491_1_, worldIn, shooter, effectOnlyIn, damage);
        this.soundVol = soundVol;
        this.damagenotpassarmor = damagenotpassarmor;
    }

    public EntityCustomLightning(EntityType<? extends EntityCustomLightning> p_i231491_1_, World worldIn, LivingEntity shooter, boolean effectOnlyIn, int damage, float soundVol, boolean damagenotpassarmor, boolean safetyMagic) {
        this(p_i231491_1_, worldIn, shooter, effectOnlyIn, damage);
        this.damagenotpassarmor = damagenotpassarmor;
        this.safetymagic = safetyMagic;
    }

    public void setEffectOnly(boolean effectOnly) {
        this.effectOnly = effectOnly;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void setCriticalChance(int chance) {
        this.criticalChance = chance;
    }

    public void setMagic() {
        this.isMagic = true;
    }

    public void setWideburnLevel(int level) {
        this.wideburnlevel = level;
    }

    public void setOnceCritical(boolean isCritical) {
        this.onceCritical = isCritical;
    }

    public void setDamageAndSound(boolean damageandsound) {
        this.damageandsound = damageandsound;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lightningState == 2 && this.damageandsound && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.MAGIC_LIGHTNING_01, SoundCategory.HOSTILE, this.soundVol, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.field_70146_Z.nextLong();
            }
        }
        if (this.lightningState >= 0) {
            if (!(this.field_70170_p instanceof ServerWorld)) {
                this.field_70170_p.func_225605_c_(2);
            } else if (!this.effectOnly && this.damageandsound) {
                double d0 = 3.0 + (double)((float)this.wideburnlevel * 0.75f);
                List list = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - d0, this.func_226278_cu_() - 3.0, this.func_226281_cx_() - d0, this.func_226277_ct_() + d0, this.func_226278_cu_() + 6.0 + 3.0, this.func_226281_cx_() + d0), Entity::func_70089_S);
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (entity instanceof ItemEntity || NMagicWeaponUtil.safetyTargetJudge(this.safetymagic, entity)) continue;
                    boolean isCritical = false;
                    int trueDamage = this.damage;
                    if (!this.field_70170_p.field_72995_K && (this.onceCritical || NCustomDamageSource.criticalJudge(this.criticalChance))) {
                        trueDamage = this.damage * 2;
                        isCritical = true;
                    }
                    boolean damageFlag = false;
                    damageFlag = this.shootingEntity != null ? (this.damagenotpassarmor ? entity.func_70097_a(NCustomDamageSource.causeNotpassThunderDamage((Entity)this.shootingEntity), (float)trueDamage) : (this.isMagic ? entity.func_70097_a(NCustomDamageSource.causeMagicThunderDamage((Entity)this.shootingEntity, this), (float)trueDamage) : entity.func_70097_a(NCustomDamageSource.causeThunderDamage((Entity)this.shootingEntity), (float)trueDamage))) : (this.damagenotpassarmor ? entity.func_70097_a(NCustomDamageSource.CDS_NOTPASS_THUNDER, (float)trueDamage) : entity.func_70097_a(NCustomDamageSource.CDS_THUNDER, (float)trueDamage));
                    if (!isCritical || !damageFlag) continue;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                }
                this.onceCritical = false;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            // empty if block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * EntityCustomLightning.func_184183_bd();
        return distance < d0 * d0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("soundVol", 99)) {
            this.soundVol = compound.func_74760_g("soundVol");
        }
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74762_e("damage");
        }
        if (compound.func_150297_b("notpass", 99)) {
            this.damagenotpassarmor = compound.func_74767_n("notpass");
        }
        if (compound.func_150297_b("isMagic", 99)) {
            this.isMagic = compound.func_74767_n("isMagic");
        }
        if (compound.func_150297_b("criticalchance", 99)) {
            this.criticalChance = compound.func_74762_e("criticalchance");
        }
        if (compound.func_150297_b("wideburnlevel", 99)) {
            this.wideburnlevel = compound.func_74762_e("wideburnlevel");
        }
        this.safetymagic = compound.func_74767_n("safety");
        this.damageandsound = compound.func_74767_n("damageandsound");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a("soundVol", this.soundVol);
        compound.func_74757_a("notpass", this.damagenotpassarmor);
        compound.func_74768_a("damage", this.damage);
        compound.func_74768_a("criticalchance", this.criticalChance);
        compound.func_74768_a("wideburnlevel", this.wideburnlevel);
        compound.func_74757_a("safety", this.safetymagic);
        compound.func_74757_a("damageandsound", this.damageandsound);
        compound.func_74757_a("isMagic", this.isMagic);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

