/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityNogravityProjectileBase
extends DamagingProjectileEntity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityNogravityProjectileBase.class, (IDataSerializer)DataSerializers.field_187196_f);
    protected int flytime;

    public EntityNogravityProjectileBase(EntityType<? extends EntityNogravityProjectileBase> magicEntityType, World world) {
        super(magicEntityType, world);
    }

    public EntityNogravityProjectileBase(EntityType<? extends EntityNogravityProjectileBase> magicEntityType, double posX, double posY, double posZ, double accelX, double accelY, double accelZ, World world) {
        super(magicEntityType, posX, posY, posZ, accelX, accelY, accelZ, world);
    }

    public EntityNogravityProjectileBase(EntityType<? extends EntityNogravityProjectileBase> magicEntityType, LivingEntity shooter, double accelX, double accelY, double accelZ, World world, int flyTime) {
        super(magicEntityType, shooter, accelX, accelY, accelZ, world);
        this.flytime = flyTime;
    }

    public EntityNogravityProjectileBase(EntityType<? extends EntityNogravityProjectileBase> magicEntityType, LivingEntity shooter, double accelX, double accelY, double accelZ, World world, int flyTime, float velocity) {
        this(magicEntityType, shooter, accelX, accelY, accelZ, world, flyTime);
        float f = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        accelX /= (double)f;
        accelY /= (double)f;
        accelZ /= (double)f;
        this.func_213293_j((accelX *= (double)velocity) * 0.2, (accelY *= (double)velocity) * 0.2, (accelZ *= (double)velocity) * 0.2);
    }

    public boolean func_70067_L() {
        return false;
    }

    public void setStack(ItemStack item) {
        if (item.func_77973_b() != Items.field_151059_bz || item.func_77942_o()) {
            this.func_184212_Q().func_187227_b(STACK, Util.func_200696_a((Object)item.func_77946_l(), p_213897_0_ -> p_213897_0_.func_190920_e(1)));
        }
    }

    protected ItemStack getStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(STACK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        ItemStack itemstack = this.getStack();
        return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_190931_a) : itemstack;
    }

    public void func_70071_h_() {
        Entity entity = this.func_234616_v_();
        if (this.field_70170_p.field_72995_K || (entity == null || !entity.field_70128_L) && this.field_70170_p.func_175667_e(this.func_233580_cy_())) {
            if (!this.field_234611_d_) {
                this.field_234611_d_ = this.func_234615_h_();
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70052_a(6, this.func_225510_bt_());
            }
            this.func_70030_z();
            RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((EntityNogravityProjectileBase)this).func_230298_a_(arg_0));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            this.func_145775_I();
            Vector3d vector3d = this.func_213322_ci();
            double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
            double d1 = this.func_226278_cu_() + vector3d.field_72448_b;
            double d2 = this.func_226281_cx_() + vector3d.field_72449_c;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            float f = this.func_82341_c();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vector3d.field_72450_a * 0.25, d1 - vector3d.field_72448_b * 0.25, d2 - vector3d.field_72449_c * 0.25, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                }
                f = 0.8f;
            }
            this.func_213317_d(vector3d.func_72441_c(this.field_70232_b, this.field_70233_c, this.field_70230_d).func_186678_a((double)f));
            this.spawnProjectileParticle(d0, d1, d2);
            this.func_70107_b(d0, d1, d2);
        } else {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.flytime-- <= 0) {
            this.func_70106_y();
        }
    }

    private boolean func_234615_h_() {
        Entity entity = this.func_234616_v_();
        if (entity != null) {
            for (Entity entity1 : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_234613_0_ -> !p_234613_0_.func_175149_v() && p_234613_0_.func_70067_L())) {
                if (entity1.func_184208_bv() != entity.func_184208_bv()) continue;
                return false;
            }
        }
        return true;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197614_g;
    }

    protected void spawnProjectileParticle(double posX, double posY, double posZ) {
        this.field_70170_p.func_195594_a(this.func_195057_f(), posX, posY + 0.5, posZ, 0.0, 0.0, 0.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(STACK, (Object)ItemStack.field_190927_a);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack itemstack = this.getStack();
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("Item", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74768_a("flytime", this.flytime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        this.setStack(itemstack);
        this.flytime = compound.func_74762_e("flytime");
    }
}

