/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.entity.NCustomCreatureAttribute;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.util.NElements;

public class EntityPoisonFang
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    private int damage = 7;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;

    public EntityPoisonFang(EntityType<? extends EntityPoisonFang> p_i50170_1_, World p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public EntityPoisonFang(World worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn) {
        this(InitEntity.POISON_FANG, worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.field_70177_z = p_i47276_8_ * 57.295776f;
        this.func_70107_b(x, y, z);
    }

    public void func_181015_d(BlockPos pos) {
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.warmupDelayTicks = compound.func_74762_e("Warmup");
        this.damage = compound.func_74762_e("Damage");
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Warmup", this.warmupDelayTicks);
        compound.func_74768_a("Damage", this.damage);
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                        double d1 = this.func_226278_cu_() + 0.05 + this.field_70146_Z.nextDouble() * 1.0;
                        double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                        double d3 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.field_70146_Z.nextDouble() * 0.3;
                        double d5 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
    }

    private void damage(LivingEntity p_190551_1_) {
        LivingEntity entitylivingbase = this.getCaster();
        if (p_190551_1_.func_70089_S() && !p_190551_1_.func_190530_aW() && p_190551_1_ != entitylivingbase) {
            if (entitylivingbase == null && NElements.isNonBoss((Entity)p_190551_1_) && p_190551_1_.func_70668_bt() != NCustomCreatureAttribute.CCA_WICKED) {
                if (p_190551_1_.func_70097_a(DamageSource.field_76376_m, (float)this.damage)) {
                    p_190551_1_.func_195064_c(new EffectInstance(Effects.field_76421_d, 120, 0));
                    p_190551_1_.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 0));
                }
            } else {
                if (entitylivingbase != null && (entitylivingbase.func_184191_r((Entity)p_190551_1_) || !NElements.isNonBoss((Entity)p_190551_1_) || p_190551_1_.func_70668_bt() == NCustomCreatureAttribute.CCA_WICKED)) {
                    return;
                }
                if (p_190551_1_.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)entitylivingbase), (float)this.damage)) {
                    p_190551_1_.func_195064_c(new EffectInstance(Effects.field_76421_d, 120, 0));
                    p_190551_1_.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 0));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191242_bl, SoundCategory.HOSTILE, 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 1.0f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float p_190550_1_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_190550_1_) / 20.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
    }
}

