/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.entity.EntityNikkoriStoneman;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NCustomDamageSource;

public class EntityStoneTrap
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private boolean canPlayerDamage = true;
    private boolean canSlow = false;
    private int lifeTicks = 50;
    private int damage = 5;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;

    public EntityStoneTrap(EntityType<? extends EntityStoneTrap> p_i50170_1_, World p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public EntityStoneTrap(World worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn) {
        this(InitEntity.STONE_TRAP, worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.field_70177_z = p_i47276_8_ * 57.295776f;
        this.func_70107_b(x, y, z);
    }

    public EntityStoneTrap(World worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn, int damage) {
        this(worldIn, x, y, z, p_i47276_8_, p_i47276_9_, casterIn);
        this.damage = damage;
        this.canPlayerDamage = false;
        this.canSlow = true;
    }

    public void func_181015_d(BlockPos pos) {
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.warmupDelayTicks = compound.func_74762_e("Warmup");
        this.damage = compound.func_74762_e("Damage");
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Warmup", this.warmupDelayTicks);
        compound.func_74768_a("Damage", this.damage);
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks <= 40 && this.lifeTicks >= 17) {
                    for (int i = 0; i < 3; ++i) {
                        double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                        double d1 = this.func_226278_cu_() - 1.0 + this.field_70146_Z.nextDouble();
                        double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                        double d3 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.field_70146_Z.nextDouble() * 0.3;
                        double d5 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                        this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150347_e.func_176223_P()), d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks <= -36 && this.warmupDelayTicks >= -38) {
                for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
    }

    private void damage(LivingEntity p_190551_1_) {
        LivingEntity entitylivingbase = this.getCaster();
        if (p_190551_1_.func_70089_S() && !p_190551_1_.func_190530_aW() && !(p_190551_1_ instanceof EntityNikkoriStoneman) && (this.canPlayerDamage || !this.canPlayerDamage && !(p_190551_1_ instanceof PlayerEntity))) {
            if (entitylivingbase == null) {
                if (p_190551_1_.func_70097_a(NCustomDamageSource.CDS_STONETRAP, (float)this.damage) && this.canSlow) {
                    p_190551_1_.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 1));
                }
            } else {
                if (entitylivingbase != null && entitylivingbase.func_184191_r((Entity)p_190551_1_)) {
                    return;
                }
                if (p_190551_1_.func_70097_a(NCustomDamageSource.causeStoneTrapDamage((Entity)entitylivingbase), (float)this.damage) && this.canSlow) {
                    p_190551_1_.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 1));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), CustomSound.NIKKORICOBBLEMAN_TRAP, SoundCategory.BLOCKS, 1.0f, this.field_70146_Z.nextFloat() * 0.1f + 1.0f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float p_190550_1_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_190550_1_) / 30.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
    }
}

