/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item.bullet;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.entity.item.EntityCustomModelBulletBase;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.util.NCMotion;
import otsunozi.nikkorihazard.util.NCustomDamageSource;

public class EntityWoodMissile
extends EntityCustomModelBulletBase {
    private boolean clientSideAttackStarted;
    private boolean sentSpikeEvent;
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityWoodMissile.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityWoodMissile(EntityType<? extends EntityWoodMissile> p_i50170_1_, World world) {
        super((EntityType<? extends EntityCustomModelBulletBase>)p_i50170_1_, world);
    }

    public EntityWoodMissile(double posX, double posY, double posZ, double accelX, double accelY, double accelZ, World world) {
        super((EntityType<? extends EntityCustomModelBulletBase>)InitEntity.WOOD_MISSILE, posX, posY, posZ, accelX, accelY, accelZ, world);
    }

    public EntityWoodMissile(World world, LivingEntity shooter, double accelX, double accelY, double accelZ, int flyTime, int damage) {
        super(InitEntity.WOOD_MISSILE, shooter, accelX, accelY, accelZ, world, flyTime, damage);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)accelX, (double)accelZ) * 57.29577951308232);
    }

    public EntityWoodMissile(World world, LivingEntity shooter, double accelX, double accelY, double accelZ, int flyTime, int damage, float velocity) {
        super(InitEntity.WOOD_MISSILE, shooter, accelX, accelY, accelZ, world, flyTime, damage, velocity);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)accelX, (double)accelZ) * 57.29577951308232);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && !this.sentSpikeEvent) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            this.sentSpikeEvent = true;
        }
        super.func_70071_h_();
        double motionX = NCMotion.getMotionX((Entity)this);
        double motionY = NCMotion.getMotionY((Entity)this);
        double motionZ = NCMotion.getMotionZ((Entity)this);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)motionX, (double)motionZ) * 57.29577951308232);
        float f4 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)motionY, (double)f4) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    @Override
    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.func_234616_v_());
            this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), 2.0f, false, flag ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                entity.func_70097_a(NCustomDamageSource.causeWoodSPDamage((Entity)this, this.func_234616_v_()), (float)this.damage);
            }
        }
        this.func_70106_y();
    }

    public void func_181015_d(BlockPos pos) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float p_190550_1_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.getTicksInAir() - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_190550_1_) / 20.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197601_L;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setPowered(boolean state) {
        this.field_70180_af.func_187227_b(POWERED, (Object)state);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("powered", this.getPowered());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPowered(compound.func_74767_n("powered"));
    }
}

