/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item.magic;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import otsunozi.nikkorihazard.entity.item.EntityNogravityProjectileBase;
import otsunozi.nikkorihazard.util.NCustomParticleSpawner;
import otsunozi.nikkorihazard.util.NMagicWeaponUtil;

public abstract class EntityMagicBulletBase
extends EntityNogravityProjectileBase {
    protected int magicdamage = 1;
    protected int criticalChance = 0;
    protected boolean canBounds = false;
    protected boolean safetymagic = false;

    public EntityMagicBulletBase(EntityType<? extends EntityMagicBulletBase> magicEntityType, World world) {
        super(magicEntityType, world);
    }

    public EntityMagicBulletBase(EntityType<? extends EntityMagicBulletBase> magicEntityType, double posX, double posY, double posZ, double accelX, double accelY, double accelZ, World world) {
        super(magicEntityType, posX, posY, posZ, accelX, accelY, accelZ, world);
    }

    public EntityMagicBulletBase(EntityType<? extends EntityMagicBulletBase> magicEntityType, LivingEntity shooter, double accelX, double accelY, double accelZ, World world, int flyTime, int damage) {
        super(magicEntityType, shooter, accelX, accelY, accelZ, world, flyTime);
        this.magicdamage = damage;
    }

    public EntityMagicBulletBase(EntityType<? extends EntityMagicBulletBase> magicEntityType, LivingEntity shooter, double accelX, double accelY, double accelZ, World world, int flyTime, int damage, float velocity) {
        super(magicEntityType, shooter, accelX, accelY, accelZ, world, flyTime, velocity);
        this.func_213293_j(accelY * (double)velocity, accelY * (double)velocity, accelZ * (double)velocity);
        this.magicdamage = damage;
    }

    public EntityMagicBulletBase(EntityType<? extends EntityMagicBulletBase> magicEntityType, LivingEntity shooter, double accelX, double accelY, double accelZ, World world, int flyTime, int damage, float velocity, boolean canBounds, int criticalChance, boolean safetyMagic) {
        super(magicEntityType, shooter, accelX, accelY, accelZ, world, flyTime, velocity);
        this.magicdamage = damage;
        this.criticalChance = criticalChance;
        this.safetymagic = safetyMagic;
        this.canBounds = canBounds;
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        if (this.field_70170_p instanceof ServerWorld) {
            if (this.canBounds) {
                Direction side = result.func_216354_b();
                if (side != null) {
                    this.func_70018_K();
                    Vector3d vec = this.func_213322_ci();
                    double d1 = vec.field_72450_a;
                    double d2 = vec.field_72448_b;
                    double d3 = vec.field_72449_c;
                    double d0 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3));
                    switch (side) {
                        case DOWN: {
                            this.func_213293_j(d1, d2 * -1.0, d3);
                            this.field_70232_b = d1 / d0 * 0.1;
                            this.field_70233_c = d2 / d0 * 0.1;
                            this.field_70230_d = d3 / d0 * 0.1;
                            break;
                        }
                        case UP: {
                            this.func_213293_j(d1, d2 * -1.0, d3);
                            this.field_70232_b = d1 / d0 * 0.1;
                            this.field_70233_c = d2 / d0 * 0.1;
                            this.field_70230_d = d3 / d0 * 0.1;
                            break;
                        }
                        case WEST: {
                            this.func_213293_j(d1 * -1.0, d2, d3);
                            this.field_70232_b = d1 / d0 * 0.1;
                            this.field_70233_c = d2 / d0 * 0.1;
                            this.field_70230_d = d3 / d0 * 0.1;
                            break;
                        }
                        case EAST: {
                            this.func_213293_j(d1 * -1.0, d2, d3);
                            this.field_70232_b = d1 / d0 * 0.1;
                            this.field_70233_c = d2 / d0 * 0.1;
                            this.field_70230_d = d3 / d0 * 0.1;
                            break;
                        }
                        case NORTH: {
                            this.func_213293_j(d1, d2, d3 * -1.0);
                            this.field_70232_b = d1 / d0 * 0.1;
                            this.field_70233_c = d2 / d0 * 0.1;
                            this.field_70230_d = d3 / d0 * 0.1;
                            break;
                        }
                        case SOUTH: {
                            this.func_213293_j(d1, d2, d3 * -1.0);
                            this.field_70232_b = d1 / d0 * 0.1;
                            this.field_70233_c = d2 / d0 * 0.1;
                            this.field_70230_d = d3 / d0 * 0.1;
                        }
                    }
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        if (this.field_70170_p instanceof ServerWorld && p_213868_1_.func_216348_a() != null) {
            if (!(p_213868_1_.func_216348_a() instanceof LivingEntity)) {
                return;
            }
            if (NMagicWeaponUtil.safetyTargetJudge(this.safetymagic, p_213868_1_.func_216348_a())) {
                return;
            }
            this.onEntityHitDamage(p_213868_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            NCustomParticleSpawner.spawnMagicCriticalParticle((Entity)this, this.field_70146_Z);
        }
    }

    @Override
    protected abstract IParticleData func_195057_f();

    @Override
    protected void spawnProjectileParticle(double posX, double posY, double posZ) {
        this.field_70170_p.func_195594_a(this.func_195057_f(), posX, posY, posZ, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, (this.field_70146_Z.nextDouble() - 0.5) * 0.7, (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
    }

    protected abstract void onEntityHitDamage(EntityRayTraceResult var1);

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack itemstack = this.getStack();
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("Item", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74768_a("damage", this.magicdamage);
        compound.func_74768_a("criticalChance", this.criticalChance);
        compound.func_74757_a("canBounds", this.canBounds);
        compound.func_74757_a("safetymagic", this.safetymagic);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        this.setStack(itemstack);
        this.magicdamage = compound.func_74762_e("damage");
        this.criticalChance = compound.func_74762_e("criticalChance");
        this.canBounds = compound.func_74767_n("canBounds");
        this.safetymagic = compound.func_74767_n("safetymagic");
    }
}

