/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item.magic;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.init.InitEntity;
import otsunozi.nikkorihazard.util.NCustomDamageSource;
import otsunozi.nikkorihazard.util.NCustomParticleSpawner;
import otsunozi.nikkorihazard.util.NMagicWeaponUtil;

public class EntityPlosionMagicAura
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private final int maxLifeTicks = 20;
    private int lifeTicks = 20;
    private int damage = 2;
    private LivingEntity caster;
    private UUID casterUuid;
    private int criticalChance = 0;
    private boolean safetymagic;
    private static final DataParameter<Boolean> ATTACK_START = EntityDataManager.func_187226_a(EntityPlosionMagicAura.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityPlosionMagicAura(EntityType<? extends EntityPlosionMagicAura> p_i50170_1_, World p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public EntityPlosionMagicAura(World worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn) {
        this(InitEntity.PLOSIONMAGIC_AURA, worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.field_70177_z = p_i47276_8_ * 57.295776f;
        this.func_70107_b(x, y, z);
    }

    public EntityPlosionMagicAura(World worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn, int damage, int criticalChance, boolean safetyMagic) {
        this(worldIn, x, y, z, p_i47276_8_, p_i47276_9_, casterIn);
        this.damage = damage;
        this.criticalChance = criticalChance;
        this.safetymagic = safetyMagic;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ATTACK_START, (Object)false);
    }

    public void func_181015_d(BlockPos pos) {
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.warmupDelayTicks = compound.func_74762_e("Warmup");
        this.damage = compound.func_74762_e("Damage");
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
        this.lifeTicks = compound.func_74762_e("LifeTicks");
        if (compound.func_150297_b("criticalchance", 99)) {
            this.criticalChance = compound.func_74762_e("criticalchance");
        }
        this.safetymagic = compound.func_74767_n("safety");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Warmup", this.warmupDelayTicks);
        compound.func_74768_a("Damage", this.damage);
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
        compound.func_74768_a("MaxLifeTicks", this.maxLifeTicks);
        compound.func_74768_a("LifeTicks", this.lifeTicks);
        compound.func_74768_a("criticalchance", this.criticalChance);
        compound.func_74757_a("safety", this.safetymagic);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.setAttacking(true);
        if (this.field_70170_p.field_72995_K) {
            if (this.getAttackState()) {
                --this.lifeTicks;
                if (this.lifeTicks > 5) {
                    for (int i = 0; i < 10; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.8, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * 2.8, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.8, (this.field_70146_Z.nextDouble() - 0.5) * 0.3, this.field_70146_Z.nextDouble() * 0.05, (this.field_70146_Z.nextDouble() - 0.5) * 0.3);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            if (this.warmupDelayTicks % 9 == 0 && this.warmupDelayTicks >= -this.maxLifeTicks) {
                List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.95, 1.0, 0.95));
                for (LivingEntity entitylivingbase : list) {
                    if (NMagicWeaponUtil.safetyTargetJudge(this.safetymagic, (Entity)entitylivingbase)) continue;
                    this.damage(entitylivingbase);
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
    }

    private void damage(LivingEntity target) {
        LivingEntity entitylivingbase = this.getCaster();
        if (target.func_70089_S() && !target.func_190530_aW()) {
            boolean isCritical = false;
            boolean successAttack = false;
            int trueMagicDamage = this.damage;
            if (NCustomDamageSource.criticalJudge(this.criticalChance)) {
                trueMagicDamage = (int)((float)trueMagicDamage * 2.0f);
                isCritical = true;
            }
            if (entitylivingbase != null && entitylivingbase.func_184191_r((Entity)target)) {
                return;
            }
            successAttack = target.func_70097_a(NCustomDamageSource.causeMagicFireDamage((Entity)this.caster, this), (float)trueMagicDamage);
            if (successAttack && isCritical) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)8);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.setAttacking(true);
        } else if (id == 8) {
            NCustomParticleSpawner.spawnMagicCriticalParticle(this, this.field_70146_Z);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean getAttackState() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACK_START);
    }

    public void setAttacking(boolean state) {
        this.field_70180_af.func_187227_b(ATTACK_START, (Object)state);
    }
}

