/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.item.magic;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import otsunozi.nikkorihazard.entity.item.magic.EntityMagicBulletBase;
import otsunozi.nikkorihazard.entity.item.magic.ISpecialRenderMagic;
import otsunozi.nikkorihazard.init.NCustomEffect;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NElements;

public class EntitySkeletonMagic
extends EntityMagicBulletBase
implements ISpecialRenderMagic {
    private static final DataParameter<Boolean> CRITICAL = EntityDataManager.func_187226_a(EntitySkeletonMagic.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntitySkeletonMagic(EntityType<? extends EntitySkeletonMagic> p_i50170_1_, World world) {
        super((EntityType<? extends EntityMagicBulletBase>)p_i50170_1_, world);
    }

    public EntitySkeletonMagic(EntityType<? extends EntityMagicBulletBase> entitytype, double posX, double posY, double posZ, double accelX, double accelY, double accelZ, World world) {
        super(entitytype, posX, posY, posZ, accelX, accelY, accelZ, world);
    }

    public EntitySkeletonMagic(EntityType<? extends EntityMagicBulletBase> entitytype, World world, LivingEntity shooter, double accelX, double accelY, double accelZ, int flyTime, int damage, float velocity) {
        this(entitytype, world, shooter, accelX, accelY, accelZ, flyTime, damage, velocity, false, 0, false);
    }

    public EntitySkeletonMagic(EntityType<? extends EntityMagicBulletBase> entitytype, World world, LivingEntity shooter, double accelX, double accelY, double accelZ, int flyTime, int damage, float velocity, boolean canBounds, int criticalChance, boolean safetyMagic) {
        super(entitytype, shooter, accelX, accelY, accelZ, world, flyTime, damage, velocity, canBounds, criticalChance, safetyMagic);
        this.setStack(new ItemStack((IItemProvider)Items.field_151123_aH));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CRITICAL, (Object)false);
    }

    @Override
    protected void onEntityHitDamage(EntityRayTraceResult result) {
        LivingEntity living;
        boolean livingflag = false;
        boolean attackSuccess = true;
        if (result.func_216348_a() instanceof LivingEntity) {
            livingflag = true;
        }
        if (livingflag && (living = (LivingEntity)result.func_216348_a()).func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == NCustomItem.GREENSKULL_EARRINGS) {
            living.func_130014_f_().func_184148_a((PlayerEntity)null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), CustomSound.ATTACK_TARGET_01, SoundCategory.BLOCKS, 0.4f, 2.4f);
            attackSuccess = false;
        }
        if (attackSuccess) {
            boolean isPlayerShoot;
            boolean isCritical = this.getCritical();
            int trueDamage = this.magicdamage;
            boolean bl = isPlayerShoot = this.func_234616_v_() != null && this.func_234616_v_() instanceof PlayerEntity;
            if (isCritical) {
                trueDamage = (int)((float)trueDamage * 2.0f);
            }
            if (result.func_216348_a().func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.func_234616_v_()), (float)trueDamage)) {
                LivingEntity living2;
                if (isCritical && isPlayerShoot) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                }
                if (livingflag && NElements.isNonBoss((Entity)(living2 = (LivingEntity)result.func_216348_a()))) {
                    this.setMagicEffect(living2, isPlayerShoot);
                }
            }
        }
        this.func_70106_y();
    }

    public void setMagicEffect(LivingEntity living, boolean isPlayerShoot) {
        int magicCategory = this.field_70146_Z.nextInt(17);
        switch (magicCategory) {
            case 0: 
            case 1: {
                living.func_195064_c(new EffectInstance(Effects.field_76421_d, isPlayerShoot ? 400 : 240, 0));
                break;
            }
            case 2: 
            case 3: {
                living.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0));
                break;
            }
            case 4: 
            case 5: {
                living.func_195064_c(new EffectInstance(Effects.field_76437_t, isPlayerShoot ? 400 : 240, 0));
                break;
            }
            case 6: 
            case 7: {
                living.func_195064_c(new EffectInstance(Effects.field_189112_A, 600, 1));
                break;
            }
            case 8: 
            case 9: {
                living.func_195064_c(new EffectInstance(Effects.field_76436_u, isPlayerShoot ? 200 : 80, 0));
                break;
            }
            case 10: {
                living.func_195064_c(new EffectInstance(Effects.field_76428_l, isPlayerShoot ? 220 : 110, 1));
                break;
            }
            case 11: {
                living.func_195064_c(new EffectInstance(NCustomEffect.EFFECT_DEFENCEDOWN, 200, 0));
                break;
            }
            case 12: 
            case 13: {
                living.func_195064_c(new EffectInstance(Effects.field_76438_s, 240, 0));
                break;
            }
            case 14: 
            case 15: {
                living.func_195064_c(new EffectInstance(Effects.field_82731_v, isPlayerShoot ? 200 : 120, 0));
                break;
            }
            case 16: {
                living.func_195064_c(new EffectInstance(Effects.field_76420_g, isPlayerShoot ? 400 : 200, 1));
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197614_g;
    }

    public boolean getCritical() {
        return (Boolean)this.field_70180_af.func_187225_a(CRITICAL);
    }

    public void setCritical(boolean state) {
        this.field_70180_af.func_187227_b(CRITICAL, (Object)state);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("critical", this.getCritical());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCritical(compound.func_74767_n("critical"));
    }

    @Override
    public boolean canRenderSpecialEffect() {
        return this.getCritical();
    }
}

