/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.passive;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import otsunozi.nikkorihazard.entity.INikkoriModMob;
import otsunozi.nikkorihazard.entity.passive.AbstractMiniChest;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.util.NMobDropUtil;

public class EntityBossDropChest
extends AbstractMiniChest
implements INikkoriModMob {
    private static final Item[] DROP_NIKKORIMINATOR = new Item[]{Items.field_151042_j, Items.field_151042_j, Items.field_151043_k, Items.field_222087_nH, Items.field_151016_H};
    private static final Item[] DROP_OTSUROCK = new Item[]{Items.field_151166_bC, Items.field_151042_j, Items.field_151043_k, Items.field_221958_gk, Items.field_221695_cJ};
    private static final Item[] DROP_WOODHAMMER = new Item[]{Items.field_151042_j, Items.field_151043_k, Items.field_151166_bC, Items.field_151034_e};
    private static final DataParameter<Integer> CHEST_COLOR = EntityDataManager.func_187226_a(EntityBossDropChest.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int bossType;

    public EntityBossDropChest(EntityType<? extends EntityBossDropChest> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHEST_COLOR, (Object)0);
    }

    @Override
    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
        if (NMobDropUtil.isPlayerAttack((LivingEntity)this, attackedRecently)) {
            this.dropChestItem(damageSourceIn);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76364_f() instanceof PlayerEntity && source.func_76346_g() instanceof PlayerEntity) {
            return super.func_70097_a(source, damage);
        }
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, damage);
        }
        return false;
    }

    private void dropChestItem(DamageSource damageSourceIn) {
        int baseItemCount = 0;
        if (this.bossType == 0) {
            baseItemCount = this.field_70146_Z.nextInt(15) + 20;
            if (this.getChestColor() == 1) {
                baseItemCount += 10;
            }
            NMobDropUtil.dropItem((Entity)this, NCustomItem.NIKKORINIUM, this.field_70146_Z.nextInt(2) + 4);
            NMobDropUtil.dropBaseRandomItems((LivingEntity)this, damageSourceIn, DROP_NIKKORIMINATOR, baseItemCount, this.field_70146_Z, true, 0);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 10.0f, Items.field_151045_i, 2, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 50.0f, Items.field_151166_bC, this.field_70146_Z.nextInt(4) + 2, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 10.0f, NCustomItem.EGAOZIUM, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 20.0f, NCustomItem.NIKKORIKIBAN, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 20.0f, NCustomItem.NIKKORICHIP, this.field_70146_Z.nextInt(2) + 1, true);
        } else if (this.bossType == 1) {
            baseItemCount = this.field_70146_Z.nextInt(15) + 20;
            if (this.getChestColor() == 1) {
                baseItemCount += 10;
            }
            NMobDropUtil.dropItem((Entity)this, NCustomItem.NIKKORINIUM, this.field_70146_Z.nextInt(2) + 4);
            NMobDropUtil.dropBaseRandomItems((LivingEntity)this, damageSourceIn, DROP_NIKKORIMINATOR, baseItemCount, this.field_70146_Z, true, 0);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 10.0f, Items.field_151045_i, 2, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 50.0f, Items.field_151166_bC, this.field_70146_Z.nextInt(4) + 2, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 10.0f, NCustomItem.EGAOZIUM, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 20.0f, NCustomItem.NIKKORIKIBAN, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 20.0f, NCustomItem.NIKKORICHIP, this.field_70146_Z.nextInt(2) + 1, true);
        } else if (this.bossType == 2) {
            baseItemCount = this.field_70146_Z.nextInt(8) + 14;
            NMobDropUtil.dropBaseRandomItems((LivingEntity)this, damageSourceIn, DROP_OTSUROCK, baseItemCount, this.field_70146_Z, true, 0);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 20.0f, Items.field_151045_i, 1, true);
            for (int i = 0; i < 3; ++i) {
                NMobDropUtil.dropEnchantBook((LivingEntity)this, damageSourceIn, 10.0f, this.field_70146_Z.nextInt(26) + 31, true, 99, NMobDropUtil.DropBookKindSets.OTSUROCK);
            }
        } else if (this.bossType == 3) {
            baseItemCount = this.field_70146_Z.nextInt(8) + 14;
            NMobDropUtil.dropBaseRandomItems((LivingEntity)this, damageSourceIn, DROP_OTSUROCK, baseItemCount, this.field_70146_Z, true, 0);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 60.0f, Items.field_151045_i, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 70.0f, NCustomItem.LAVASTONE, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 5.0f, Items.field_221778_cy, 1, true);
            for (int i = 0; i < 3; ++i) {
                NMobDropUtil.dropEnchantBook((LivingEntity)this, damageSourceIn, 20.0f, this.field_70146_Z.nextInt(26) + 31, true, 99, NMobDropUtil.DropBookKindSets.OTSUROCK);
            }
        } else if (this.bossType == 4) {
            baseItemCount = this.field_70146_Z.nextInt(5) + 6;
            if (this.getChestColor() == 1) {
                baseItemCount += 7;
            }
            NMobDropUtil.dropBaseRandomItems((LivingEntity)this, damageSourceIn, DROP_WOODHAMMER, baseItemCount, this.field_70146_Z, true, 0);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 60.0f, NCustomItem.NIKKORIAPPLE_SEED, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 1.0f, NCustomItem.EGAOZIUM, 1, true);
            NMobDropUtil.dropItem((Entity)this, NCustomItem.NIKKORINIUM, this.field_70146_Z.nextInt(2) + 2);
        } else if (this.bossType == 5) {
            baseItemCount = this.field_70146_Z.nextInt(5) + 6;
            if (this.getChestColor() == 1) {
                baseItemCount += 7;
            }
            NMobDropUtil.dropBaseRandomItems((LivingEntity)this, damageSourceIn, DROP_WOODHAMMER, baseItemCount, this.field_70146_Z, true, 0);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 60.0f, NCustomItem.NIKKORIAPPLE_SEED, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 50.0f, NCustomItem.NIKKORIFERTILIZER, 1, true);
            NMobDropUtil.dropRareItem((LivingEntity)this, damageSourceIn, 3.0f, NCustomItem.EGAOZIUM, 1, true);
            NMobDropUtil.dropItem((Entity)this, NCustomItem.NIKKORINIUM, this.field_70146_Z.nextInt(2) + 2);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.getChestColor() == 1 && this.field_70170_p.field_72995_K && !this.field_70729_aU) {
            this.spawnBodyParticle();
        }
        super.func_70636_d();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void spawnBodyParticle() {
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197622_o, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.7) * (double)this.func_213311_cf(), this.func_226278_cu_() + (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.5, (this.field_70146_Z.nextDouble() - 0.5) * 1.2, (this.field_70146_Z.nextDouble() - 0.5) * 2.5);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.7) * (double)this.func_213311_cf(), this.func_226278_cu_() + (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.5, (this.field_70146_Z.nextDouble() - 0.5) * 1.2, (this.field_70146_Z.nextDouble() - 0.5) * 2.5);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("bosstype", this.bossType);
        compound.func_74768_a("chestcolor", this.getChestColor());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.bossType = compound.func_74762_e("bosstype");
        this.setChestColor(compound.func_74762_e("chestcolor"));
    }

    public int getChestColor() {
        return (Integer)this.field_70180_af.func_187225_a(CHEST_COLOR);
    }

    public void setChestColor(int state) {
        this.field_70180_af.func_187227_b(CHEST_COLOR, (Object)state);
    }

    public int getBossType() {
        return this.bossType;
    }

    public void setBossType(int bossType) {
        this.bossType = bossType;
    }
}

