/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.passive.merchant;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.INPC;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public abstract class AbstractNikkoriMerchant
extends CreatureEntity
implements INPC,
IMerchant {
    @Nullable
    private PlayerEntity customer;
    @Nullable
    protected MerchantOffers offers;
    private final Inventory villagerInventory = new Inventory(8);

    public AbstractNikkoriMerchant(EntityType<? extends AbstractNikkoriMerchant> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public int func_213708_dV() {
        return 0;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.customer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213703_a(@Nullable MerchantOffers offers) {
    }

    public void func_213702_q(int xpIn) {
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.onVillagerTrade(offer);
    }

    protected abstract void onVillagerTrade(MerchantOffer var1);

    public boolean func_213705_dZ() {
        return false;
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.getVillagerYesNoSound(!stack.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    protected SoundEvent getVillagerYesNoSound(boolean getYesSound) {
        return getYesSound ? SoundEvents.field_187915_go : SoundEvents.field_187913_gm;
    }

    public void playCelebrateSound() {
        this.func_184185_a(SoundEvents.field_219721_mv, this.func_70599_aP(), this.func_70647_i());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        MerchantOffers merchantoffers = this.func_213706_dY();
        if (!merchantoffers.isEmpty()) {
            compound.func_218657_a("Offers", (INBT)merchantoffers.func_222199_a());
        }
        compound.func_218657_a("Inventory", (INBT)this.villagerInventory.func_70487_g());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        this.villagerInventory.func_70486_a(compound.func_150295_c("Inventory", 10));
    }

    @Nullable
    public Entity changeDimension(ServerWorld server, ITeleporter teleporter) {
        this.resetCustomer();
        return super.changeDimension(server, teleporter);
    }

    protected void resetCustomer() {
        this.func_70932_a_(null);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.resetCustomer();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnParticles(IParticleData particleData) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(particleData, this.func_226282_d_(1.0), this.func_226279_cv_() + 1.0, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public Inventory getVillagerInventory() {
        return this.villagerInventory;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.villagerInventory.func_70302_i_()) {
            this.villagerInventory.func_70299_a(i, itemStackIn);
            return true;
        }
        return false;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    protected abstract void populateTradeData();

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241843_o(float partialTicks) {
        float f = MathHelper.func_219799_g((float)partialTicks, (float)this.field_70760_ar, (float)this.field_70761_aq) * ((float)Math.PI / 180);
        Vector3d vector3d = new Vector3d(0.0, this.func_174813_aQ().func_216360_c() - 1.0, 0.2);
        return this.func_242282_l(partialTicks).func_178787_e(vector3d.func_178785_b(-f));
    }
}

