/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.entity.passive.merchant;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import otsunozi.nikkorihazard.ai.EntityAILookAtCustomer;
import otsunozi.nikkorihazard.ai.EntityAITradeWithPlayer;
import otsunozi.nikkorihazard.entity.passive.merchant.AbstractNikkoriMerchant;
import otsunozi.nikkorihazard.entity.passive.merchant.MaskMerchantTrades;
import otsunozi.nikkorihazard.init.NCustomBlock;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.sound.CustomSound;

public class EntityMaskedMerchant
extends AbstractNikkoriMerchant {
    @Nullable
    private BlockPos wanderTarget;
    private int despawnDelay;
    private int choosedVeryRareNo = -1;
    private int choosedRareNo = -1;
    private int choosedCommonNo = -1;
    private int choosedLegendNo = -1;

    public EntityMaskedMerchant(EntityType<? extends EntityMaskedMerchant> type, World worldIn) {
        super(type, worldIn);
        this.field_98038_p = true;
        this.despawnDelay = 12000;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAITradeWithPlayer(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAILookAtCustomer(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveToGoal(this, 8.0, 0.45));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public static AttributeModifierMap.MutableAttribute setAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.31999999999999995);
    }

    @Override
    public boolean func_213705_dZ() {
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (itemstack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.hasCustomer() && !this.func_70631_g_()) {
            if (hand == Hand.MAIN_HAND) {
                playerIn.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(playerIn);
                this.func_213707_a(playerIn, this.func_145748_c_(), 1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(playerIn, hand);
    }

    @Override
    protected void populateTradeData() {
        List<MaskMerchantTrades.ITrade> list = this.chooseSellItems();
        if (!list.isEmpty()) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            for (MaskMerchantTrades.ITrade Itrade : list) {
                merchantoffers.add((Object)Itrade.getOffer((Entity)this, this.field_70146_Z));
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            compound.func_218657_a("WanderTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.wanderTarget));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("DespawnDelay", 99)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
        if (compound.func_74764_b("WanderTarget")) {
            this.wanderTarget = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("WanderTarget"));
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void onVillagerTrade(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    protected SoundEvent func_184639_G() {
        return this.hasCustomer() ? CustomSound.PAINTERS_LIVING : CustomSound.PAINTERS_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return CustomSound.PAINTERS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return CustomSound.PAINTERS_DEATH;
    }

    @Override
    protected SoundEvent getVillagerYesNoSound(boolean getYesSound) {
        return getYesSound ? CustomSound.MASKEDMERCHANT_YES : CustomSound.MASKEDMERCHANT_HURT;
    }

    @Override
    public SoundEvent func_213714_ea() {
        return SoundEvents.field_219724_nc;
    }

    public void setDespawnDelay(int delay) {
        this.despawnDelay = delay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.handleDespawn();
        }
    }

    private void handleDespawn() {
        if (this.despawnDelay > 0 && !this.hasCustomer() && --this.despawnDelay == 0) {
            this.func_70656_aK();
            this.func_70106_y();
        }
    }

    public static boolean getCanSpawnHere(EntityType<? extends CreatureEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175710_j(pos) && worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityMaskedMerchant.isValidLightLevelForPinecone(worldIn, pos, randomIn) && worldIn.func_226659_b_(pos, 0) > 7;
    }

    public static boolean isValidLightLevelForPinecone(IServerWorld worldIn, BlockPos pos, Random randomIn) {
        List list = worldIn.func_217369_A();
        if (worldIn.func_226658_a_(LightType.SKY, pos) < randomIn.nextInt(17) || worldIn.func_226658_a_(LightType.BLOCK, pos) > 7) {
            return false;
        }
        int i = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i >= randomIn.nextInt(8) + 8;
    }

    public void setWanderTarget(@Nullable BlockPos pos) {
        this.wanderTarget = pos;
    }

    @Nullable
    private BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    public List<MaskMerchantTrades.ITrade> chooseSellItems() {
        List<Object> list = Lists.newArrayList();
        int chance = this.field_70146_Z.nextInt(100);
        list = this.chooseItemsVeryRare(list);
        list = chance < 30 ? this.chooseItemsVeryRare(list) : this.chooseItemsRare(list);
        list = this.chooseItemsRare(list);
        list = this.chooseItemsRare(list);
        list = chance < 40 ? this.chooseItemsRare(list) : this.chooseItemsCommon(list);
        list = this.chooseItemsCommon(list);
        chance = this.field_70146_Z.nextInt(100);
        list = chance < 5 ? this.chooseItemsLegend(list) : (chance < 15 ? this.chooseItemsVeryRare(list) : (chance < 45 ? this.chooseItemsRare(list) : this.chooseItemsCommon(list)));
        return list;
    }

    private List<MaskMerchantTrades.ITrade> chooseItemsLegend(List<MaskMerchantTrades.ITrade> list) {
        int itemchoose = this.field_70146_Z.nextInt(7);
        for (int i = 0; i < 20; ++i) {
            if (itemchoose != this.choosedLegendNo) {
                this.choosedLegendNo = itemchoose;
                break;
            }
            itemchoose = this.field_70146_Z.nextInt(7);
        }
        switch (itemchoose) {
            case 0: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldBlocksTrade(NCustomItem.W_WEAPON_ENCHANTBOOK, 10));
                break;
            }
            case 1: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldBlocksTrade(NCustomItem.W_MAGIC_ENCHANTBOOK, 10));
                break;
            }
            case 2: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldBlocksTrade(NCustomItem.WH_WEAPON_ENCHANTBOOK, 14));
                break;
            }
            case 3: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldBlocksTrade(NCustomItem.WH_MAGIC_ENCHANTBOOK, 14));
                break;
            }
            case 4: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldBlocksTrade(NCustomItem.SP_MAGIC_ENCHANTBOOK, 14));
                break;
            }
            case 5: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldBlocksTrade(NCustomItem.SP_WEAPON_ENCHANTBOOK, 14));
                break;
            }
            case 6: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldBlocksTrade(NCustomItem.BLIZZARDSHOW_TICKET, 2));
            }
        }
        return list;
    }

    private List<MaskMerchantTrades.ITrade> chooseItemsVeryRare(List<MaskMerchantTrades.ITrade> list) {
        int itemchoose = this.field_70146_Z.nextInt(9);
        for (int i = 0; i < 20; ++i) {
            if (itemchoose != this.choosedVeryRareNo) {
                this.choosedVeryRareNo = itemchoose;
                break;
            }
            itemchoose = this.field_70146_Z.nextInt(9);
        }
        switch (itemchoose) {
            case 0: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SP_MAGIC_ENCHANTBOOK, 18));
                break;
            }
            case 1: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SP_WEAPON_ENCHANTBOOK, 18));
                break;
            }
            case 2: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomBlock.NIKKORI_ANVIL, 30));
                break;
            }
            case 3: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.EMERALDBLADE, 64));
                break;
            }
            case 4: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SOLAR_EARRINGS, 12));
                break;
            }
            case 5: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.BOOKOFNIKKORISUN, 5));
                break;
            }
            case 6: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.GREENSKULL_EARRINGS, 12));
                break;
            }
            case 7: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.COLLECTIONROD, 24));
                break;
            }
            case 8: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldBlocksTrade(NCustomItem.BLIZZARDSHOW_TICKET, 10));
            }
        }
        return list;
    }

    private List<MaskMerchantTrades.ITrade> chooseItemsRare(List<MaskMerchantTrades.ITrade> list) {
        int itemchoose = this.field_70146_Z.nextInt(11);
        for (int i = 0; i < 20; ++i) {
            if (itemchoose != this.choosedRareNo) {
                this.choosedRareNo = itemchoose;
                break;
            }
            itemchoose = this.field_70146_Z.nextInt(11);
        }
        switch (itemchoose) {
            case 0: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.NIKKORICHIP, 8));
                break;
            }
            case 1: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(Items.field_151153_ao, 32));
                break;
            }
            case 2: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.NIKKORIKIBAN, 10));
                break;
            }
            case 3: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(Items.field_151122_aG, 30));
                break;
            }
            case 4: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(Items.field_151073_bk, 3, 2));
                break;
            }
            case 5: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(Blocks.field_150335_W, 3, 8));
                break;
            }
            case 6: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.N_WEAPON_ENCHANTBOOK, 17));
                break;
            }
            case 7: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.N_MAGIC_ENCHANTBOOK, 17));
                break;
            }
            case 8: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.HEART_EARRINGS, 12));
                break;
            }
            case 9: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.NIKKORIAPPLE_SEED, 10));
                break;
            }
            case 10: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.NIKKORIORANGE_SEED, 10));
            }
        }
        return list;
    }

    private List<MaskMerchantTrades.ITrade> chooseItemsCommon(List<MaskMerchantTrades.ITrade> list) {
        int itemchoose = this.field_70146_Z.nextInt(13);
        for (int i = 0; i < 20; ++i) {
            if (itemchoose != this.choosedCommonNo) {
                this.choosedCommonNo = itemchoose;
                break;
            }
            itemchoose = this.field_70146_Z.nextInt(13);
        }
        switch (itemchoose) {
            case 0: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.FROZENBANANA, 6));
                break;
            }
            case 1: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(Items.field_151148_bJ, 2));
                break;
            }
            case 2: 
            case 3: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.ENERGYFISHROD, 3));
                break;
            }
            case 4: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomBlock.NIKKORI_LUNCH_BOX, 4));
                break;
            }
            case 5: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SEALED_WEAPON_ENCHANTBOOK_LV2, 10));
                break;
            }
            case 6: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SEALED_WEAPON_ENCHANTBOOK_LV3, 24));
                break;
            }
            case 7: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SEALED_MAGIC_ENCHANTBOOK_LV2, 10));
                break;
            }
            case 8: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SEALED_MAGIC_ENCHANTBOOK_LV3, 24));
                break;
            }
            case 9: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SAFETYMAGIC_ENCHANTBOOK, 4));
                break;
            }
            case 10: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.SUPER_SHIJIMI, 3, 3));
                break;
            }
            case 11: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.NIKKORIAPPLE, 2, 6));
                break;
            }
            case 12: {
                list.add(new MaskMerchantTrades.ItemsForEmeraldsTrade(NCustomItem.NIKKORIORANGE, 2, 6));
            }
        }
        return list;
    }

    class MoveToGoal
    extends Goal {
        final EntityMaskedMerchant traderEntity;
        final double maxDistance;
        final double speed;

        MoveToGoal(EntityMaskedMerchant traderEntityIn, double distanceIn, double speedIn) {
            this.traderEntity = traderEntityIn;
            this.maxDistance = distanceIn;
            this.speed = speedIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            this.traderEntity.setWanderTarget(null);
            EntityMaskedMerchant.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.traderEntity.getWanderTarget();
            return blockpos != null && this.isWithinDistance(blockpos, this.maxDistance);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.traderEntity.getWanderTarget();
            if (blockpos != null && EntityMaskedMerchant.this.field_70699_by.func_75500_f()) {
                if (this.isWithinDistance(blockpos, 10.0)) {
                    Vector3d vector3d = new Vector3d((double)blockpos.func_177958_n() - this.traderEntity.func_226277_ct_(), (double)blockpos.func_177956_o() - this.traderEntity.func_226278_cu_(), (double)blockpos.func_177952_p() - this.traderEntity.func_226281_cx_()).func_72432_b();
                    Vector3d vector3d1 = vector3d.func_186678_a(10.0).func_72441_c(this.traderEntity.func_226277_ct_(), this.traderEntity.func_226278_cu_(), this.traderEntity.func_226281_cx_());
                    EntityMaskedMerchant.this.field_70699_by.func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.speed);
                } else {
                    EntityMaskedMerchant.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speed);
                }
            }
        }

        private boolean isWithinDistance(BlockPos pos, double distance) {
            return !pos.func_218137_a((IPosition)this.traderEntity.func_213303_ch(), distance);
        }
    }
}

