/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.item.enchantbook;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import otsunozi.nikkorihazard.enchantment.NCustomEnchantmentHelper;

public abstract class AbstractItemNikkoriEnchantBook
extends Item {
    protected final int type;
    public boolean canEnchant;

    public AbstractItemNikkoriEnchantBook(int type, String name, Item.Properties properties) {
        super(properties);
        this.setRegistryName("nikkorihazard", name);
        this.type = type;
    }

    public int func_77619_b() {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.COMMON;
    }

    public static ListNBT getEnchantments(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null ? compoundnbt.func_150295_c("StoredEnchantments", 10) : new ListNBT();
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (this.canEnchant && entityLiving instanceof PlayerEntity) {
            PlayerEntity playerIn = (PlayerEntity)entityLiving;
            if (!worldIn.field_72995_K) {
                ItemStack weapon = playerIn.func_184586_b(Hand.OFF_HAND);
                if (!weapon.func_190926_b() && this.canEnchant) {
                    if (this.getSuccessRate() >= 100 || field_77697_d.nextInt(100) < this.getSuccessRate()) {
                        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("nc.msg.item.bookuse.notice0", new Object[]{weapon.func_200301_q()}).func_240699_a_(TextFormatting.DARK_AQUA), Util.field_240973_b_);
                        this.addEnchant(weapon);
                    } else {
                        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("nc.msg.item.bookuse.notice15", new Object[]{weapon.func_200301_q()}).func_240699_a_(TextFormatting.DARK_AQUA), Util.field_240973_b_);
                        if (playerIn != null) {
                            playerIn.func_213334_d(Hand.MAIN_HAND);
                        }
                    }
                    stack.func_190918_g(1);
                }
            } else {
                entityLiving.func_184185_a(SoundEvents.field_190021_aL, 1.0f, 1.0f);
            }
            playerIn.func_184811_cZ().func_185145_a((Item)this, 15);
        }
        return stack;
    }

    protected abstract int getSuccessRate();

    protected abstract void addEnchant(ItemStack var1);

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (handIn != Hand.MAIN_HAND) {
            this.canEnchant = false;
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        ItemStack weapon = playerIn.func_184586_b(Hand.OFF_HAND);
        if (!weapon.func_190926_b() && this.judgeWeaponType(weapon)) {
            if (!weapon.func_77948_v()) {
                this.canEnchant = true;
                return ActionResult.func_226249_b_((Object)itemstack);
            }
            if (worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("nc.msg.item.bookuse.notice3"), Util.field_240973_b_);
            }
        } else {
            TranslationTextComponent text = new TranslationTextComponent("nc.msg.item.bookuse.notice1");
            if (this.type == 1) {
                text = new TranslationTextComponent("nc.msg.item.bookuse.notice2");
            }
            if (worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)text, Util.field_240973_b_);
            }
        }
        this.canEnchant = false;
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public boolean judgeWeaponType(ItemStack weapon) {
        if (this.type == 0) {
            return NCustomEnchantmentHelper.canUseWeaponBook(weapon);
        }
        return NCustomEnchantmentHelper.canUseMagicBook(weapon);
    }

    public int getType() {
        return this.type;
    }
}

