/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import otsunozi.nikkorihazard.init.NCustomItem;

public abstract class AbstractItemMeleeWeapon
extends Item {
    public float attackDamage;
    public float attackSpeed;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;

    public AbstractItemMeleeWeapon(float attackDamage, float attackSpeed, Item.Properties properties) {
        super(properties);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_203425_a(Blocks.field_196553_aF)) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && !state.func_235714_a_((ITag)BlockTags.field_206952_E) && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_196553_aF);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        double hosei = (double)this.getWeaponLevel(stack) * 0.5;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getWeaponAttackDamage(stack), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.func_111205_h(slot);
    }

    public float getWeaponAttackDamage(ItemStack stack) {
        int level = this.getWeaponLevel(stack);
        int attackplus = MathHelper.func_76125_a((int)(level - 2), (int)0, (int)3);
        float hosei = (float)level * 0.5f + (float)attackplus * 0.5f;
        return this.attackDamage + hosei;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.melee"));
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.weapon_level", new Object[]{this.getWeaponLevel(stack), this.getReinforcementDifficult().getMaxLevel()}));
            tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.critical", new Object[]{this.getCriticalRate(stack)}));
            tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.critical_level", new Object[]{this.getCriticalLevel(stack), this.getMaxCriticalLevel()}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.shiftpushinfo"));
        }
        if (Screen.func_231172_r_()) {
            this.addSpecialInformation(stack, worldIn, tooltip, flagIn);
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.ctrlpush"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<ITextComponent> addSpecialInformation(ItemStack var1, @Nullable World var2, List<ITextComponent> var3, ITooltipFlag var4);

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> addSkillInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        return tooltip;
    }

    public int getCriticalRate(ItemStack stack) {
        return this.getCriticalRateBase() + this.getCriticalLevel(stack);
    }

    public abstract int getCriticalRateBase();

    public abstract int getMaxCriticalLevel();

    public int getWeaponLevel(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt.func_150297_b("weaponLevel", 3)) {
            return nbt.func_74762_e("weaponLevel");
        }
        return 0;
    }

    public int getCriticalLevel(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt.func_150297_b("criticalLevel", 3)) {
            return nbt.func_74762_e("criticalLevel");
        }
        return 0;
    }

    public AnvilRequireItem getReinforcementDifficult() {
        return AnvilRequireItem.NORMAL_MAXLV_5;
    }

    public boolean isMaxCriticalLevel(ItemStack stack) {
        if (stack.func_77973_b() instanceof AbstractItemMeleeWeapon) {
            AbstractItemMeleeWeapon weapon = (AbstractItemMeleeWeapon)stack.func_77973_b();
            return weapon.getCriticalLevel(stack) >= this.getMaxCriticalLevel();
        }
        return false;
    }

    public boolean isMaxLevel(ItemStack stack) {
        if (stack.func_77973_b() instanceof AbstractItemMeleeWeapon) {
            AbstractItemMeleeWeapon weapon = (AbstractItemMeleeWeapon)stack.func_77973_b();
            return weapon.getWeaponLevel(stack) >= this.getReinforcementDifficult().getMaxLevel();
        }
        return false;
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == NCustomItem.WEAPON_REPAIR_CREAM || super.func_82789_a(toRepair, repair);
    }

    public static enum AnvilRequireItem {
        OTEGARU_MAXLV_3(3, new int[]{2, 4, 6, 0, 0}, new int[]{0, 0, 0, 0, 0}, new int[]{5, 5, 10, 0, 0}),
        EASY_MAXLV_3(3, new int[]{3, 5, 7, 0, 0}, new int[]{0, 0, 0, 0, 0}, new int[]{5, 5, 10, 0, 0}),
        EASY_MAXLV_5(5, new int[]{3, 5, 7, 10, 13}, new int[]{0, 0, 0, 1, 1}, new int[]{5, 10, 10, 15, 15}),
        NORMAL_MAXLV_3(3, new int[]{6, 12, 18, 0, 0}, new int[]{0, 0, 0, 0, 0}, new int[]{10, 10, 15, 0, 0}),
        NORMAL_MAXLV_5(5, new int[]{6, 12, 18, 24, 32}, new int[]{0, 0, 0, 1, 1}, new int[]{10, 10, 15, 15, 20}),
        HARD_MAXLV_5(5, new int[]{10, 18, 30, 42, 54}, new int[]{0, 0, 0, 2, 2}, new int[]{15, 15, 20, 20, 25}),
        LEGEND_MAXLV_5(5, new int[]{32, 40, 48, 56, 64}, new int[]{1, 1, 2, 2, 3}, new int[]{15, 15, 20, 20, 25});

        private final int MAX_LEVEL;
        private final int[] NIKKORINIUM_REQUIRE_ARRAY;
        private final int[] EGAOZIUM_REQUIRE_ARRAY;
        private final int[] EXP_REQUIRE_ARRAY;

        private AnvilRequireItem(int maxLevel, int[] nikkorinium_count, int[] egaozium_count, int[] exp_count) {
            this.MAX_LEVEL = maxLevel;
            this.NIKKORINIUM_REQUIRE_ARRAY = nikkorinium_count;
            this.EGAOZIUM_REQUIRE_ARRAY = egaozium_count;
            this.EXP_REQUIRE_ARRAY = exp_count;
        }

        public int getMaxLevel() {
            return this.MAX_LEVEL;
        }

        public int getRequireNikkorinium(int nextWeaponLevel) {
            try {
                return this.NIKKORINIUM_REQUIRE_ARRAY[nextWeaponLevel];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return 99;
            }
        }

        public int getRequireEgaozium(int nextWeaponLevel) {
            try {
                return this.EGAOZIUM_REQUIRE_ARRAY[nextWeaponLevel];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return 99;
            }
        }

        public int getRequireEXP(int nextWeaponLevel) {
            try {
                return this.EXP_REQUIRE_ARRAY[nextWeaponLevel - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return 99;
            }
        }
    }
}

