/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.item.weapon.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import otsunozi.nikkorihazard.enchantment.NCustomEnchantmentHelper;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.sound.CustomSound;
import otsunozi.nikkorihazard.util.NCustomDamageSource;

public abstract class AbstractItemMagicWeapon
extends Item {
    private final float magicDamage;
    private final float ampMultiplier;
    private final float attackDamage;
    protected final float speedBase;
    private final float speedBoost;
    private final float exhaustionBase;
    private final float exhaustionBoost;
    private final int chargeType;
    private final int flyTimeBase;
    private final int flyTimeBoost;
    private int maxChargeTime;

    public AbstractItemMagicWeapon(Item.Properties properties) {
        super(properties);
        this.magicDamage = 1.0f;
        this.attackDamage = 1.0f;
        this.ampMultiplier = 1.0f;
        this.speedBase = 1.0f;
        this.speedBoost = 1.0f;
        this.exhaustionBase = 1.0f;
        this.exhaustionBoost = 1.0f;
        this.chargeType = 0;
        this.flyTimeBase = 10;
        this.flyTimeBoost = 10;
        this.maxChargeTime = 20;
    }

    public AbstractItemMagicWeapon(int chargeType, float attackDamage, float magicDamage, float ampMultiplier, float speedBase, float speedBoost, float exhaustionBase, float exhaustionBoost, int flyTimeBase, int flyTimeBoost, Item.Properties properties) {
        super(properties);
        this.magicDamage = magicDamage;
        this.attackDamage = attackDamage;
        this.ampMultiplier = ampMultiplier;
        this.speedBase = speedBase;
        this.speedBoost = speedBoost;
        this.exhaustionBase = exhaustionBase;
        this.exhaustionBoost = exhaustionBoost;
        this.chargeType = chargeType;
        this.flyTimeBase = flyTimeBase;
        this.flyTimeBoost = flyTimeBoost;
        this.maxChargeTime = 20;
    }

    public AbstractItemMagicWeapon(int chargeType, float attackDamage, float magicDamage, float ampMultiplier, float speedBase, float speedBoost, float exhaustionBase, float exhaustionBoost, int flyTimeBase, int flyTimeBoost, int maxChargeTime, Item.Properties properties) {
        this(chargeType, attackDamage, magicDamage, ampMultiplier, speedBase, speedBoost, exhaustionBase, exhaustionBoost, flyTimeBase, flyTimeBoost, properties);
        this.maxChargeTime = maxChargeTime;
    }

    protected int getMagicDamage(ItemStack stack, float chargeTime, boolean isInformation) {
        if (this.chargeType == 0 && !isInformation) {
            return (int)MathHelper.func_76132_a((double)1.0, (double)(chargeTime * (this.magicDamage + (float)MathHelper.func_76123_f((float)((float)NCustomEnchantmentHelper.getMagicAmpLevel(stack) * this.ampMultiplier)))));
        }
        return (int)(this.magicDamage + (float)MathHelper.func_76123_f((float)((float)NCustomEnchantmentHelper.getMagicAmpLevel(stack) * this.ampMultiplier)));
    }

    protected float getMagicSpeed(ItemStack stack) {
        return this.speedBase + this.speedBoost * (float)NCustomEnchantmentHelper.getMagicBoosterLevel(stack);
    }

    protected int getFlyTime(float chargeTime) {
        if (this.chargeType == 0) {
            return (int)((float)this.flyTimeBase + chargeTime * (float)this.flyTimeBoost);
        }
        return this.flyTimeBase;
    }

    protected boolean chackExhaustion(ItemStack stack, PlayerEntity playerIn) {
        return NCustomEnchantmentHelper.hasHaraherazu(stack) || playerIn.func_71024_bL().func_75116_a() > 0;
    }

    protected void magicExhaustion(ItemStack stack, PlayerEntity playerIn, float chargeTime) {
        if (!NCustomEnchantmentHelper.hasHaraherazu(stack)) {
            if (this.chargeType == 0) {
                playerIn.func_71020_j(this.exhaustionBase + chargeTime * this.exhaustionBoost);
            } else {
                playerIn.func_71020_j(this.exhaustionBase);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (this.chargeType == 2) {
            return;
        }
        PlayerEntity playerIn = (PlayerEntity)entityLiving;
        boolean successAttack = false;
        int i = this.func_77626_a(stack) - timeLeft;
        float chargeTime = this.getChargeTime(i, stack);
        if (this.chackExhaustion(stack, playerIn)) {
            if (this.chargeType == 0 && (double)chargeTime >= 0.1) {
                successAttack = true;
            } else if (this.chargeType == 1 && chargeTime >= 1.0f) {
                successAttack = true;
            }
        }
        if (successAttack) {
            if (!worldIn.field_72995_K) {
                stack.func_222118_a(1, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                this.magicExhaustion(stack, playerIn, chargeTime);
                int magicdamagetrue = this.getMagicDamage(stack, chargeTime, false);
                float speed = this.getMagicSpeed(stack);
                boolean canBounds = NCustomEnchantmentHelper.hasBounds(stack);
                int criticalLevel = NCustomEnchantmentHelper.getMagicCriticalLevel(stack);
                int criticalWithEnch = NCustomDamageSource.getCriticalChanceForMagicCriticalEnch(criticalLevel);
                int criticalPlus = this.getCriticalPlusBase() + this.getCriticalPlus(worldIn, playerIn, magicdamagetrue, criticalLevel, chargeTime);
                int criticalChance = criticalPlus + criticalWithEnch;
                if (NCustomEnchantmentHelper.hasSealedCritical(stack)) {
                    criticalChance = 0;
                }
                int flyTime = this.getFlyTime(chargeTime);
                boolean hasSafetyMagic = NCustomEnchantmentHelper.hasSafetyMagic(stack);
                this.shootMagic(stack, worldIn, playerIn, magicdamagetrue, criticalChance, speed, canBounds, chargeTime, flyTime, hasSafetyMagic);
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
            this.playShootSound(worldIn, playerIn, chargeTime);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        if (this.chargeType != 2) {
            return ActionResult.func_226249_b_((Object)stack);
        }
        boolean successAttack = false;
        if (this.chackExhaustion(stack, playerIn)) {
            successAttack = true;
        }
        if (successAttack) {
            if (!worldIn.field_72995_K) {
                stack.func_222118_a(1, (LivingEntity)playerIn, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                this.magicExhaustion(stack, playerIn, 0.0f);
                int magicdamagetrue = this.getMagicDamage(stack, 0.0f, false);
                float speed = this.getMagicSpeed(stack);
                boolean canBounds = NCustomEnchantmentHelper.hasBounds(stack);
                int criticalLevel = NCustomEnchantmentHelper.getMagicCriticalLevel(stack);
                int criticalWithEnch = NCustomDamageSource.getCriticalChanceForMagicCriticalEnch(criticalLevel);
                int criticalPlus = this.getCriticalPlusBase() + this.getCriticalPlus(worldIn, playerIn, magicdamagetrue, criticalLevel, 0.0f);
                int criticalChance = criticalPlus + criticalWithEnch;
                if (NCustomEnchantmentHelper.hasSealedCritical(stack)) {
                    criticalChance = 0;
                }
                int flyTime = this.getFlyTime(0.0f);
                boolean hasSafetyMagic = NCustomEnchantmentHelper.hasSafetyMagic(stack);
                this.shootMagic(stack, worldIn, playerIn, magicdamagetrue, criticalChance, speed, canBounds, 0.0f, flyTime, hasSafetyMagic);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            this.playShootSound(worldIn, playerIn, 0.0f);
        }
        return ActionResult.func_226249_b_((Object)stack);
    }

    protected abstract void shootMagic(ItemStack var1, World var2, PlayerEntity var3, int var4, int var5, float var6, boolean var7, float var8, int var9, boolean var10);

    protected int getCriticalChance(ItemStack stack) {
        return this.getCriticalPlusBase() + NCustomDamageSource.getCriticalChanceForMagicCriticalEnch(NCustomEnchantmentHelper.getMagicCriticalLevel(stack));
    }

    protected int getCriticalPlus(World worldIn, PlayerEntity playerIn, int magicDamage, int criticalLevel, float chargeTime) {
        int critical = 0;
        if (playerIn.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == NCustomItem.CHESTPLATE_NIKKORIBEETLE && playerIn.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() == NCustomItem.LEGGINGS_NIKKORIBEETLE && playerIn.func_184582_a(EquipmentSlotType.FEET).func_77973_b() == NCustomItem.BOOTS_NIKKORIBEETLE) {
            critical += 10;
        }
        return critical;
    }

    protected abstract int getCriticalPlusBase();

    protected int getTotalMaxChargeTime(ItemStack stack) {
        int quickChargeLevel = NCustomEnchantmentHelper.getQuickChargeLevel(stack);
        return quickChargeLevel > 0 ? this.maxChargeTime - this.maxChargeTime * quickChargeLevel / 10 : this.maxChargeTime;
    }

    protected abstract void playShootSound(World var1, PlayerEntity var2, float var3);

    protected float getChargeTime(int charge, ItemStack stack) {
        float f = (float)charge / (float)this.getTotalMaxChargeTime(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(1, (ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.magic"));
        tooltip.add(2, (ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.magichowtouse"));
        switch (this.chargeType) {
            case 0: {
                tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.magichowtouse_lcc"));
                break;
            }
            case 1: {
                tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.magichowtouse_lccm"));
                break;
            }
            case 2: {
                tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.magichowtouse_lc"));
                break;
            }
            default: {
                tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.magichowtouse_lcc"));
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.magichowtouse_mnpk"));
        if (Screen.func_231173_s_()) {
            this.addSpecialInformation(stack, worldIn, tooltip, flagIn);
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.shiftpush"));
        }
        tooltip.add((ITextComponent)new StringTextComponent(""));
        if (this.chargeType == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.maxmagicdamage", new Object[]{this.getMagicDamage(stack, 0.0f, true)}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.magicdamage", new Object[]{this.getMagicDamage(stack, 0.0f, true)}));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("nc.msg.item.weaponinfo.critical", new Object[]{this.getCriticalChance(stack)}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<ITextComponent> addSpecialInformation(ItemStack var1, @Nullable World var2, List<ITextComponent> var3, ITooltipFlag var4);

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return false;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (this.chargeType != 2) {
            if (this.chargeType == 0) {
                if (count == stack.func_77988_m() - 2) {
                    player.func_184185_a(CustomSound.MAGIC_CHARGE_01, 0.1f, 1.0f);
                }
                if (count == stack.func_77988_m() - this.getTotalMaxChargeTime(stack) / 2) {
                    player.func_184185_a(CustomSound.MAGIC_CHARGE_02, 0.1f, 1.0f);
                }
            }
            if (count == stack.func_77988_m() - (this.getTotalMaxChargeTime(stack) - 2)) {
                player.func_184185_a(CustomSound.MAGIC_CHARGE_03, 0.1f, 1.0f);
            }
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == NCustomItem.WEAPON_REPAIR_CREAM || super.func_82789_a(toRepair, repair);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(5, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public int func_77619_b() {
        return 1;
    }
}

